/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.apache.http.client.entity;

import ai.h2o.org.apache.http.Header;
import ai.h2o.org.apache.http.HttpEntity;
import ai.h2o.org.apache.http.client.entity.InputStreamFactory;
import ai.h2o.org.apache.http.client.entity.LazyDecompressingInputStream;
import ai.h2o.org.apache.http.entity.HttpEntityWrapper;
import ai.h2o.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DecompressingEntity
extends HttpEntityWrapper {
    private static final int BUFFER_SIZE = 2048;
    private final InputStreamFactory inputStreamFactory;
    private InputStream content;

    public DecompressingEntity(HttpEntity wrapped, InputStreamFactory inputStreamFactory) {
        super(wrapped);
        this.inputStreamFactory = inputStreamFactory;
    }

    private InputStream getDecompressingStream() throws IOException {
        InputStream in = this.wrappedEntity.getContent();
        return new LazyDecompressingInputStream(in, this.inputStreamFactory);
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.wrappedEntity.isStreaming()) {
            if (this.content == null) {
                this.content = this.getDecompressingStream();
            }
            return this.content;
        }
        return this.getDecompressingStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "Output stream");
        InputStream inStream = this.getContent();
        try {
            int l2;
            byte[] buffer = new byte[2048];
            while ((l2 = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, l2);
            }
        }
        finally {
            inStream.close();
        }
    }

    @Override
    public Header getContentEncoding() {
        return null;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }
}

