/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.expr;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.expr.Cast;
import ai.h2o.javassist.expr.ConstructorCall;
import ai.h2o.javassist.expr.Expr;
import ai.h2o.javassist.expr.FieldAccess;
import ai.h2o.javassist.expr.Handler;
import ai.h2o.javassist.expr.Instanceof;
import ai.h2o.javassist.expr.MethodCall;
import ai.h2o.javassist.expr.NewArray;
import ai.h2o.javassist.expr.NewExpr;

public class ExprEditor {
    public boolean doit(CtClass clazz, MethodInfo minfo) throws CannotCompileException {
        CodeAttribute codeAttr = minfo.getCodeAttribute();
        if (codeAttr == null) {
            return false;
        }
        CodeIterator iterator = codeAttr.iterator();
        boolean edited = false;
        LoopContext context = new LoopContext(codeAttr.getMaxLocals());
        while (iterator.hasNext()) {
            if (!this.loopBody(iterator, clazz, minfo, context)) continue;
            edited = true;
        }
        ExceptionTable et = codeAttr.getExceptionTable();
        int n2 = et.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Handler h2 = new Handler(et, i2, iterator, clazz, minfo);
            this.edit(h2);
            if (!h2.edited()) continue;
            edited = true;
            context.updateMax(h2.locals(), h2.stack());
        }
        if (codeAttr.getMaxLocals() < context.maxLocals) {
            codeAttr.setMaxLocals(context.maxLocals);
        }
        codeAttr.setMaxStack(codeAttr.getMaxStack() + context.maxStack);
        try {
            if (edited) {
                minfo.rebuildStackMapIf6(clazz.getClassPool(), clazz.getClassFile2());
            }
        }
        catch (BadBytecode b2) {
            throw new CannotCompileException(b2.getMessage(), b2);
        }
        return edited;
    }

    boolean doit(CtClass clazz, MethodInfo minfo, LoopContext context, CodeIterator iterator, int endPos) throws CannotCompileException {
        boolean edited = false;
        while (iterator.hasNext() && iterator.lookAhead() < endPos) {
            int size = iterator.getCodeLength();
            if (!this.loopBody(iterator, clazz, minfo, context)) continue;
            edited = true;
            int size2 = iterator.getCodeLength();
            if (size == size2) continue;
            endPos += size2 - size;
        }
        return edited;
    }

    final boolean loopBody(CodeIterator iterator, CtClass clazz, MethodInfo minfo, LoopContext context) throws CannotCompileException {
        try {
            Expr expr2 = null;
            int pos = iterator.next();
            int c2 = iterator.byteAt(pos);
            if (c2 >= 178) {
                if (c2 < 188) {
                    if (c2 == 184 || c2 == 185 || c2 == 182) {
                        expr2 = new MethodCall(pos, iterator, clazz, minfo);
                        this.edit((MethodCall)expr2);
                    } else if (c2 == 180 || c2 == 178 || c2 == 181 || c2 == 179) {
                        expr2 = new FieldAccess(pos, iterator, clazz, minfo, c2);
                        this.edit((FieldAccess)expr2);
                    } else if (c2 == 187) {
                        int index = iterator.u16bitAt(pos + 1);
                        context.newList = new NewOp(context.newList, pos, minfo.getConstPool().getClassInfo(index));
                    } else if (c2 == 183) {
                        NewOp newList = context.newList;
                        if (newList != null && minfo.getConstPool().isConstructor(newList.type, iterator.u16bitAt(pos + 1)) > 0) {
                            expr2 = new NewExpr(pos, iterator, clazz, minfo, newList.type, newList.pos);
                            this.edit((NewExpr)expr2);
                            context.newList = newList.next;
                        } else {
                            MethodCall mcall = new MethodCall(pos, iterator, clazz, minfo);
                            if (mcall.getMethodName().equals("<init>")) {
                                ConstructorCall ccall = new ConstructorCall(pos, iterator, clazz, minfo);
                                expr2 = ccall;
                                this.edit(ccall);
                            } else {
                                expr2 = mcall;
                                this.edit(mcall);
                            }
                        }
                    }
                } else if (c2 == 188 || c2 == 189 || c2 == 197) {
                    expr2 = new NewArray(pos, iterator, clazz, minfo, c2);
                    this.edit((NewArray)expr2);
                } else if (c2 == 193) {
                    expr2 = new Instanceof(pos, iterator, clazz, minfo);
                    this.edit((Instanceof)expr2);
                } else if (c2 == 192) {
                    expr2 = new Cast(pos, iterator, clazz, minfo);
                    this.edit((Cast)expr2);
                }
            }
            if (expr2 != null && expr2.edited()) {
                context.updateMax(expr2.locals(), expr2.stack());
                return true;
            }
            return false;
        }
        catch (BadBytecode e2) {
            throw new CannotCompileException(e2);
        }
    }

    public void edit(NewExpr e2) throws CannotCompileException {
    }

    public void edit(NewArray a2) throws CannotCompileException {
    }

    public void edit(MethodCall m4) throws CannotCompileException {
    }

    public void edit(ConstructorCall c2) throws CannotCompileException {
    }

    public void edit(FieldAccess f2) throws CannotCompileException {
    }

    public void edit(Instanceof i2) throws CannotCompileException {
    }

    public void edit(Cast c2) throws CannotCompileException {
    }

    public void edit(Handler h2) throws CannotCompileException {
    }

    static final class LoopContext {
        NewOp newList;
        int maxLocals;
        int maxStack;

        LoopContext(int locals) {
            this.maxLocals = locals;
            this.maxStack = 0;
            this.newList = null;
        }

        void updateMax(int locals, int stack) {
            if (this.maxLocals < locals) {
                this.maxLocals = locals;
            }
            if (this.maxStack < stack) {
                this.maxStack = stack;
            }
        }
    }

    static final class NewOp {
        NewOp next;
        int pos;
        String type;

        NewOp(NewOp n2, int p2, String t2) {
            this.next = n2;
            this.pos = p2;
            this.type = t2;
        }
    }
}

