/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.common.math;

import ai.h2o.com.google.common.annotations.GwtIncompatible;
import ai.h2o.com.google.common.base.Preconditions;
import ai.h2o.com.google.common.math.DoubleUtils;
import ai.h2o.com.google.common.math.ElementTypesAreNonnullByDefault;
import ai.h2o.com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class ToDoubleRounder<X extends Number> {
    ToDoubleRounder() {
    }

    abstract double roundToDoubleArbitrarily(X var1);

    abstract int sign(X var1);

    abstract X toX(double var1, RoundingMode var3);

    abstract X minus(X var1, X var2);

    final double roundToDouble(X x2, RoundingMode mode) {
        Preconditions.checkNotNull(x2, "x");
        Preconditions.checkNotNull(mode, "mode");
        double roundArbitrarily = this.roundToDoubleArbitrarily(x2);
        if (Double.isInfinite(roundArbitrarily)) {
            switch (mode) {
                case DOWN: 
                case HALF_EVEN: 
                case HALF_DOWN: 
                case HALF_UP: {
                    return Double.MAX_VALUE * (double)this.sign(x2);
                }
                case FLOOR: {
                    return roundArbitrarily == Double.POSITIVE_INFINITY ? Double.MAX_VALUE : Double.NEGATIVE_INFINITY;
                }
                case CEILING: {
                    return roundArbitrarily == Double.POSITIVE_INFINITY ? Double.POSITIVE_INFINITY : -1.7976931348623157E308;
                }
                case UP: {
                    return roundArbitrarily;
                }
                case UNNECESSARY: {
                    String string = String.valueOf(x2);
                    throw new ArithmeticException(new StringBuilder(44 + String.valueOf(string).length()).append(string).append(" cannot be represented precisely as a double").toString());
                }
            }
        }
        X roundArbitrarilyAsX = this.toX(roundArbitrarily, RoundingMode.UNNECESSARY);
        int cmpXToRoundArbitrarily = ((Comparable)x2).compareTo(roundArbitrarilyAsX);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(cmpXToRoundArbitrarily == 0);
                return roundArbitrarily;
            }
            case FLOOR: {
                return cmpXToRoundArbitrarily >= 0 ? roundArbitrarily : DoubleUtils.nextDown(roundArbitrarily);
            }
            case CEILING: {
                return cmpXToRoundArbitrarily <= 0 ? roundArbitrarily : Math.nextUp(roundArbitrarily);
            }
            case DOWN: {
                if (this.sign(x2) >= 0) {
                    return cmpXToRoundArbitrarily >= 0 ? roundArbitrarily : DoubleUtils.nextDown(roundArbitrarily);
                }
                return cmpXToRoundArbitrarily <= 0 ? roundArbitrarily : Math.nextUp(roundArbitrarily);
            }
            case UP: {
                if (this.sign(x2) >= 0) {
                    return cmpXToRoundArbitrarily <= 0 ? roundArbitrarily : Math.nextUp(roundArbitrarily);
                }
                return cmpXToRoundArbitrarily >= 0 ? roundArbitrarily : DoubleUtils.nextDown(roundArbitrarily);
            }
            case HALF_EVEN: 
            case HALF_DOWN: 
            case HALF_UP: {
                X roundCeiling;
                double roundCeilingAsDouble;
                X roundFloor;
                double roundFloorAsDouble;
                if (cmpXToRoundArbitrarily >= 0) {
                    roundFloorAsDouble = roundArbitrarily;
                    roundFloor = roundArbitrarilyAsX;
                    roundCeilingAsDouble = Math.nextUp(roundArbitrarily);
                    if (roundCeilingAsDouble == Double.POSITIVE_INFINITY) {
                        return roundFloorAsDouble;
                    }
                    roundCeiling = this.toX(roundCeilingAsDouble, RoundingMode.CEILING);
                } else {
                    roundCeilingAsDouble = roundArbitrarily;
                    roundCeiling = roundArbitrarilyAsX;
                    roundFloorAsDouble = DoubleUtils.nextDown(roundArbitrarily);
                    if (roundFloorAsDouble == Double.NEGATIVE_INFINITY) {
                        return roundCeilingAsDouble;
                    }
                    roundFloor = this.toX(roundFloorAsDouble, RoundingMode.FLOOR);
                }
                X deltaToFloor = this.minus(x2, roundFloor);
                X deltaToCeiling = this.minus(roundCeiling, x2);
                int diff = ((Comparable)deltaToFloor).compareTo(deltaToCeiling);
                if (diff < 0) {
                    return roundFloorAsDouble;
                }
                if (diff > 0) {
                    return roundCeilingAsDouble;
                }
                switch (mode) {
                    case HALF_EVEN: {
                        return (Double.doubleToRawLongBits(roundFloorAsDouble) & 1L) == 0L ? roundFloorAsDouble : roundCeilingAsDouble;
                    }
                    case HALF_DOWN: {
                        return this.sign(x2) >= 0 ? roundFloorAsDouble : roundCeilingAsDouble;
                    }
                    case HALF_UP: {
                        return this.sign(x2) >= 0 ? roundCeilingAsDouble : roundFloorAsDouble;
                    }
                }
                throw new AssertionError((Object)"impossible");
            }
        }
        throw new AssertionError((Object)"impossible");
    }
}

