/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.common.math;

import ai.h2o.com.google.common.annotations.GwtCompatible;
import ai.h2o.com.google.common.math.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;

@ElementTypesAreNonnullByDefault
@GwtCompatible
@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(String role, int x2) {
        if (x2 <= 0) {
            throw new IllegalArgumentException(new StringBuilder(26 + String.valueOf(role).length()).append(role).append(" (").append(x2).append(") must be > 0").toString());
        }
        return x2;
    }

    static long checkPositive(String role, long x2) {
        if (x2 <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(role).length()).append(role).append(" (").append(x2).append(") must be > 0").toString());
        }
        return x2;
    }

    static BigInteger checkPositive(String role, BigInteger x2) {
        if (x2.signum() <= 0) {
            String string = String.valueOf(x2);
            throw new IllegalArgumentException(new StringBuilder(15 + String.valueOf(role).length() + String.valueOf(string).length()).append(role).append(" (").append(string).append(") must be > 0").toString());
        }
        return x2;
    }

    static int checkNonNegative(String role, int x2) {
        if (x2 < 0) {
            throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(role).length()).append(role).append(" (").append(x2).append(") must be >= 0").toString());
        }
        return x2;
    }

    static long checkNonNegative(String role, long x2) {
        if (x2 < 0L) {
            throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(role).length()).append(role).append(" (").append(x2).append(") must be >= 0").toString());
        }
        return x2;
    }

    static BigInteger checkNonNegative(String role, BigInteger x2) {
        if (x2.signum() < 0) {
            String string = String.valueOf(x2);
            throw new IllegalArgumentException(new StringBuilder(16 + String.valueOf(role).length() + String.valueOf(string).length()).append(role).append(" (").append(string).append(") must be >= 0").toString());
        }
        return x2;
    }

    static double checkNonNegative(String role, double x2) {
        if (!(x2 >= 0.0)) {
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(role).length()).append(role).append(" (").append(x2).append(") must be >= 0").toString());
        }
        return x2;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition, double input, RoundingMode mode) {
        if (!condition) {
            String string = String.valueOf((Object)mode);
            throw new ArithmeticException(new StringBuilder(83 + String.valueOf(string).length()).append("rounded value is out of range for input ").append(input).append(" and rounding mode ").append(string).toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a2, int b2) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder(36 + String.valueOf(methodName).length()).append("overflow: ").append(methodName).append("(").append(a2).append(", ").append(b2).append(")").toString());
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, long a2, long b2) {
        if (!condition) {
            throw new ArithmeticException(new StringBuilder(54 + String.valueOf(methodName).length()).append("overflow: ").append(methodName).append("(").append(a2).append(", ").append(b2).append(")").toString());
        }
    }

    private MathPreconditions() {
    }
}

