/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.common.collect;

import ai.h2o.com.google.common.annotations.GwtCompatible;
import ai.h2o.com.google.common.base.Preconditions;
import ai.h2o.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ai.h2o.com.google.common.collect.ImmutableCollection;
import ai.h2o.com.google.common.collect.ImmutableList;
import ai.h2o.com.google.common.collect.ImmutableMap;
import ai.h2o.com.google.common.collect.ImmutableMapEntrySet;
import ai.h2o.com.google.common.collect.ImmutableMapKeySet;
import ai.h2o.com.google.common.collect.ImmutableMapValues;
import ai.h2o.com.google.common.collect.ImmutableSet;
import ai.h2o.com.google.common.collect.Maps;
import ai.h2o.com.google.common.collect.RegularImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n2, @Nullable Map.Entry<K, V>[] entryArray) {
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            entryArray[i2] = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i2]));
            V oldValue = delegateMap.putIfAbsent(entryArray[i2].getKey(), entryArray[i2].getValue());
            if (oldValue == null) continue;
            String string = String.valueOf(entryArray[i2].getKey());
            String string2 = String.valueOf(oldValue);
            throw JdkBackedImmutableMap.conflictException("key", entryArray[i2], new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
        }
        return new JdkBackedImmutableMap(delegateMap, ImmutableList.asImmutableList(entryArray, n2));
    }

    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries) {
        this.delegateMap = delegateMap;
        this.entries = entries;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        return this.delegateMap.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)e2 -> action.accept((Object)e2.getKey(), (Object)e2.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

