/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.util;

import ai.h2o.com.amazonaws.internal.SdkFilterInputStream;
import ai.h2o.com.amazonaws.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class NamespaceRemovingInputStream
extends SdkFilterInputStream {
    private byte[] lookAheadData = new byte[200];
    private boolean hasRemovedNamespace = false;

    public NamespaceRemovingInputStream(InputStream in) {
        super(new BufferedInputStream(in));
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        int b2 = this.in.read();
        if (b2 == 120 && !this.hasRemovedNamespace) {
            this.lookAheadData[0] = (byte)b2;
            this.in.mark(this.lookAheadData.length);
            int bytesRead = this.in.read(this.lookAheadData, 1, this.lookAheadData.length - 1);
            this.in.reset();
            String string = new String(this.lookAheadData, 0, bytesRead + 1, StringUtils.UTF8);
            int numberCharsMatched = this.matchXmlNamespaceAttribute(string);
            if (numberCharsMatched > 0) {
                for (int i2 = 0; i2 < numberCharsMatched - 1; ++i2) {
                    this.in.read();
                }
                b2 = this.in.read();
                this.hasRemovedNamespace = true;
            }
        }
        return b2;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        for (int i2 = 0; i2 < len; ++i2) {
            int j2 = this.read();
            if (j2 == -1) {
                if (i2 == 0) {
                    return -1;
                }
                return i2;
            }
            b2[i2 + off] = (byte)j2;
        }
        return len;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    private int matchXmlNamespaceAttribute(String s2) {
        StringPrefixSlicer stringSlicer = new StringPrefixSlicer(s2);
        if (!stringSlicer.removePrefix("xmlns")) {
            return -1;
        }
        stringSlicer.removeRepeatingPrefix(" ");
        if (!stringSlicer.removePrefix("=")) {
            return -1;
        }
        stringSlicer.removeRepeatingPrefix(" ");
        if (!stringSlicer.removePrefix("\"")) {
            return -1;
        }
        if (!stringSlicer.removePrefixEndingWith("\"")) {
            return -1;
        }
        return s2.length() - stringSlicer.getString().length();
    }

    private static final class StringPrefixSlicer {
        private String s;

        public StringPrefixSlicer(String s2) {
            this.s = s2;
        }

        public String getString() {
            return this.s;
        }

        public boolean removePrefix(String prefix) {
            if (!this.s.startsWith(prefix)) {
                return false;
            }
            this.s = this.s.substring(prefix.length());
            return true;
        }

        public boolean removeRepeatingPrefix(String prefix) {
            if (!this.s.startsWith(prefix)) {
                return false;
            }
            while (this.s.startsWith(prefix)) {
                this.s = this.s.substring(prefix.length());
            }
            return true;
        }

        public boolean removePrefixEndingWith(String marker) {
            int i2 = this.s.indexOf(marker);
            if (i2 < 0) {
                return false;
            }
            this.s = this.s.substring(i2 + marker.length());
            return true;
        }
    }
}

