/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.transform;

import ai.h2o.com.amazonaws.AmazonServiceException;
import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.annotation.ThreadSafe;
import ai.h2o.com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.node.NullNode;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        if (jsonContent == null || NullNode.instance.equals((Object)jsonContent)) {
            return null;
        }
        return (AmazonServiceException)MAPPER.treeToValue((TreeNode)jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            MAPPER.setPropertyNamingStrategy(PropertyNamingStrategies.UPPER_CAMEL_CASE);
        }
        catch (LinkageError e2) {
            MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.PASCAL_CASE_TO_CAMEL_CASE);
        }
    }
}

