/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.model.transform;

import ai.h2o.com.amazonaws.services.s3.internal.XmlWriter;
import ai.h2o.com.amazonaws.services.s3.model.lifecycle.LifecycleAndOperator;
import ai.h2o.com.amazonaws.services.s3.model.lifecycle.LifecycleFilterPredicate;
import ai.h2o.com.amazonaws.services.s3.model.lifecycle.LifecycleObjectSizeGreaterThanPredicate;
import ai.h2o.com.amazonaws.services.s3.model.lifecycle.LifecycleObjectSizeLessThanPredicate;
import ai.h2o.com.amazonaws.services.s3.model.lifecycle.LifecyclePredicateVisitor;
import ai.h2o.com.amazonaws.services.s3.model.lifecycle.LifecyclePrefixPredicate;
import ai.h2o.com.amazonaws.services.s3.model.lifecycle.LifecycleTagPredicate;
import ai.h2o.com.amazonaws.services.s3.model.transform.BucketConfigurationXmlFactoryFunctions;

class LifecyclePredicateVisitorImpl
implements LifecyclePredicateVisitor {
    private final XmlWriter xml;

    public LifecyclePredicateVisitorImpl(XmlWriter xml) {
        this.xml = xml;
    }

    @Override
    public void visit(LifecyclePrefixPredicate lifecyclePrefixPredicate) {
        BucketConfigurationXmlFactoryFunctions.writePrefix(this.xml, lifecyclePrefixPredicate.getPrefix());
    }

    @Override
    public void visit(LifecycleTagPredicate lifecycleTagPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeTag(this.xml, lifecycleTagPredicate.getTag());
    }

    @Override
    public void visit(LifecycleObjectSizeGreaterThanPredicate lifecycleObjectSizeGreaterThanPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeObjectSizeGreaterThan(this.xml, lifecycleObjectSizeGreaterThanPredicate.getObjectSizeGreaterThan());
    }

    @Override
    public void visit(LifecycleObjectSizeLessThanPredicate lifecycleObjectSizeLessThanPredicate) {
        BucketConfigurationXmlFactoryFunctions.writeObjectSizeLessThan(this.xml, lifecycleObjectSizeLessThanPredicate.getObjectSizeLessThan());
    }

    @Override
    public void visit(LifecycleAndOperator lifecycleAndOperator) {
        this.xml.start("And");
        for (LifecycleFilterPredicate predicate : lifecycleAndOperator.getOperands()) {
            predicate.accept(this);
        }
        this.xml.end();
    }
}

