/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.services.s3.internal;

import ai.h2o.com.amazonaws.AmazonClientException;
import ai.h2o.com.amazonaws.AmazonWebServiceRequest;
import ai.h2o.com.amazonaws.annotation.SdkTestInternalApi;
import ai.h2o.com.amazonaws.internal.SdkPredicate;
import ai.h2o.com.amazonaws.retry.RetryPolicy;
import ai.h2o.com.amazonaws.services.s3.internal.CompleteMultipartUploadRetryablePredicate;
import ai.h2o.com.amazonaws.services.s3.model.AmazonS3Exception;
import ai.h2o.com.amazonaws.util.ValidationUtils;

public class CompleteMultipartUploadRetryCondition
implements RetryPolicy.RetryCondition {
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private final SdkPredicate<AmazonS3Exception> completeMultipartRetryablePredicate;
    private final int maxCompleteMultipartUploadRetries;

    public CompleteMultipartUploadRetryCondition() {
        this(new CompleteMultipartUploadRetryablePredicate(), 3);
    }

    @SdkTestInternalApi
    CompleteMultipartUploadRetryCondition(SdkPredicate<AmazonS3Exception> predicate, int maxRetryAttempts) {
        ValidationUtils.assertNotNull(predicate, "sdk predicate");
        this.completeMultipartRetryablePredicate = predicate;
        this.maxCompleteMultipartUploadRetries = maxRetryAttempts;
    }

    @Override
    public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
        if (exception instanceof AmazonS3Exception) {
            return this.completeMultipartRetryablePredicate.test((AmazonS3Exception)exception) && retriesAttempted < this.maxCompleteMultipartUploadRetries;
        }
        return false;
    }
}

