/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.protocol.json.internal;

import ai.h2o.com.amazonaws.Request;
import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.protocol.MarshallLocation;
import ai.h2o.com.amazonaws.protocol.MarshallingInfo;
import ai.h2o.com.amazonaws.protocol.MarshallingType;
import ai.h2o.com.amazonaws.protocol.ProtocolMarshaller;
import ai.h2o.com.amazonaws.protocol.json.StructuredJsonGenerator;
import ai.h2o.com.amazonaws.protocol.json.internal.EmptyBodyJsonMarshaller;
import ai.h2o.com.amazonaws.protocol.json.internal.JsonProtocolMarshaller;
import ai.h2o.com.amazonaws.protocol.json.internal.MarshallerRegistry;

@SdkInternalApi
public class JsonMarshallerContext {
    private final StructuredJsonGenerator jsonGenerator;
    private final JsonProtocolMarshaller protocolHandler;
    private final MarshallerRegistry marshallerRegistry;
    private final Request<?> request;
    private final EmptyBodyJsonMarshaller emptyBodyMarshaller;

    private JsonMarshallerContext(Builder builder) {
        this.jsonGenerator = builder.jsonGenerator;
        this.protocolHandler = builder.protocolHandler;
        this.marshallerRegistry = builder.marshallerRegistry;
        this.request = builder.request;
        this.emptyBodyMarshaller = builder.emptyBodyMarshaller != null ? builder.emptyBodyMarshaller : EmptyBodyJsonMarshaller.EMPTY;
    }

    public StructuredJsonGenerator jsonGenerator() {
        return this.jsonGenerator;
    }

    public ProtocolMarshaller protocolHandler() {
        return this.protocolHandler;
    }

    public MarshallerRegistry marshallerRegistry() {
        return this.marshallerRegistry;
    }

    public Request<?> request() {
        return this.request;
    }

    public EmptyBodyJsonMarshaller emptyBodyJsonMarshaller() {
        return this.emptyBodyMarshaller;
    }

    public void marshall(MarshallLocation marshallLocation, Object val) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, null);
    }

    public void marshall(MarshallLocation marshallLocation, Object val, MarshallingInfo marshallingInfo) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, marshallingInfo);
    }

    public void marshall(MarshallLocation marshallLocation, Object val, String paramName) {
        this.marshallerRegistry().getMarshaller(marshallLocation, val).marshall(val, this, MarshallingInfo.builder(new MarshallingType<Object>(){

            @Override
            public boolean isDefaultMarshallerForType(Class<?> type) {
                return false;
            }
        }).marshallLocationName(paramName).build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StructuredJsonGenerator jsonGenerator;
        private JsonProtocolMarshaller protocolHandler;
        private MarshallerRegistry marshallerRegistry;
        private Request<?> request;
        private EmptyBodyJsonMarshaller emptyBodyMarshaller;

        private Builder() {
        }

        public Builder jsonGenerator(StructuredJsonGenerator jsonGenerator) {
            this.jsonGenerator = jsonGenerator;
            return this;
        }

        public Builder protocolHandler(JsonProtocolMarshaller protocolHandler) {
            this.protocolHandler = protocolHandler;
            return this;
        }

        public Builder marshallerRegistry(MarshallerRegistry marshallerRegistry) {
            this.marshallerRegistry = marshallerRegistry;
            return this;
        }

        public Builder request(Request<?> request) {
            this.request = request;
            return this;
        }

        public Builder emptyBodyJsonMarshaller(EmptyBodyJsonMarshaller emptyBodyJsonMarshaller) {
            this.emptyBodyMarshaller = emptyBodyJsonMarshaller;
            return this;
        }

        public JsonMarshallerContext build() {
            return new JsonMarshallerContext(this);
        }
    }
}

