/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.partitions;

import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.partitions.PartitionRegionImpl;
import ai.h2o.com.amazonaws.partitions.model.Endpoint;
import ai.h2o.com.amazonaws.partitions.model.Partition;
import ai.h2o.com.amazonaws.partitions.model.Region;
import ai.h2o.com.amazonaws.partitions.model.Service;
import ai.h2o.com.amazonaws.regions.AbstractRegionMetadataProvider;
import ai.h2o.com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private static final String STANDARD_PARTITION_HOSTNAME = "{service}.{region}.{dnsSuffix}";
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, ai.h2o.com.amazonaws.regions.Region> credentialScopeRegionByHost = new HashMap<String, ai.h2o.com.amazonaws.regions.Region>();
    private final Set<String> standardHostnamePatternDnsSuffixes = new HashSet<String>();
    private final Map<String, ai.h2o.com.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, ai.h2o.com.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p2 : partitions) {
            this.partitionMap.put(p2.getPartition(), p2);
            if (p2.getDefaults() != null && STANDARD_PARTITION_HOSTNAME.equals(p2.getDefaults().getHostName())) {
                this.standardHostnamePatternDnsSuffixes.add(p2.getDnsSuffix());
            }
            for (Service service : p2.getServices().values()) {
                for (Endpoint endpoint : service.getEndpoints().values()) {
                    if (endpoint.getHostName() == null || endpoint.getCredentialScope() == null || endpoint.getCredentialScope().getRegion() == null) continue;
                    ai.h2o.com.amazonaws.regions.Region region = this.cacheRegion(new PartitionRegionImpl(endpoint.getCredentialScope().getRegion(), p2));
                    this.credentialScopeRegionByHost.put(endpoint.getHostName(), region);
                }
            }
        }
    }

    @Override
    public List<ai.h2o.com.amazonaws.regions.Region> getRegions() {
        ArrayList<ai.h2o.com.amazonaws.regions.Region> regions = new ArrayList<ai.h2o.com.amazonaws.regions.Region>();
        for (Partition p2 : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p2.getRegions().entrySet()) {
                regions.add(new ai.h2o.com.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), p2)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public ai.h2o.com.amazonaws.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        ai.h2o.com.amazonaws.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private ai.h2o.com.amazonaws.regions.Region createNewRegion(String regionName) {
        for (Partition p2 : this.partitionMap.values()) {
            if (!p2.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p2));
        }
        Partition awsPartition = this.partitionMap.get("aws");
        if (awsPartition != null) {
            return this.cacheRegion(new PartitionRegionImpl(regionName, awsPartition));
        }
        return null;
    }

    private ai.h2o.com.amazonaws.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private ai.h2o.com.amazonaws.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        ai.h2o.com.amazonaws.regions.Region region = new ai.h2o.com.amazonaws.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<ai.h2o.com.amazonaws.regions.Region> getRegionsForService(String serviceName) {
        List<ai.h2o.com.amazonaws.regions.Region> allRegions = this.getRegions();
        ArrayList<ai.h2o.com.amazonaws.regions.Region> serviceSupportedRegions = new ArrayList<ai.h2o.com.amazonaws.regions.Region>();
        for (ai.h2o.com.amazonaws.regions.Region r2 : allRegions) {
            if (!r2.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r2);
        }
        return serviceSupportedRegions;
    }

    @Override
    public ai.h2o.com.amazonaws.regions.Region tryGetRegionByExplicitEndpoint(String endpoint) {
        String host = PartitionMetadataProvider.getHost(endpoint);
        return this.credentialScopeRegionByHost.get(host);
    }

    @Override
    public ai.h2o.com.amazonaws.regions.Region tryGetRegionByEndpointDnsSuffix(String endpoint) {
        String host = PartitionMetadataProvider.getHost(endpoint);
        for (String dnsSuffix : this.standardHostnamePatternDnsSuffixes) {
            dnsSuffix = "." + dnsSuffix;
            if (!host.endsWith(dnsSuffix)) continue;
            String serviceRegion = host.substring(0, host.length() - dnsSuffix.length());
            String region = serviceRegion.substring(serviceRegion.lastIndexOf(46) + 1);
            if (region.isEmpty()) {
                return null;
            }
            return this.getRegion(region);
        }
        return null;
    }
}

