/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.monitoring;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.monitoring.CsmConfiguration;
import ai.h2o.com.amazonaws.monitoring.CsmConfigurationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CsmConfigurationProviderChain
implements CsmConfigurationProvider {
    private static final Log log = LogFactory.getLog(CsmConfigurationProviderChain.class);
    private final List<CsmConfigurationProvider> providers = new ArrayList<CsmConfigurationProvider>();

    public CsmConfigurationProviderChain(CsmConfigurationProvider ... providers) {
        if (providers != null) {
            Collections.addAll(this.providers, providers);
        }
    }

    @Override
    public CsmConfiguration getConfiguration() {
        for (CsmConfigurationProvider p2 : this.providers) {
            try {
                return p2.getConfiguration();
            }
            catch (SdkClientException e2) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Unable to load configuration from " + p2.toString() + ": " + e2.getMessage()));
            }
        }
        throw new SdkClientException("Could not resolve client side monitoring configuration from the configured providers in the chain");
    }
}

