/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.metrics;

import ai.h2o.com.amazonaws.internal.SdkFilterInputStream;
import ai.h2o.com.amazonaws.metrics.ByteThroughputHelper;
import ai.h2o.com.amazonaws.metrics.ThroughputMetricType;
import java.io.IOException;
import java.io.InputStream;

public class MetricFilterInputStream
extends SdkFilterInputStream {
    private final ByteThroughputHelper helper;

    public MetricFilterInputStream(ThroughputMetricType type, InputStream in) {
        super(in);
        this.helper = new ByteThroughputHelper(type);
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        this.abortIfNeeded();
        long startNano = this.helper.startTiming();
        int bytesRead = this.in.read(b2, off, len);
        if (bytesRead > 0) {
            this.helper.increment(bytesRead, startNano);
        }
        return bytesRead;
    }

    @Override
    public void close() throws IOException {
        this.helper.reportMetrics();
        this.in.close();
        this.abortIfNeeded();
    }

    @Override
    public final boolean isMetricActivated() {
        return true;
    }
}

