/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.internal;

import ai.h2o.com.amazonaws.AbortedException;
import ai.h2o.com.amazonaws.internal.MetricAware;
import ai.h2o.com.amazonaws.internal.Releasable;
import ai.h2o.com.amazonaws.util.IOUtils;
import ai.h2o.com.amazonaws.util.SdkRuntime;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;

public abstract class SdkInputStream
extends InputStream
implements MetricAware,
Releasable {
    protected abstract InputStream getWrappedInputStream();

    @Override
    public final boolean isMetricActivated() {
        InputStream in = this.getWrappedInputStream();
        if (in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e2) {
                LogFactory.getLog(this.getClass()).debug((Object)"FYI", (Throwable)e2);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r2 = (Releasable)((Object)in);
            r2.release();
        }
    }
}

