/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.amazonaws.auth;

import ai.h2o.com.amazonaws.SdkClientException;
import ai.h2o.com.amazonaws.annotation.SdkInternalApi;
import ai.h2o.com.amazonaws.annotation.SdkTestInternalApi;
import ai.h2o.com.amazonaws.auth.BaseCredentialsFetcher;
import ai.h2o.com.amazonaws.internal.EC2ResourceFetcher;
import ai.h2o.com.amazonaws.internal.InstanceMetadataServiceResourceFetcher;
import ai.h2o.com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import ai.h2o.com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;
import ai.h2o.com.amazonaws.util.EC2MetadataUtils;
import java.net.URI;

@SdkInternalApi
final class InstanceMetadataServiceCredentialsFetcher
extends BaseCredentialsFetcher
implements CredentialsEndpointRetryPolicy {
    private final EC2ResourceFetcher resourceFetcher;

    InstanceMetadataServiceCredentialsFetcher() {
        this.resourceFetcher = InstanceMetadataServiceResourceFetcher.getInstance();
    }

    @SdkTestInternalApi
    InstanceMetadataServiceCredentialsFetcher(EC2ResourceFetcher resourceFetcher) {
        this.resourceFetcher = resourceFetcher;
    }

    @Override
    protected String getCredentialsResponse() {
        URI credentialsEndpoint = this.getCredentialsEndpoint();
        return this.resourceFetcher.readResource(credentialsEndpoint, this);
    }

    @Override
    public String toString() {
        return "InstanceMetadataServiceCredentialsFetcher";
    }

    private URI getCredentialsEndpoint() {
        String host = EC2MetadataUtils.getHostAddressForEC2MetadataService();
        String securityCredentialsList = this.resourceFetcher.readResource(URI.create(host + "/latest/meta-data/iam/security-credentials/"), this);
        String[] securityCredentials = securityCredentialsList.trim().split("\n");
        if (securityCredentials.length == 0) {
            throw new SdkClientException("Unable to load credentials path");
        }
        return URI.create(host + "/latest/meta-data/iam/security-credentials/" + securityCredentials[0]);
    }

    @Override
    public boolean shouldRetry(int retriesAttempted, CredentialsEndpointRetryParameters retryParams) {
        return false;
    }
}

