/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.IAlgo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import water.Iced;
import water.util.ArrayUtils;

public class WorkAllocations
extends Iced<WorkAllocations> {
    private boolean frozen;
    private Work[] allocations = new Work[0];

    WorkAllocations allocate(Work work) {
        if (this.frozen) {
            throw new IllegalStateException("Can not allocate new work.");
        }
        this.allocations = ArrayUtils.append(this.allocations, work);
        return this;
    }

    WorkAllocations freeze() {
        this.frozen = true;
        return this;
    }

    void remove(IAlgo algo) {
        if (this.frozen) {
            throw new IllegalStateException("Can not modify allocations.");
        }
        ArrayList<Work> filtered = new ArrayList<Work>(this.allocations.length);
        for (Work alloc : this.allocations) {
            if (algo.name().equals(alloc._algo.name())) continue;
            filtered.add(alloc);
        }
        this.allocations = filtered.toArray(new Work[0]);
    }

    public Work getAllocation(String id, IAlgo algo) {
        for (Work alloc : this.allocations) {
            if (!alloc._algo.name().equals(algo.name()) || !alloc._id.equals(id)) continue;
            return alloc;
        }
        return null;
    }

    public Work[] getAllocations(Predicate<Work> predicate) {
        return (Work[])Stream.of(this.allocations).filter(predicate).toArray(Work[]::new);
    }

    private int sum(Work[] workItems) {
        int tot = 0;
        for (Work item : workItems) {
            if (item._weight <= 0) continue;
            tot += item._weight;
        }
        return tot;
    }

    int remainingWork() {
        return this.sum(this.allocations);
    }

    int remainingWork(Predicate<Work> predicate) {
        return this.sum(this.getAllocations(predicate));
    }

    float remainingWorkRatio(Work work) {
        return (float)work._weight / (float)this.remainingWork();
    }

    float remainingWorkRatio(Work work, Predicate<Work> predicate) {
        return (float)work._weight / (float)this.remainingWork(predicate);
    }

    public String toString() {
        return Arrays.toString(this.allocations);
    }

    public static class Work
    extends Iced<Work> {
        String _id;
        IAlgo _algo;
        JobType _type;
        int _priorityGroup;
        int _weight;

        Work(String id, IAlgo algo, JobType type, int priorityGroup, int weight) {
            this._algo = algo;
            this._type = type;
            this._id = id;
            this._priorityGroup = priorityGroup;
            this._weight = weight;
        }

        public int consume() {
            int consumed = this._weight;
            this._weight = 0;
            return consumed;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Work{").append(this._id).append(", ").append(this._algo.name()).append(", ").append((Object)this._type).append(", ").append("group=").append(this._priorityGroup).append(", ").append("weight=").append(this._weight).append('}');
            return sb.toString();
        }
    }

    public static enum JobType {
        Unknown,
        ModelBuild,
        HyperparamSearch,
        Selection,
        Dynamic;

    }
}

