/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import hex.Model;
import hex.ModelContainer;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.TypeMap;
import water.automl.api.schemas3.SchemaExtensions;
import water.util.ArrayUtils;

public class Models<M extends Model>
extends Lockable<Models<M>>
implements ModelContainer<M> {
    private final int _type_id;
    private final Job _job;
    private Key<M>[] _modelKeys = new Key[0];

    public Models(Key<Models<M>> key, Class<M> clz) {
        this(key, clz, null);
    }

    public Models(Key<Models<M>> key, Class<M> clz, Job job) {
        super(key);
        this._type_id = clz != null && !Modifier.isAbstract(clz.getModifiers()) ? TypeMap.getIcedId(clz.getName()) : -1;
        this._job = job;
    }

    @Override
    public Key<M>[] getModelKeys() {
        return (Key[])this._modelKeys.clone();
    }

    @Override
    public M[] getModels() {
        Arrays.stream(this._modelKeys).forEach(DKV::prefetch);
        Class<Model> clz = this._type_id >= 0 ? TypeMap.theFreezable(this._type_id).getClass() : Model.class;
        return (Model[])Arrays.stream(this._modelKeys).map(k2 -> k2 == null ? null : (Model)k2.get()).toArray(l2 -> (Model[])Array.newInstance(clz, l2));
    }

    @Override
    public int getModelCount() {
        return this._modelKeys.length;
    }

    public void addModel(Key<M> key) {
        this.addModels(new Key[]{key});
    }

    public void addModels(Key<M>[] keys) {
        this.write_lock(this._job);
        this._modelKeys = ArrayUtils.append(this._modelKeys, keys);
        this.update(this._job);
        this.unlock(this._job);
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (cascade) {
            for (Key<M> k2 : this._modelKeys) {
                Keyed.remove(k2, fs, true);
            }
        }
        this._modelKeys = new Key[0];
        return super.remove_impl(fs, cascade);
    }

    @Override
    public Class<SchemaExtensions.ModelsKeyV3> makeSchema() {
        return SchemaExtensions.ModelsKeyV3.class;
    }
}

