/*
 * Decompiled with CFR 0.152.
 */
package Jama.examples;

import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import java.text.DecimalFormat;
import java.util.Date;

public class MagicSquareExample {
    public static Matrix magic(int n2) {
        double[][] dArray = new double[n2][n2];
        if (n2 % 2 == 1) {
            int n3 = (n2 + 1) / 2;
            int n4 = n2 + 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    dArray[i3][i2] = n2 * ((i3 + i2 + n3) % n2) + (i3 + 2 * i2 + n4) % n2 + 1;
                }
            }
        } else if (n2 % 4 == 0) {
            for (int i4 = 0; i4 < n2; ++i4) {
                for (int i5 = 0; i5 < n2; ++i5) {
                    dArray[i5][i4] = (i5 + 1) / 2 % 2 == (i4 + 1) / 2 % 2 ? (double)(n2 * n2 - n2 * i5 - i4) : (double)(n2 * i5 + i4 + 1);
                }
            }
        } else {
            double d2;
            int n5;
            int n6;
            int n7 = n2 / 2;
            int n8 = (n2 - 2) / 4;
            Matrix matrix = MagicSquareExample.magic(n7);
            for (n6 = 0; n6 < n7; ++n6) {
                for (n5 = 0; n5 < n7; ++n5) {
                    dArray[n5][n6] = d2 = matrix.get(n5, n6);
                    dArray[n5][n6 + n7] = d2 + (double)(2 * n7 * n7);
                    dArray[n5 + n7][n6] = d2 + (double)(3 * n7 * n7);
                    dArray[n5 + n7][n6 + n7] = d2 + (double)(n7 * n7);
                }
            }
            for (n6 = 0; n6 < n7; ++n6) {
                for (n5 = 0; n5 < n8; ++n5) {
                    d2 = dArray[n6][n5];
                    dArray[n6][n5] = dArray[n6 + n7][n5];
                    dArray[n6 + n7][n5] = d2;
                }
                for (n5 = n2 - n8 + 1; n5 < n2; ++n5) {
                    d2 = dArray[n6][n5];
                    dArray[n6][n5] = dArray[n6 + n7][n5];
                    dArray[n6 + n7][n5] = d2;
                }
            }
            double d3 = dArray[n8][0];
            dArray[n8][0] = dArray[n8 + n7][0];
            dArray[n8 + n7][0] = d3;
            d3 = dArray[n8][n8];
            dArray[n8][n8] = dArray[n8 + n7][n8];
            dArray[n8 + n7][n8] = d3;
        }
        return new Matrix(dArray);
    }

    private static void print(String string) {
        System.out.print(string);
    }

    public static String fixedWidthDoubletoString(double d2, int n2, int n3) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(n3);
        decimalFormat.setMinimumFractionDigits(n3);
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(d2);
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    public static String fixedWidthIntegertoString(int n2, int n3) {
        String string = Integer.toString(n2);
        while (string.length() < n3) {
            string = " " + string;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        MagicSquareExample.print("\n    Test of Matrix Class, using magic squares.\n");
        MagicSquareExample.print("    See MagicSquareExample.main() for an explanation.\n");
        MagicSquareExample.print("\n      n     trace       max_eig   rank        cond      lu_res      qr_res\n\n");
        Date date = new Date();
        double d2 = Math.pow(2.0, -52.0);
        for (int i2 = 3; i2 <= 32; ++i2) {
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(i2, 7));
            Matrix matrix = MagicSquareExample.magic(i2);
            int n2 = (int)matrix.trace();
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(n2, 10));
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix.plus(matrix.transpose()).times(0.5));
            double[] dArray = eigenvalueDecomposition.getRealEigenvalues();
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(dArray[i2 - 1], 14, 3));
            int n3 = matrix.rank();
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(n3, 7));
            double d3 = matrix.cond();
            MagicSquareExample.print(d3 < 1.0 / d2 ? MagicSquareExample.fixedWidthDoubletoString(d3, 12, 3) : "         Inf");
            LUDecomposition lUDecomposition = new LUDecomposition(matrix);
            Matrix matrix2 = lUDecomposition.getL();
            Matrix matrix3 = lUDecomposition.getU();
            int[] nArray = lUDecomposition.getPivot();
            Matrix matrix4 = matrix2.times(matrix3).minus(matrix.getMatrix(nArray, 0, i2 - 1));
            double d4 = matrix4.norm1() / ((double)i2 * d2);
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(d4, 12, 3));
            QRDecomposition qRDecomposition = new QRDecomposition(matrix);
            Matrix matrix5 = qRDecomposition.getQ();
            matrix4 = qRDecomposition.getR();
            matrix4 = matrix5.times(matrix4).minus(matrix);
            d4 = matrix4.norm1() / ((double)i2 * d2);
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(d4, 12, 3));
            MagicSquareExample.print("\n");
        }
        Date date2 = new Date();
        double d5 = (double)(date2.getTime() - date.getTime()) / 1000.0;
        MagicSquareExample.print("\nElapsed Time = " + MagicSquareExample.fixedWidthDoubletoString(d5, 12, 3) + " seconds\n");
        MagicSquareExample.print("Adios\n");
    }
}

