/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Trace.PhdData;
import Trace.StreamDelegator;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;

public class PhdFile
extends Observable
implements Runnable {
    public Vector data;
    public boolean loaded = false;
    public boolean load_error;
    public String filename;
    public boolean reverse_complemented = false;

    public PhdFile() {
    }

    public PhdFile(String name) {
        this.load(name);
    }

    public PhdFile(String name, Observer o) {
        this.filename = name;
        this.addObserver(o);
        new Thread(this).start();
    }

    PhdFile copy() {
        PhdFile p = new PhdFile();
        p.filename = this.filename;
        p.data = new Vector();
        p.loaded = this.loaded;
        for (int i = 0; i < this.data.size(); ++i) {
            PhdData pd = (PhdData)this.data.elementAt(i);
            PhdData nd = new PhdData();
            nd.base = pd.base;
            nd.quality = pd.quality;
            nd.position = pd.position;
            p.data.addElement(nd);
        }
        return p;
    }

    public void run() {
        this.load(this.filename);
        this.setChanged();
        this.notifyObservers();
    }

    public void reverse_complement(int num_samples) {
        Vector<PhdData> newdata = new Vector<PhdData>();
        for (int i = this.data.size() - 1; i >= 0; --i) {
            PhdData p = (PhdData)this.data.elementAt(i);
            p.position = (short)(num_samples - 1 - p.position);
            switch (p.base) {
                case 'a': {
                    p.base = (char)116;
                    p.base_index = (short)3;
                    break;
                }
                case 'c': {
                    p.base = (char)103;
                    p.base_index = (short)2;
                    break;
                }
                case 'g': {
                    p.base = (char)99;
                    p.base_index = 1;
                    break;
                }
                case 't': {
                    p.base = (char)97;
                    p.base_index = 0;
                    break;
                }
                case 'A': {
                    p.base = (char)84;
                    p.base_index = (short)3;
                    break;
                }
                case 'C': {
                    p.base = (char)71;
                    p.base_index = (short)2;
                    break;
                }
                case 'G': {
                    p.base = (char)67;
                    p.base_index = 1;
                    break;
                }
                case 'T': {
                    p.base = (char)65;
                    p.base_index = 0;
                }
            }
            newdata.addElement(p);
        }
        this.data = newdata;
        this.reverse_complemented = !this.reverse_complemented;
    }

    void load(String filename) {
        DataInputStream d;
        this.filename = filename;
        this.data = new Vector();
        try {
            d = StreamDelegator.getStream(filename, 1);
        }
        catch (IOException e) {
            this.load_error = true;
            return;
        }
        if (d == null) {
            this.load_error = true;
            return;
        }
        boolean pos = false;
        BufferedReader d2 = new BufferedReader(new InputStreamReader(d));
        try {
            String line;
            boolean data_mode = false;
            while ((line = d2.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) continue;
                String key = st.nextToken();
                if (data_mode) {
                    if (key.equals("END_DNA")) break;
                    PhdData p = new PhdData();
                    p.base = key.charAt(0);
                    switch (p.base) {
                        case 'A': 
                        case 'a': {
                            p.base_index = 0;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            p.base_index = 1;
                            break;
                        }
                        case 'G': 
                        case 'g': {
                            p.base_index = (short)2;
                            break;
                        }
                        case 'T': 
                        case 't': {
                            p.base_index = (short)3;
                            break;
                        }
                        default: {
                            p.base_index = (short)-1;
                        }
                    }
                    p.quality = (short)Integer.parseInt(st.nextToken());
                    p.position = (short)Integer.parseInt(st.nextToken());
                    this.data.addElement(p);
                    continue;
                }
                if (!key.equals("BEGIN_DNA")) continue;
                data_mode = true;
            }
            this.loaded = true;
            this.load_error = false;
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

