/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.Str;
import Trace.JTraceCanvas;
import Trace.JTracePanel;
import Trace.PhdFile;
import Trace.StreamDelegator;
import Trace.TraceFile;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;

public class JTraceViewer
extends JFrame
implements Observer {
    JTracePanel tp;

    public JTraceViewer(String filename) {
        this.tp = new JTracePanel(filename);
        this.setup();
    }

    public JTraceViewer(TraceFile t) {
        this.tp = new JTracePanel(t);
        this.setup();
    }

    public JTraceViewer(String filename, int position) {
        this.tp = new JTracePanel(filename, position);
        this.setup();
    }

    public JTraceViewer(String filename, int position, boolean reverse_complemented) {
        this.tp = new JTracePanel(filename, position, reverse_complemented);
        this.setup();
    }

    public JTraceViewer(String filename, boolean reverse_complemented) {
        this.tp = new JTracePanel(filename, reverse_complemented);
        this.setup();
    }

    public void setPhd(PhdFile p) {
        this.tp.setPhd(p);
    }

    public static void main(String[] argv) {
        StreamDelegator.guess_compression();
        String trace = null;
        boolean rc = false;
        int offset = 0;
        boolean use_trace_server = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-local")) {
                StreamDelegator.set_local(true);
                continue;
            }
            if (argv[i].equals("-rc")) {
                rc = true;
                continue;
            }
            if (argv[i].equals("-ts")) {
                use_trace_server = true;
                continue;
            }
            if (argv[i].equals("-sbb")) {
                System.err.println("scrolling by bases");
                JTraceCanvas.set_scroll_by_bases(true);
                JTraceCanvas.set_fixed_bases_scroll(true);
                continue;
            }
            if (argv[i].equals("-offset")) {
                offset = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-h")) {
                StreamDelegator.set_host(argv[++i]);
                continue;
            }
            if (argv[i].equals("-mp")) {
                StreamDelegator.set_mod_perl(true);
                continue;
            }
            trace = argv[i];
        }
        if (trace == null) {
            System.out.println("Usage: JTraceViewer tracefile [options]");
            System.exit(1);
        } else if (use_trace_server) {
            System.err.println("DISABLED (so applet JDK4 code can compile)");
        } else {
            new JTraceViewer(trace, offset, rc);
        }
    }

    void setup() {
        this.setDefaultCloseOperation(3);
        this.setTitle(this.tp.filename);
        this.add("Center", this.tp);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize((int)((double)d.width * 0.65), (int)((double)d.height * 0.35));
        this.setVisible(true);
    }

    public void center_in_screen(Point p) {
        if (p != null) {
            this.setLocation(p.x - this.getSize().width / 2, p.y);
        }
    }

    public void center_on(int i) {
        this.tp.center_on(i);
    }

    public void go_to(TraceFile tf, int offset) {
        this.setTitle(Str.basename(tf.name));
        this.tp.go_to(tf, offset);
        this.setVisible(true);
    }

    public boolean loaded() {
        return this.tp.loaded();
    }

    public boolean error() {
        return this.tp.error();
    }

    public TraceFile get_trace() {
        return this.tp.get_trace();
    }

    public void update(Observable o, Object arg) {
        System.err.println("UPDATE");
    }
}

