/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.Counter;
import Funk.JMultiScrollPanel;
import Funk.LookAndFeeler;
import Funk.MenuBuilder;
import Funk.Message;
import Funk.Misc;
import Funk.Str;
import Trace.GenotypeData;
import Trace.GenotypeParser;
import Trace.GenotypeTrace;
import Trace.JGenotypeViewerCredits;
import Trace.JTraceCanvas;
import Trace.JTracePanel;
import Trace.StreamDelegator;
import Trace.TraceDataView;
import Trace.TraceFile;
import Trace.TraceLoader;
import Trace.TraceServerClient;
import Trace.TraceZoomer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;

public class JGenotypeViewer
extends JFrame
implements ItemListener,
ActionListener,
MouseWheelListener,
AdjustmentListener,
Observer,
MouseListener {
    private static boolean LOCAL_MODE = false;
    private static boolean SINGLE_LOAD = false;
    private static boolean DEFAULT_DYNAMIC_NORMALIZATION = true;
    private static boolean DEFAULT_LOCK_SCROLLING = true;
    private static int PREFERRED_WIDTH_PERCENT = 50;
    private static final boolean HIDE_COMPONENTS_DURING_LOAD = true;
    private HashMap<String, JTracePanel> trace2panel;
    private GenotypeParser gp;
    private JMultiScrollPanel msp;
    private Counter progress;
    private TraceZoomer tz = new TraceZoomer();
    private HashSet<String> unique_trace_list;
    private static final String GENOTYPE_ANY = "Any";
    private static final String GENOTYPE_HETEROZYGOUS = "Heterozygous";
    private JComboBox snp_chooser;
    private JComboBox genotype_chooser;
    private JCheckBoxMenuItem cmi_ls;
    private JPanel controls;
    private Applet applet;
    private JLabel loading_message;
    private JProgressBar loading_progress;
    private ButtonGroup bg_normalization;
    private JScrollBar active_scrollbar = null;

    public JGenotypeViewer(GenotypeParser gp) throws IOException {
        this.gp = gp;
        this.setup();
    }

    public JGenotypeViewer(GenotypeParser gp, Applet a) throws IOException {
        this.gp = gp;
        this.applet = a;
        this.setup();
    }

    public static void set_window_width_percent(int w) {
        PREFERRED_WIDTH_PERCENT = w;
    }

    public static void main(String[] argv) {
        StreamDelegator.guess_compression();
        StreamDelegator.set_local(true);
        String file = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-local")) {
                System.err.println("enabling local mode");
                LOCAL_MODE = true;
                SINGLE_LOAD = true;
                TraceLoader.LOCAL_MODE = true;
                continue;
            }
            if (argv[i].equals("-old")) {
                System.err.println("enabling old genotype.dat format");
                GenotypeParser.OLD_MODE = true;
                continue;
            }
            if (argv[i].equals("-file")) {
                file = argv[++i];
                continue;
            }
            if (argv[i].equals("-hp")) {
                JMultiScrollPanel.set_window_height_percent(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-wp")) {
                JGenotypeViewer.set_window_width_percent(Integer.parseInt(argv[++i]));
                continue;
            }
            System.err.println("unknown option " + argv[i]);
        }
        if (file == null) {
            file = LOCAL_MODE ? (GenotypeParser.OLD_MODE ? "genotype_fixed.dat" : "genotype_small_labeled.dat") : "crash.dat";
        }
        GenotypeParser gp = null;
        try {
            System.err.println("data file: " + file);
            gp = new GenotypeParser(file);
            new JGenotypeViewer(gp);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    private void setup() throws IOException {
        block8: {
            this.setTitle("Genotype viewer");
            LookAndFeeler.set_native_lookandfeel();
            if (this.applet == null) {
                this.setDefaultCloseOperation(3);
            }
            JTraceCanvas.set_scroll_by_bases(true);
            JTraceCanvas.set_fixed_bases_scroll(true);
            this.msp = new JMultiScrollPanel();
            this.trace2panel = new HashMap();
            MenuBuilder mb = new MenuBuilder(this, (ActionListener)this);
            mb.start_menu("File", 70);
            mb.add("Download traces", 68);
            mb.add("Exit", 88);
            mb.start_menu("View", 86);
            mb.add("Recenter", 67);
            mb.add("Snap", 78);
            mb.add(new JSeparator());
            mb.start_submenu("Zoom", 90);
            mb.add("In");
            mb.add("Out");
            mb.add(new JSeparator());
            mb.add("Max in");
            mb.add("Max out");
            mb.add(new JSeparator());
            mb.add("Reset");
            mb.end_submenu();
            mb.start_menu("Options", 79);
            mb.start_submenu("Dynamic normalization", 68);
            mb.add("Maximum zoom:");
            this.bg_normalization = new ButtonGroup();
            int zero = 48;
            for (int i = 1; i <= 10; ++i) {
                String label = i + "x";
                if (i == 1) {
                    label = label.concat("  (disable)");
                }
                JRadioButtonMenuItem rbm = new JRadioButtonMenuItem(label, i == 5);
                this.bg_normalization.add(rbm);
                if (i < 10) {
                    mb.add(rbm, 48 + i);
                    continue;
                }
                mb.add(rbm);
            }
            JRadioButtonMenuItem jmi_ul = new JRadioButtonMenuItem("unlimited", false);
            mb.add(jmi_ul);
            this.bg_normalization.add(jmi_ul);
            mb.end_submenu();
            this.cmi_ls = new JCheckBoxMenuItem("Synchronize trace scrolling", DEFAULT_LOCK_SCROLLING);
            this.cmi_ls.setMnemonic(83);
            mb.add(this.cmi_ls);
            JCheckBoxMenuItem cmi = new JCheckBoxMenuItem("Antialiasing", true);
            cmi.setMnemonic(65);
            mb.add(cmi);
            TraceDataView.set_static_auto_normalization(DEFAULT_DYNAMIC_NORMALIZATION);
            new LookAndFeeler(this, mb);
            mb.start_menu("Help", 72);
            mb.add("About", 65);
            this.setLayout(new BorderLayout());
            this.add("Center", this.msp);
            this.controls = new JPanel();
            this.controls.addMouseWheelListener(this);
            FlowLayout cpl = new FlowLayout();
            this.msp.set_preferred_width_percent(PREFERRED_WIDTH_PERCENT);
            this.loading_progress = new JProgressBar();
            this.loading_progress.setString("Loading...");
            this.loading_progress.setStringPainted(true);
            this.loading_progress.setMinimum(0);
            this.loading_progress.setMaximum(100);
            Dimension pref = this.loading_progress.getPreferredSize();
            pref.width = (int)((double)this.get_preferred_width() * 0.9);
            this.loading_progress.setPreferredSize(pref);
            this.controls.add(this.loading_progress);
            this.controls.setLayout(cpl);
            Vector<String> snps = this.gp.get_snp_ids();
            this.snp_chooser = new JComboBox<String>(snps);
            this.snp_chooser.addItemListener(this);
            this.genotype_chooser = new JComboBox();
            this.genotype_chooser.addItemListener(this);
            this.add("North", this.controls);
            this.change_snp_view();
            this.getJMenuBar().setVisible(false);
            this.msp.setVisible(false);
            this.pack();
            this.set_width_hack();
            this.setVisible(true);
            this.toFront();
            this.unique_trace_list = this.gp.get_unique_traces();
            this.progress = new Counter(this.unique_trace_list);
            if (SINGLE_LOAD) {
                TraceLoader tl = new TraceLoader(this.unique_trace_list, this);
            } else {
                TraceServerClient tsc = new TraceServerClient();
                try {
                    tsc.get_traces(this.unique_trace_list, this);
                }
                catch (FileNotFoundException fnf) {
                    String error_message = "Error: " + fnf.getMessage();
                    new Message(error_message);
                    if (this.loading_progress == null) break block8;
                    this.loading_progress.setString(error_message);
                }
            }
        }
    }

    public void change_snp_view() {
        String snp_id = (String)this.snp_chooser.getSelectedItem();
        GenotypeData gd = this.gp.get_genotypes_for_snp(snp_id);
        this.genotype_chooser.removeAllItems();
        this.genotype_chooser.addItem(GENOTYPE_ANY);
        HashSet alleles = gd.get_alleles();
        for (String allele : alleles) {
            this.genotype_chooser.addItem(allele);
        }
        this.genotype_chooser.addItem(GENOTYPE_HETEROZYGOUS);
        this.set_view();
    }

    public void set_view() {
        String snp_id = (String)this.snp_chooser.getSelectedItem();
        GenotypeData gd = this.gp.get_genotypes_for_snp(snp_id);
        this.recenter_all();
        this.msp.removeAll();
        String current_genotype = (String)this.genotype_chooser.getSelectedItem();
        for (GenotypeTrace gt : gd.traces) {
            JTracePanel tp = this.trace2panel.get(gt.trace_id);
            if (tp == null || !(current_genotype.equals(GENOTYPE_HETEROZYGOUS) ? gt.is_heterozygous() : current_genotype.equals(GENOTYPE_ANY) || gt.contains_allele(current_genotype))) continue;
            this.msp.add(tp);
        }
        this.msp.validate();
    }

    public void recenter_all() {
        String snp_id = (String)this.snp_chooser.getSelectedItem();
        GenotypeData gd = this.gp.get_genotypes_for_snp(snp_id);
        for (GenotypeTrace gt : gd.traces) {
            JTracePanel tp = this.trace2panel.get(gt.trace_id);
            if (tp == null) continue;
            tp.center_on(gt.trace_offset, true);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.snp_chooser)) {
            this.change_snp_view();
        } else if (source.equals(this.genotype_chooser)) {
            this.set_view();
        } else {
            System.err.println("unhandled: " + e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Object source = e.getSource();
        boolean need_refresh = false;
        if (cmd.equals("Download traces")) {
            this.download_traces();
        } else if (cmd.equals("Exit")) {
            this.setVisible(false);
            this.dispose();
        } else if (cmd.equals("Recenter")) {
            this.recenter_all();
        } else if (cmd.equals("Snap")) {
            this.msp.snap(false);
        } else if (cmd.equals("Antialiasing")) {
            JTraceCanvas.set_antialiasing(this.get_jcheckbox_status(source));
            need_refresh = true;
        } else if (cmd.equals("In")) {
            this.tz.zoom(-2);
            need_refresh = true;
        } else if (cmd.equals("Out")) {
            this.tz.zoom(2);
            need_refresh = true;
        } else if (cmd.equals("Max in")) {
            this.tz.zoom_to_maximum();
            need_refresh = true;
        } else if (cmd.equals("Max out")) {
            this.tz.zoom_to_minimum();
            need_refresh = true;
        } else if (cmd.equals("Reset")) {
            this.tz.reset();
            need_refresh = true;
        } else if (cmd.equals("About")) {
            new JGenotypeViewerCredits();
        } else if (Misc.contains(this.bg_normalization, source)) {
            if (cmd.equals("unlimited")) {
                TraceDataView.set_static_auto_normalization(true);
                TraceDataView.set_static_auto_normalization_limit(0.0);
            } else {
                String amt = Str.trim_whitespace(cmd.substring(0, cmd.indexOf("x")));
                Double factor = Double.parseDouble(amt);
                if (factor == 1.0) {
                    TraceDataView.set_static_auto_normalization(false);
                } else {
                    TraceDataView.set_static_auto_normalization(true);
                    TraceDataView.set_static_auto_normalization_limit(factor);
                }
            }
            need_refresh = true;
        }
        if (need_refresh) {
            this.msp.invalidate();
            this.repaint();
        }
    }

    public void update(Observable o, Object arg) {
        TraceFile t = null;
        if (o instanceof TraceLoader) {
            TraceLoader tl = (TraceLoader)o;
            t = (TraceFile)arg;
        } else if (o instanceof TraceServerClient) {
            t = (TraceFile)arg;
        } else {
            System.err.println("unhandled update!");
        }
        if (t != null) {
            this.progress.next();
            this.stash_panel(t);
            int complete = this.progress.get_percent_complete();
            String msg = "Loading (" + complete + "%)...";
            if (this.progress.complete()) {
                this.controls.removeAll();
                this.controls.add(new JLabel("SNP:"));
                this.controls.add(this.snp_chooser);
                this.controls.add(new JLabel("allele:"));
                this.controls.add(this.genotype_chooser);
                this.controls.invalidate();
                this.set_view();
                this.getJMenuBar().setVisible(true);
                this.msp.setVisible(true);
                this.msp.snap(true);
                this.set_width_hack();
                this.toFront();
                this.repaint();
            } else if (this.loading_message != null) {
                System.err.println(msg);
                this.loading_message.setText(msg);
                this.controls.validate();
            } else if (this.loading_progress != null) {
                this.loading_progress.setValue(complete);
                this.loading_progress.setString(msg);
                this.controls.validate();
            }
        }
    }

    private void stash_panel(TraceFile t) {
        String orientation = this.gp.get_orientation_for(t.name);
        JPanel info = new JPanel();
        FlowLayout bl = new FlowLayout();
        bl.setAlignment(0);
        info.setLayout(bl);
        GenotypeTrace gt = this.gp.get_genotypetrace_for(t.name);
        String label = gt.trace_label;
        if (label == null) {
            label = gt.trace_id + " (" + gt.orientation + ")";
        }
        info.add(new JLabel(label));
        if (orientation.equals("-")) {
            t.reverse_complement();
        }
        JTracePanel tp = new JTracePanel(t, label);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        int preferred_width = ss.width;
        int preferred_panel_height = (int)((double)ss.height * 0.22);
        tp.setPreferredSize(new Dimension(preferred_width, preferred_panel_height));
        tp.setMinimumSize(new Dimension(preferred_width, preferred_panel_height));
        tp.setMaximumSize(new Dimension(ss.width, preferred_panel_height));
        JScrollBar sb = tp.get_scrollbar();
        sb.addAdjustmentListener(this);
        sb.addMouseListener(this);
        this.trace2panel.put(t.name, tp);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int rotation = e.getWheelRotation();
        this.tz.zoom(rotation);
        this.repaint_all();
    }

    private void repaint_all() {
        for (JTracePanel tp : this.trace2panel.values()) {
            tp.repaint();
        }
        this.msp.validate();
    }

    private void download_traces() {
        TraceServerClient tsc = new TraceServerClient();
        URL url = this.gp.get_url();
        URL dl = tsc.get_download_url(this.unique_trace_list, url == null ? "" : url.toString());
        System.err.println(dl.toString());
        if (this.applet == null) {
            new Message("can't launch download URL: no applet", "OK");
        } else {
            this.applet.getAppletContext().showDocument(dl, "Download");
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        JScrollBar source_sb = (JScrollBar)e.getSource();
        if (this.cmi_ls.getState() && this.active_scrollbar != null && source_sb.equals(this.active_scrollbar)) {
            JScrollBar sb;
            int abs_delta = 0;
            for (JTracePanel tp : this.trace2panel.values()) {
                sb = tp.get_scrollbar();
                if (!sb.equals(source_sb)) continue;
                abs_delta = tp.get_bases_delta_since_start();
                break;
            }
            for (JTracePanel tp : this.trace2panel.values()) {
                sb = tp.get_scrollbar();
                if (sb.equals(source_sb)) continue;
                tp.apply_absolute_delta(abs_delta);
            }
        }
    }

    private boolean get_jcheckbox_status(Object o) {
        return ((JCheckBoxMenuItem)o).getState();
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.active_scrollbar = (JScrollBar)e.getSource();
    }

    public void mouseExited(MouseEvent e) {
        this.active_scrollbar = null;
    }

    private int get_preferred_width() {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        return ss.width * PREFERRED_WIDTH_PERCENT / 100;
    }

    private void set_width_hack() {
        Dimension pref = new Dimension(this.get_preferred_width(), this.getSize().height);
        this.setSize(pref);
    }
}

