/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.Notifier;
import Trace.RandomAccessStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Observer;

public class FakeFile
extends Notifier
implements RandomAccessStream {
    private byte[] bytes;
    private int position = 0;
    private DataInputStream s;

    FakeFile(byte[] b) {
        this.bytes = b;
    }

    FakeFile(DataInputStream s) {
        this.s = s;
        this.load();
    }

    FakeFile(DataInputStream s, Observer o) {
        this.s = s;
        this.addObserver(o);
        this.load();
    }

    private void load() {
        this.bytes = null;
        byte[] buffer = new byte[16384];
        int buffer_length = buffer.length;
        int i = 0;
        boolean done = false;
        try {
            long start = System.currentTimeMillis();
            while (!done) {
                i = 0;
                while (this.s != null) {
                    int av = this.s.available();
                    if (av > 0) {
                        int buf_left = buffer_length - i;
                        int count = av > buf_left ? buf_left : av;
                        int actual_read = this.s.read(buffer, i, count);
                        if (actual_read == -1) {
                            System.out.println("fakefile: -1 read??");
                            break;
                        }
                        i += actual_read;
                    } else {
                        int b = this.s.read();
                        if (b == -1) {
                            done = true;
                            break;
                        }
                        buffer[i++] = (byte)b;
                    }
                    int bl = this.bytes == null ? i : this.bytes.length + i;
                    this.notify_check(bl);
                    if (i != buffer_length) continue;
                    break;
                }
                if (this.bytes == null) {
                    this.bytes = new byte[i];
                    System.arraycopy(buffer, 0, this.bytes, 0, i);
                    continue;
                }
                byte[] newdata = new byte[this.bytes.length + i];
                System.arraycopy(this.bytes, 0, newdata, 0, this.bytes.length);
                System.arraycopy(buffer, 0, newdata, this.bytes.length, i);
                this.bytes = newdata;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public void seek(int pos) {
        this.position = pos;
    }

    public byte[] read(int count) {
        byte[] result = new byte[count];
        System.arraycopy(this.bytes, this.position, result, 0, count);
        return result;
    }

    public int read(byte[] b) {
        int count = 0;
        for (int i = 0; i < b.length && this.position < this.bytes.length; ++i) {
            b[i] = this.bytes[this.position++];
            ++count;
        }
        return count;
    }

    public byte readByte() {
        return this.bytes[this.position++];
    }

    public int readUnsignedByte() {
        return this.bytes[this.position++] & 0xFF;
    }

    public int readInt() {
        int result = (this.bytes[this.position + 3] & 0xFF) + ((this.bytes[this.position + 2] & 0xFF) << 8) + ((this.bytes[this.position + 1] & 0xFF) << 16) + ((this.bytes[this.position] & 0xFF) << 24);
        this.position += 4;
        return result;
    }

    public void skipBytes(int count) {
        this.position += count;
    }

    public short readShort() {
        short result = (short)((this.bytes[this.position + 1] & 0xFF) + ((this.bytes[this.position] & 0xFF) << 8));
        this.position += 2;
        return result;
    }

    public String readString(int num_bytes) {
        byte[] b = new byte[num_bytes];
        if (this.read(b) < num_bytes) {
            return "";
        }
        return new String(b);
    }

    public long length() {
        return this.bytes.length;
    }
}

