/*
 * Decompiled with CFR 0.152.
 */
package Trace;

import Funk.Stats;
import Trace.PolyPeak;
import Trace.StreamDelegator;
import Trace.TraceFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class BaseBasecaller {
    private TraceFile trace;
    private Vector[] all_peaks;
    private Vector called;
    private Vector alternate;

    public BaseBasecaller(TraceFile t) {
        this.trace = t;
        this.setup_internal();
    }

    private void setup_internal() {
        this.find_peaks();
        this.called = new Vector(this.trace.num_bases);
        for (int i = 0; i < this.trace.num_bases; ++i) {
            short ci = TraceFile.base_to_index(this.trace.bases[i]);
            PolyPeak cb = new PolyPeak(ci);
            this.called.addElement(cb);
            cb.peak = this.trace.base_position[i];
            if (cb.peak < 0) {
                cb.peak = 0;
            }
            if (ci == -1) {
                int called = -1;
                for (int j = 0; j < 4; j = (int)((short)(j + 1))) {
                    int amp = this.trace.trace_data[j][cb.peak];
                    if (amp <= cb.amplitude) continue;
                    cb.amplitude = amp;
                    cb.base = (short)j;
                }
                continue;
            }
            cb.amplitude = this.trace.trace_data[ci][cb.peak];
        }
        this.assign_alternates();
    }

    private void assign_alternates() {
        this.alternate = new Vector(this.called.size());
        int[] ptr = new int[4];
        ptr[3] = 0;
        ptr[2] = 0;
        ptr[1] = 0;
        ptr[0] = 0;
        Hashtable peaks = this.get_peak_hash();
        int wiggle = this.trace.average_peak_spacing / 2;
        Vector<PolyPeak> others = new Vector<PolyPeak>();
        int stop = this.called.size();
        for (int i = 0; i < stop; ++i) {
            PolyPeak other;
            Enumeration e;
            PolyPeak called_peak = (PolyPeak)this.called.elementAt(i);
            int end = called_peak.peak + wiggle;
            others.removeAllElements();
            for (int j = called_peak.peak - wiggle; j <= end; ++j) {
                String key = Integer.toString(j);
                if (!peaks.containsKey(key)) continue;
                Vector v = (Vector)peaks.get(key);
                e = v.elements();
                while (e.hasMoreElements()) {
                    other = (PolyPeak)e.nextElement();
                    if (other.base == called_peak.base) continue;
                    others.addElement(other);
                }
            }
            if (others.size() > 0) {
                PolyPeak best = null;
                e = others.elements();
                while (e.hasMoreElements()) {
                    other = (PolyPeak)e.nextElement();
                    if (best != null && other.amplitude <= best.amplitude) continue;
                    best = other;
                }
                this.alternate.addElement(best);
                continue;
            }
            this.alternate.addElement(null);
        }
    }

    private Hashtable get_peak_hash() {
        Hashtable<String, Vector> h = new Hashtable<String, Vector>();
        for (int i = 0; i <= 3; i = (int)((short)(i + 1))) {
            Vector v = this.all_peaks[i];
            int size = v.size();
            for (int j = 0; j < size; ++j) {
                Vector peaks;
                PolyPeak p = (PolyPeak)v.elementAt(j);
                String key = Integer.toString(p.peak);
                if (h.containsKey(key)) {
                    peaks = (Vector)h.get(key);
                } else {
                    peaks = new Vector();
                    h.put(key, peaks);
                }
                peaks.addElement(p);
            }
        }
        return h;
    }

    public void dump_peaks() {
        for (short i = 0; i <= 3; i = (short)(i + 1)) {
            char base = TraceFile.index_to_base(i);
            Vector v = this.all_peaks[i];
            System.out.println(i + " " + v.size());
            for (int j = 0; j < v.size(); ++j) {
                PolyPeak p = (PolyPeak)v.elementAt(j);
                System.out.println(base + " " + p.peak);
            }
        }
    }

    private void find_peaks() {
        int this_sample = 0;
        int last_sample = 0;
        int minimum_amp = (int)((double)this.trace.max_amplitude * 0.05);
        this.all_peaks = new Vector[4];
        for (short i = 0; i <= 3; i = (short)(i + 1)) {
            Vector<PolyPeak> v;
            PolyPeak p = new PolyPeak(i);
            this.all_peaks[i] = v = new Vector<PolyPeak>();
            for (int j = 0; j < this.trace.num_samples; ++j) {
                this_sample = this.trace.trace_data[i][j];
                if (this_sample > last_sample) {
                    if (p.peak > 0) {
                        p.end = j - 1;
                        if (p.amplitude > minimum_amp) {
                            v.addElement(p);
                        }
                        p = new PolyPeak(i);
                    } else if (p.clip_start > 0) {
                        p.peak = p.clip_start + (p.clip_end - p.clip_start) / 2;
                        p.amplitude = last_sample;
                        p.end = j - 1;
                        if (p.amplitude > minimum_amp) {
                            v.addElement(p);
                        }
                        p = new PolyPeak(i);
                    }
                    if (p.start == -1) {
                        p.start = j;
                    }
                } else if (this_sample == last_sample) {
                    if (p.clip_start == 0) {
                        p.clip_start = j - 1;
                    }
                    p.clip_end = j;
                } else if (this_sample < last_sample && p.peak == 0) {
                    p.peak = p.clip_start == 0 ? j - 1 : p.clip_start + (p.clip_end - p.clip_start) / 2;
                    p.amplitude = last_sample;
                }
                last_sample = this_sample;
            }
        }
    }

    public static void main(String[] argv) {
        StreamDelegator.set_local(true);
        String fn = argv.length > 0 ? argv[0] : "46061.scf";
        System.err.println("file:" + fn);
        TraceFile t = new TraceFile(fn);
        BaseBasecaller bc = new BaseBasecaller(t);
    }

    public Vector get_called() {
        return this.called;
    }

    public Vector get_alternate() {
        return this.alternate;
    }

    public short get_called_base(int i) {
        return ((PolyPeak)this.called.elementAt((int)i)).base;
    }

    public void assign_called() {
        int floor;
        int distance;
        PolyPeak here;
        Hashtable peaks = this.get_peak_hash();
        this.called = new Vector();
        for (int i = 0; i < this.trace.num_samples; ++i) {
            String key = Integer.toString(i);
            if (!peaks.containsKey(key)) continue;
            Vector hits = (Vector)peaks.get(key);
            PolyPeak peak_to_use = null;
            Vector candidates = (Vector)hits.clone();
            if (candidates.size() == 1) {
                peak_to_use = (PolyPeak)candidates.elementAt(0);
            } else {
                int len = candidates.size();
                int use_height = -1;
                for (int j = 0; j < len; ++j) {
                    PolyPeak p = (PolyPeak)candidates.elementAt(j);
                    int height = this.trace.trace_data[p.base][p.peak];
                    if (height <= use_height) continue;
                    peak_to_use = p;
                    use_height = height;
                }
            }
            this.called.addElement(peak_to_use);
        }
        ArrayList<Integer> spacing = new ArrayList<Integer>();
        int len = this.called.size();
        PolyPeak prev = (PolyPeak)this.called.elementAt(0);
        for (int i = 1; i < len; ++i) {
            here = (PolyPeak)this.called.elementAt(i);
            distance = here.peak - prev.peak;
            spacing.add(new Integer(distance));
            prev = here;
        }
        Stats st = new Stats(spacing);
        int low_spacing_cutoff = (int)st.get_95_percent_confidence_interval(false);
        if (low_spacing_cutoff < (floor = (int)Math.ceil(st.median() * 0.33))) {
            low_spacing_cutoff = floor;
        }
        int pass_number = 0;
        while (true) {
            HashSet<PolyPeak> disqualified = new HashSet<PolyPeak>();
            prev = (PolyPeak)this.called.elementAt(0);
            int l = this.called.size();
            for (int i = 1; i < l; ++i) {
                here = (PolyPeak)this.called.elementAt(i);
                if (!disqualified.contains(here) && !disqualified.contains(prev) && (distance = here.peak - prev.peak) <= low_spacing_cutoff) {
                    disqualified.add(prev.amplitude > here.amplitude ? here : prev);
                }
                prev = here;
            }
            System.err.println("pass:" + ++pass_number + " pruned:" + disqualified.size());
            if (disqualified.size() == 0) break;
            this.called.removeAll(disqualified);
        }
    }

    public void set_tracefile_values() {
        int base_count;
        this.trace.num_bases = base_count = this.called.size();
        this.trace.bases = new char[base_count];
        this.trace.base_position = new int[base_count];
        for (int i = 0; i < base_count; ++i) {
            PolyPeak called_peak = (PolyPeak)this.called.elementAt(i);
            this.trace.bases[i] = called_peak.get_base();
            this.trace.base_position[i] = called_peak.peak;
        }
    }
}

