/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.ColorManager;
import TCGA.ColorScheme;
import TCGA.ContrastControlPanel;
import TCGA.ControlFrame;
import TCGA.ControlFrameListener;
import TCGA.CopyNumberVariationImage;
import TCGA.GenomicMeasurement;
import TCGA.HeatmapConfiguration;
import TCGA.HelpLauncher;
import TCGA.SampleSubsets;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ContrastControl
implements ControlFrameListener,
Observer {
    private static String LABEL_HELP = "Help";
    private ControlFrame jf;
    private JTabbedPane jtb;
    private JButton jb_help;
    private JCheckBoxMenuItem jcbmi_multi;
    private CopyNumberVariationImage cnvi = null;
    private GenomicMeasurement gm;
    private ArrayList<ContrastControlPanel> ccps;
    private HeatmapConfiguration config;

    public ContrastControl(HeatmapConfiguration config) {
        this.config = config;
        this.gm = config.gm;
        this.setup();
    }

    private void setup() {
        for (ColorScheme cs : this.gm.get_color_manager().get_all_color_schemes()) {
            cs.addObserver(this);
        }
        this.ccps = new ArrayList();
        this.jf = new ControlFrame(this);
        JPanel jp_buttons = new JPanel();
        jp_buttons.add(this.jf.generate_ok_button());
        jp_buttons.add(this.jf.generate_apply_button());
        jp_buttons.add(new JLabel("      "));
        this.jb_help = new JButton(LABEL_HELP);
        this.jb_help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpLauncher hl = new HelpLauncher("color_contrast");
                hl.launch_url();
            }
        });
        jp_buttons.add(this.jb_help);
        jp_buttons.add(new JLabel("      "));
        jp_buttons.add(this.jf.generate_cancel_button());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        SampleSubsets sample_subsets = this.gm.get_sample_subsets();
        ColorManager cm = this.gm.get_color_manager();
        if (cm.is_multicolor_enabled()) {
            HashMap<String, ColorScheme> colors = cm.get_subset_colors();
            this.jtb = new JTabbedPane();
            ContrastControlPanel ccp = new ContrastControlPanel(cm.get_global_color_scheme(), null, this.config);
            panel.add(ccp);
            this.ccps.add(ccp);
            ccp.setToolTipText("This tab controls the display (color and contrast) for the entire dataset.");
            this.jtb.addTab("Combined", ccp);
            for (String subset : sample_subsets.get_subsets_arraylist()) {
                ccp = new ContrastControlPanel(colors.get(subset), subset, this.config);
                ccp.setToolTipText("This tab controls the display (color and contrast) for the " + subset + " portion of the data.");
                this.ccps.add(ccp);
                this.jtb.addTab(subset, ccp);
            }
            panel.add(this.jtb);
            this.configure_enabled_tabs();
            JMenuBar mb = new JMenuBar();
            this.jf.setJMenuBar(mb);
            JMenu m = new JMenu("Tools");
            m.setMnemonic(84);
            mb.add(m);
            this.jcbmi_multi = new JCheckBoxMenuItem("Independent subset controls", cm.is_multicolor_enabled());
            m.add(this.jcbmi_multi);
            this.jcbmi_multi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorManager cm = ContrastControl.this.gm.get_color_manager();
                    cm.set_multicolor_enabled(ContrastControl.this.jcbmi_multi.getState());
                    ContrastControl.this.configure_enabled_tabs();
                }
            });
            JMenu sub = new JMenu("Set all colors...");
            m.add(sub);
            ActionListener al_bg = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String color = ((AbstractButton)e.getSource()).getText();
                    for (ContrastControlPanel ccp : ContrastControl.this.ccps) {
                        ccp.set_background_color(color);
                    }
                }
            };
            ActionListener al_up = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String color = ((AbstractButton)e.getSource()).getText();
                    for (ContrastControlPanel ccp : ContrastControl.this.ccps) {
                        ccp.set_increase_color(color);
                    }
                }
            };
            ActionListener al_down = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String color = ((AbstractButton)e.getSource()).getText();
                    for (ContrastControlPanel ccp : ContrastControl.this.ccps) {
                        ccp.set_decrease_color(color);
                    }
                }
            };
            JMenu sub2 = new JMenu("Background...");
            sub.add(sub2);
            JMenuItem jmi = new JMenuItem("White");
            sub2.add(jmi);
            jmi.addActionListener(al_bg);
            jmi = new JMenuItem("Black");
            sub2.add(jmi);
            jmi.addActionListener(al_bg);
            sub2 = new JMenu("Increase...");
            sub.add(sub2);
            for (String color : ColorScheme.get_color_names()) {
                jmi = new JMenuItem(color);
                sub2.add(jmi);
                jmi.addActionListener(al_up);
            }
            sub2 = new JMenu("Decrease...");
            sub.add(sub2);
            for (String color : ColorScheme.get_color_names()) {
                jmi = new JMenuItem(color);
                sub2.add(jmi);
                jmi.addActionListener(al_down);
            }
        } else {
            ContrastControlPanel ccp = new ContrastControlPanel(cm.get_global_color_scheme(), null, this.config);
            panel.add(ccp);
            this.ccps.add(ccp);
        }
        panel.add(jp_buttons);
        this.jf.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
                ContrastControl.this.update_current_values();
            }
        });
        this.jf.setTitle("Color and contrast controls");
        this.jf.getContentPane().add(new JScrollPane(panel));
        this.jf.pack();
        this.jf.setVisible(true);
    }

    private void update_current_values() {
        for (ContrastControlPanel ccp : this.ccps) {
            ccp.set_current_values();
        }
    }

    public void update(Observable o, Object arg) {
        this.update_current_values();
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public void setState(int state) {
        this.jf.setState(state);
    }

    public void apply_changes() {
        int len = this.ccps.size();
        for (int i = 0; i < len; ++i) {
            this.ccps.get(i).apply_changes(i == len - 1);
        }
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        try {
            HeatmapConfiguration hc = new HeatmapConfiguration();
            hc.gm = new GenomicMeasurement("80.txt.gz", false);
            ContrastControl contrastControl = new ContrastControl(hc);
        }
        catch (Exception e) {
            System.err.println("error:" + e);
        }
    }

    private JPanel get_buffer_titled_panel(JPanel panel, String title) {
        JPanel jp_buffer = new JPanel();
        jp_buffer.setLayout(new BorderLayout());
        jp_buffer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jp_titled = new JPanel();
        jp_titled.setLayout(new BoxLayout(jp_titled, 3));
        jp_titled.setBorder(BorderFactory.createTitledBorder(title));
        jp_buffer.add("Center", jp_titled);
        panel.add(jp_buffer);
        return jp_titled;
    }

    private void configure_enabled_tabs() {
        ColorManager cm = this.gm.get_color_manager();
        ArrayList<String> ss = this.gm.get_sample_subsets().get_subsets_arraylist();
        int si = this.jtb.getSelectedIndex();
        boolean first = !cm.is_multicolor_enabled();
        this.jtb.setEnabledAt(0, first);
        for (int i = 1; i <= ss.size(); ++i) {
            this.jtb.setEnabledAt(i, !first);
        }
        int move_to = -1;
        if (si == 0) {
            if (!first) {
                move_to = 1;
            }
        } else if (first) {
            move_to = 0;
        }
        if (move_to != -1) {
            this.jtb.setSelectedIndex(move_to);
            this.apply_changes();
        }
    }
}

