/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.ColorSchemeModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorScheme
extends Observable {
    public static String COLOR_SCHEME_RED_GREEN = "Red/Green";
    public static String COLOR_SCHEME_RED_BLUE = "Red/Blue";
    public static String COLOR_SCHEME_MAGENTA_CYAN = "Magenta/Cyan";
    public static String COLOR_SCHEME_RED_CYAN = "Red/Cyan";
    public static String COLOR_SCHEME_GREEN_MAGENTA = "Green/Magenta";
    public static String COLOR_SCHEME_BLUE_YELLOW = "Blue/Yellow";
    public static String COLOR_SCHEME_GREEN_YELLOW = "Green/Yellow";
    public static String COLOR_SCHEME_ORANGE_WHITE = "Orange/White";
    public static String COLOR_SCHEME_YELLOW_WHITE = "Yellow/White";
    public static final String LABEL_BLACK = "Black";
    public static final String LABEL_WHITE = "White";
    public static final String LABEL_RED = "Red";
    public static final String LABEL_GREEN = "Green";
    public static final String LABEL_BLUE = "Blue";
    public static final String LABEL_CYAN = "Cyan";
    public static final String LABEL_MAGENTA = "Magenta";
    public static final String LABEL_YELLOW = "Yellow";
    public static final String LABEL_ORANGE = "Orange";
    private ColorSchemeModel csm;
    private static final int MAX_COLOR_VALUE = 255;
    private Color[] color_map_up;
    private Color[] color_map_down;
    private HashSet<Color> unique_colors;
    private static ArrayList<String> color_names_sorted;
    private static HashMap<String, Color> color_names;
    private static HashMap<String, ColorSchemeModel> color_schemes;

    public ColorScheme(Color up_color, Color down_color) {
        this.csm = new ColorSchemeModel(up_color, down_color);
        this.set_colorscheme_model(this.csm);
    }

    public ColorScheme(String name) {
        ColorSchemeModel model = color_schemes.get(name);
        if (model != null) {
            this.csm = new ColorSchemeModel(model.up_color, model.down_color);
            this.set_colorscheme_model(this.csm);
        } else {
            System.err.println("ERROR, no scheme named " + name);
        }
    }

    public void set_colorscheme_model(ColorSchemeModel csm) {
        this.set_colorscheme_model(csm, true);
    }

    public void set_colorscheme_model(ColorSchemeModel csm, boolean notify) {
        this.csm = csm;
        this.unique_colors = new HashSet();
        this.build_up_color_map();
        this.build_down_color_map();
        if (notify) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void notify_observers() {
        this.setChanged();
        this.notifyObservers();
    }

    public ColorSchemeModel get_colorscheme_model() {
        return this.csm;
    }

    public static ColorSchemeModel get_colorscheme_model(String name) {
        return color_schemes.get(name);
    }

    public int[] get_gradients() {
        return this.csm.gradients;
    }

    public int get_minimum_intensity_percent() {
        return this.csm.min_intensity_percent;
    }

    public Color[] get_up_color_map() {
        return this.color_map_up;
    }

    public Color[] get_down_color_map() {
        return this.color_map_down;
    }

    private void build_up_color_map() {
        this.color_map_up = this.get_color_map(this.csm.up_color, this.csm.gradients);
    }

    private void build_down_color_map() {
        this.color_map_down = this.get_color_map(this.csm.down_color, this.csm.gradients);
    }

    private Color[] get_color_map(Color max_color, int[] gradients) {
        int i;
        Color background_color = this.csm.white_mode ? Color.white : Color.black;
        int[] max_color_channel = new int[3];
        boolean[] channel_active = new boolean[3];
        max_color_channel[0] = max_color.getRed();
        max_color_channel[1] = max_color.getGreen();
        max_color_channel[2] = max_color.getBlue();
        for (i = 0; i < 3; ++i) {
            channel_active[i] = max_color_channel[i] > 0;
        }
        int steps = gradients.length - 1;
        int chunk_size = steps == 0 ? 0 : (100 - this.csm.min_intensity_percent) / steps;
        int v = 100 - chunk_size * steps;
        int[] intensities = new int[gradients.length];
        for (i = 0; i < gradients.length; ++i) {
            intensities[i] = v;
            v += chunk_size;
        }
        this.unique_colors.add(background_color);
        Color[] results = new Color[99];
        for (i = 0; i < gradients[0]; ++i) {
            results[i] = background_color;
        }
        int[] rgb = new int[3];
        for (i = 0; i < gradients.length; ++i) {
            int j;
            Color c;
            int end;
            int n = end = i == gradients.length - 1 ? 98 : gradients[i + 1];
            if (intensities[i] == 100) {
                c = max_color;
            } else {
                if (this.csm.white_mode) {
                    for (j = 0; j < 3; ++j) {
                        rgb[j] = channel_active[j] ? max_color_channel[j] : 255 - 255 * intensities[i] / 100;
                    }
                } else {
                    rgb[0] = max_color.getRed() * intensities[i] / 100;
                    rgb[1] = max_color.getGreen() * intensities[i] / 100;
                    rgb[2] = max_color.getBlue() * intensities[i] / 100;
                }
                c = new Color(rgb[0], rgb[1], rgb[2]);
            }
            this.unique_colors.add(c);
            for (j = gradients[i]; j <= end; ++j) {
                results[j] = c;
            }
        }
        return results;
    }

    public static void main(String[] argv) {
        ColorScheme cs = new ColorScheme(Color.red, Color.blue);
        int[] gradients = new int[]{2, 5, 10};
    }

    private static HashMap<String, ColorSchemeModel> color_scheme_setup() {
        HashMap<String, ColorSchemeModel> results = new HashMap<String, ColorSchemeModel>();
        results.put(COLOR_SCHEME_RED_GREEN, new ColorSchemeModel(Color.red, Color.green));
        results.put(COLOR_SCHEME_RED_BLUE, new ColorSchemeModel(Color.red, Color.blue));
        results.put(COLOR_SCHEME_MAGENTA_CYAN, new ColorSchemeModel(Color.magenta, Color.cyan));
        return results;
    }

    private static HashMap<String, Color> color_names_setup() {
        HashMap<String, Color> results = new HashMap<String, Color>();
        results.put(LABEL_WHITE, Color.white);
        results.put(LABEL_RED, Color.red);
        results.put(LABEL_BLUE, Color.blue);
        results.put(LABEL_GREEN, Color.green);
        results.put(LABEL_CYAN, Color.cyan);
        results.put(LABEL_MAGENTA, Color.magenta);
        results.put(LABEL_YELLOW, Color.yellow);
        results.put(LABEL_ORANGE, Color.orange);
        color_names_sorted = new ArrayList();
        color_names_sorted.addAll(results.keySet());
        Collections.sort(color_names_sorted);
        return results;
    }

    public static ArrayList<String> get_color_names() {
        return color_names_sorted;
    }

    public static Color get_color(String name) {
        return color_names.get(name);
    }

    public HashSet<Color> get_unique_colors() {
        return this.unique_colors;
    }

    public void import_gradients(ColorSchemeModel csm_arg) {
        this.csm.gradients = csm_arg.gradients;
        this.csm.min_intensity_percent = csm_arg.min_intensity_percent;
        this.set_colorscheme_model(this.csm);
    }

    static {
        color_names = ColorScheme.color_names_setup();
        color_schemes = ColorScheme.color_scheme_setup();
    }
}

