/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.GenomicSample;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cluster
implements Comparator {
    public static final double UNDEF_DISTANCE = -100.0;
    public static final int DISTANCE_METHOD_COMPLETE = 1;
    public static final int DISTANCE_METHOD_MEAN = 2;
    public static final int DISTANCE_METHOD_MINIMUM = 3;
    private int[] ids = null;
    private ArrayList<GenomicSample> sample_data = null;
    private double internal_distance;

    public abstract String get_method_name();

    public abstract boolean are_higher_distance_values_closer();

    public abstract double compute_single_distance(byte[] var1, byte[] var2) throws ArithmeticException;

    public abstract Cluster create_new_cluster();

    public abstract double get_default_cluster_stop_threshold();

    public abstract void precluster(HashSet<Cluster> var1, ArrayList<GenomicSample> var2);

    public abstract boolean validate_distance_matrix_cache();

    public int[] get_ids() {
        return this.ids;
    }

    public void set_internal_distance(double d) {
        this.internal_distance = d;
    }

    public double get_internal_distance() {
        return this.internal_distance;
    }

    public void add(int id) {
        int current_size = this.ids == null ? 0 : this.ids.length;
        int next_size = current_size + 1;
        int[] ids_new = new int[next_size];
        if (current_size > 0) {
            System.arraycopy(this.ids, 0, ids_new, 0, current_size);
        }
        ids_new[current_size] = id;
        this.ids = ids_new;
    }

    public void addAll(Cluster other) {
        int[] other_ids = other.get_ids();
        int current_size = this.ids == null ? 0 : this.ids.length;
        int next_size = current_size + other_ids.length;
        int[] ids_new = new int[next_size];
        if (current_size > 0) {
            System.arraycopy(this.ids, 0, ids_new, 0, current_size);
        }
        System.arraycopy(other_ids, 0, ids_new, current_size, other_ids.length);
        this.ids = ids_new;
    }

    private void dump_array(String msg, int[] array) {
        System.err.println(msg);
        if (array == null) {
            System.err.println("  null");
        } else {
            for (int i = 0; i < array.length; ++i) {
                System.err.println("  " + array[i]);
            }
        }
    }

    public int size() {
        return this.ids.length;
    }

    public double compare_cluster(Cluster other, double[][] distance_matrix, int distance_metric) {
        int[] other_ids = other.get_ids();
        double result = -100.0;
        if (this.ids.length == 1 && other_ids.length == 1) {
            result = distance_matrix[this.ids[0]][other_ids[0]];
        } else {
            int usable = 0;
            if (distance_metric == 2) {
                double usable_distances = 0.0;
                for (int i = 0; i < this.ids.length; ++i) {
                    int x = this.ids[i];
                    for (int j = 0; j < other_ids.length; ++j) {
                        int y = other_ids[j];
                        double distance = distance_matrix[x][y];
                        if (distance == -100.0) continue;
                        ++usable;
                        usable_distances += distance;
                    }
                }
                result = usable == 0 ? -100.0 : usable_distances / (double)usable;
            } else if (distance_metric == 1) {
                result = this.are_higher_distance_values_closer() ? this.find_lowest_distance(other_ids, distance_matrix) : this.find_highest_distance(other_ids, distance_matrix);
            } else if (distance_metric == 3) {
                result = this.are_higher_distance_values_closer() ? this.find_highest_distance(other_ids, distance_matrix) : this.find_lowest_distance(other_ids, distance_matrix);
            } else {
                System.err.println("ERROR: unknown distance method!");
            }
        }
        return result;
    }

    public int compare(Object x, Object y) {
        int ys;
        int xs = ((Cluster)x).size();
        if (xs == (ys = ((Cluster)y).size())) {
            return 0;
        }
        if (xs < ys) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object x, Object y) {
        return ((Cluster)x).size() == ((Cluster)y).size();
    }

    private double find_lowest_distance(int[] other_ids, double[][] distance_matrix) {
        int usable = 0;
        double result = -100.0;
        for (int i = 0; i < this.ids.length; ++i) {
            int x = this.ids[i];
            for (int j = 0; j < other_ids.length; ++j) {
                int y = other_ids[j];
                double distance = distance_matrix[x][y];
                if (distance == -100.0) continue;
                if (usable++ == 0) {
                    result = distance;
                }
                if (!(distance < result)) continue;
                result = distance;
            }
        }
        return result;
    }

    private double find_highest_distance(int[] other_ids, double[][] distance_matrix) {
        int usable = 0;
        double result = -100.0;
        for (int i = 0; i < this.ids.length; ++i) {
            int x = this.ids[i];
            for (int j = 0; j < other_ids.length; ++j) {
                int y = other_ids[j];
                double distance = distance_matrix[x][y];
                if (distance == -100.0) continue;
                if (usable++ == 0) {
                    result = distance;
                }
                if (!(distance > result)) continue;
                result = distance;
            }
        }
        return result;
    }

    public ArrayList<GenomicSample> get_sample_data() {
        return this.sample_data;
    }

    public void set_sample_data(ArrayList<GenomicSample> sample_data) {
        this.sample_data = sample_data;
    }

    public static String describe_distance_method(int method) {
        switch (method) {
            case 1: {
                return "Complete";
            }
            case 2: {
                return "Mean";
            }
            case 3: {
                return "Minimum";
            }
        }
        return null;
    }
}

