/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.AnnotationFlatfile2;
import TCGA.BinLabel;
import TCGA.ClusterTool;
import TCGA.ColorManager;
import TCGA.CommentOptions;
import TCGA.DataScales;
import TCGA.DividerManager;
import TCGA.DividerSet;
import TCGA.EuclideanClusterControl;
import TCGA.GenomicBin;
import TCGA.GenomicLocation;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.GenomicSet;
import TCGA.HeatmapConfiguration;
import TCGA.HelpLauncher;
import TCGA.ImageScalePanel2;
import TCGA.Observable2;
import TCGA.Options;
import TCGA.Pathway;
import TCGA.PathwayGenes;
import TCGA.PearsonClusterControl;
import TCGA.PopupListener;
import TCGA.RubberBandSelection;
import TCGA.RubberBandSelectionScaled;
import TCGA.SampleSortTools;
import TCGA.SampleSubsets;
import TCGA.SubsetCombinerControl;
import TCGA.URLLauncher;
import TCGA.WebTools;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;

public class ChromDecoratorPanel
extends ImageScalePanel2
implements MouseListener,
ActionListener,
Observer {
    private HeatmapConfiguration config;
    private GenomicSet gs;
    private GenomicMeasurement gm;
    private AnnotationFlatfile2 af;
    private PearsonClusterControl pcc;
    private EuclideanClusterControl ecc;
    private String tooltip_field = null;
    private RubberBandSelectionScaled rbs;
    private PopupListener pul;
    private Point last_mouse_press_point = null;
    private SampleSubsets sample_subsets;
    private static final String LABEL_CGWB_LAUNCH = "Launch CGWB";
    private static final String LABEL_CGWB_LAUNCH_REGION = "Launch CGWB (region)";
    private static final String LABEL_VIEW_RAW_DATA = "View raw data";
    private static final String LABEL_ZOOM_TO_SELECTION = "Zoom to selection";
    private static final String LABEL_NEW_WINDOW_FOR_SELECTION = "New window for selection";
    private static final String LABEL_SORT_PREFIX = "Sort samples by data for region ";
    private static final String LABEL_SORT_SUFFIX = "...";
    private static final String LABEL_PATHWAYS_FOR_MARKER_PREFIX = "Pathways for region ";
    private static final String LABEL_PATHWAY_PREFIX = "Launch PID for pathway ";
    private static final String LABEL_EG_PREFIX = "Launch Entrez Gene for ";
    private static final String LABEL_HELP = "Help: heatmap panel";
    private static Color COLOR = new Color(34, 139, 34);
    private boolean display_sample_ids = false;
    private Rectangle r_zoom_indicator;
    private boolean show_zoom_level = true;
    private JMenuItem jmi_sort;
    private JMenuItem jmi_eg;
    private JMenu jm_sort_subset;
    private JMenu jm_pathways;
    private int popup_bin_index;
    private HashSet<JMenuItem> pathway_mi = new HashSet();
    private Observable2 obs = new Observable2();

    public ChromDecoratorPanel(BufferedImage offscreen, JScrollBar jsb_h, JScrollBar jsb_v, HeatmapConfiguration cfg) {
        super(offscreen, jsb_h, jsb_v);
        JRadioButtonMenuItem jrb;
        this.config = cfg;
        this.gs = this.config.gs;
        this.gm = this.config.gm;
        this.af = this.config.af;
        this.setToolTipText("sample ID should be here");
        this.addMouseListener(this);
        this.rbs = new RubberBandSelectionScaled(this);
        this.sample_subsets = this.gm.get_sample_subsets();
        JPopupMenu jpm = new JPopupMenu();
        JMenuItem jmi = new JMenuItem(LABEL_CGWB_LAUNCH);
        jpm.add(jmi);
        jmi.addActionListener(this);
        if (this.config.pathway != null) {
            jmi = new JMenuItem(LABEL_PATHWAY_PREFIX + this.config.pathway.name);
            jpm.add(jmi);
            jmi.addActionListener(this);
        }
        this.jmi_eg = new JMenuItem(LABEL_EG_PREFIX);
        jpm.add(this.jmi_eg);
        this.jmi_eg.addActionListener(this);
        jmi = new JMenuItem(LABEL_ZOOM_TO_SELECTION);
        jpm.add(jmi);
        jmi.addActionListener(this);
        jmi = new JMenuItem(LABEL_NEW_WINDOW_FOR_SELECTION);
        jpm.add(jmi);
        jmi.addActionListener(this);
        jpm.add(new JSeparator());
        ButtonGroup bg = new ButtonGroup();
        if (this.sample_subsets.isEmpty()) {
            this.jmi_sort = new JMenuItem("sort by whatever");
            jpm.add(this.jmi_sort);
            this.jmi_sort.addActionListener(this);
        } else {
            this.jm_sort_subset = new JMenu("sort by marker + subset");
            jpm.add(this.jm_sort_subset);
            jrb = new JRadioButtonMenuItem(SampleSortTools.CLUSTER_SUBSET_ALL, true);
            bg.add(jrb);
            jrb.addActionListener(this);
            this.jm_sort_subset.add(jrb);
        }
        this.jm_pathways = new JMenu("pathways for marker");
        jpm.add(this.jm_pathways);
        if (!this.sample_subsets.isEmpty()) {
            for (String subset : this.sample_subsets.get_subsets_arraylist()) {
                jrb = new JRadioButtonMenuItem(subset, false);
                this.jm_sort_subset.add(jrb);
                bg.add(jrb);
                jrb.addActionListener(this);
            }
        }
        if (Options.INCLUDE_DEVELOPMENT_CODE) {
            jmi = new JMenuItem("Combine datasets...[development]");
            jpm.add(jmi);
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new SubsetCombinerControl(ChromDecoratorPanel.this.config);
                }
            });
            jmi = new JMenuItem("Report frequency...[development]");
            jpm.add(jmi);
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    System.err.println("FIX ME!!!");
                }
            });
        }
        jpm.add(new JSeparator());
        jpm.add(HelpLauncher.generate_jmenuitem(LABEL_HELP, "panel_heatmap"));
        this.pul = new PopupListener(this, jpm);
        this.pul.addObserver(this);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.gs.is_loaded()) {
            int x;
            FontMetrics fm;
            Font f;
            this.y_scale_check();
            ColorManager cm = this.gm.get_color_manager();
            int start_x = this.get_unscaled_x_start();
            int end_x = this.get_unscaled_x_end();
            Dimension d = this.getSize();
            float x_scale = this.get_horizontal_scale_level();
            Graphics2D g2 = (Graphics2D)g;
            Composite c_orig = g2.getComposite();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ArrayList<GenomicSample> samples = this.gm.get_visible_rows();
            float y_step = this.get_vertical_scale_level();
            if (this.display_sample_ids && y_step >= 10.0f) {
                g2.setColor(Color.gray);
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.8f);
                g2.setComposite(ac);
                int font_size = (int)(y_step - 2.0f);
                if (font_size > 15) {
                    font_size = 15;
                }
                Font f_old = g2.getFont();
                f = new Font("Times", 1, font_size);
                g2.setFont(f);
                fm = this.getFontMetrics(f);
                float y = y_step / 2.0f + (float)fm.getDescent() + 1.0f;
                x = fm.stringWidth("X") / 2;
                for (int yi = this.get_unscaled_y_start(); y < (float)d.height && yi < samples.size(); y += y_step, ++yi) {
                    GenomicSample gs = samples.get(yi);
                    g2.drawString(gs.sample_id, x, (int)y);
                }
                g2.setComposite(c_orig);
                g2.setFont(f_old);
            }
            Stroke orig_stroke = g2.getStroke();
            DividerManager dm = this.gm.get_divider_manager();
            this.paint_dividers(g2, dm.get_patient_dividers());
            this.paint_dividers(g2, dm.get_cluster_dividers());
            g2.setStroke(orig_stroke);
            BasicStroke dashed = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
            g.setColor(COLOR);
            g2.setStroke(dashed);
            if (Options.are_bins_paintable(this.gs, this)) {
                for (GenomicBin gb : this.gs.get_bins()) {
                    if (gb.end < start_x || gb.end > end_x) continue;
                    x = (int)((float)(gb.end - start_x) * x_scale);
                    g2.drawLine(x, 0, x, d.height);
                }
            }
            g2.setStroke(orig_stroke);
            if (this.rbs.has_selection()) {
                Rectangle selection = this.rbs.get_selection();
                float y_scale = this.get_vertical_scale_level();
                x = (int)((float)(selection.x - start_x) * x_scale);
                int y = (int)((float)(selection.y - this.get_unscaled_y_start()) * y_scale);
                BasicStroke dashed_heavy = new BasicStroke(2.0f, 0, 1, 1.0f, new float[]{4.0f, 1.0f}, 0.0f);
                g2.setStroke(dashed_heavy);
                g2.setColor(cm.get_selection_color());
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                int xw = (int)((float)selection.width * x_scale);
                int yw = (int)((float)selection.height * y_scale);
                if (xw > d.width) {
                    xw = d.width;
                }
                if (yw > d.height) {
                    yw = d.height;
                }
                g2.drawRect(x, y, xw, yw);
                g2.setStroke(orig_stroke);
            }
            if (this.show_zoom_level) {
                f = this.getFont();
                fm = this.getFontMetrics(f);
                int inset_border = 8;
                int text_border = 1;
                int string_border = 3;
                String msg = this.get_zoom_level_string() + "x";
                int w = fm.stringWidth(msg) + string_border * 2;
                int x1 = d.width - w - inset_border;
                int y = inset_border;
                int h = fm.getHeight() + text_border * 2;
                float tval = 0.7f;
                if (cm.is_white_mode()) {
                    tval = 1.0f - tval;
                }
                AlphaComposite ac = AlphaComposite.getInstance(3, tval);
                g2.setComposite(ac);
                g2.setColor(cm.get_zoom_background_color());
                this.r_zoom_indicator = new Rectangle(x1, inset_border, w, h);
                g2.fillOval(this.r_zoom_indicator.x, this.r_zoom_indicator.y, this.r_zoom_indicator.width, this.r_zoom_indicator.height);
                g2.setComposite(c_orig);
                g2.setColor(cm.get_zoom_foreground_color());
                g2.drawString(msg, x1 + string_border, y + fm.getAscent() + text_border);
            }
        }
    }

    private int get_bin_index(Point mp) {
        return this.get_unscaled_point((Point)mp).x;
    }

    public String getToolTipText(MouseEvent e) {
        Point mp = e.getPoint();
        String tooltip = "";
        if (this.show_zoom_level && this.r_zoom_indicator != null && this.r_zoom_indicator.intersects(new Rectangle(mp.x, mp.y, 1, 1))) {
            String level = this.get_zoom_level_string();
            String direction = "in";
            if (level.charAt(0) == '-') {
                direction = "out";
                level = level.substring(1);
            }
            tooltip = "current horizontal magnification level ";
            tooltip = level.equals("1.0") ? tooltip.concat("(unchanged)") : tooltip.concat("(zoomed " + direction + " " + level + " times)");
        } else {
            int current_bin_index = this.get_bin_index(mp);
            Point p = this.get_unscaled_point(mp);
            int index = p.y;
            ArrayList<GenomicSample> samples = this.gm.get_visible_rows();
            String[] headers = this.gm.get_headers();
            if (index < samples.size() && current_bin_index < headers.length) {
                GenomicSample sample = samples.get(index);
                if (this.config.parent_gm != null) {
                    tooltip = "sample " + sample.sample_id + " shows ";
                    int count = 0;
                    for (String subset : this.config.parent_subsets) {
                        GenomicSample gs = this.config.parent_gm.get_sample_for_patient_subset(sample.patient_id, subset);
                        byte amount = gs.copynum_data[current_bin_index];
                        if (count++ > 0) {
                            tooltip = tooltip.concat(", ");
                        }
                        tooltip = tooltip.concat(subset + " " + (amount > 0 ? "+" + amount : Integer.valueOf(amount)));
                    }
                    tooltip = tooltip.concat(" for region " + headers[current_bin_index]);
                } else {
                    String amount_label;
                    byte amount = sample.copynum_data[current_bin_index];
                    if (amount == -99) {
                        amount_label = "has no data";
                    } else {
                        DataScales ds;
                        amount_label = amount == 0 ? "shows no change" : (amount < 0 ? "shows " + amount : "shows +" + amount);
                        boolean use_scale_info = true;
                        if (this.config != null && this.config.gm_supplemental.size() > 0 && !Options.COMBINE_DATASETS_ADD_ROWS_MODE) {
                            String data_type = this.config.gm.get_options().get("data_type").toLowerCase();
                            if (data_type.equals("copy number")) {
                                data_type = Options.ABBREVIATION_COPY_NUMBER;
                            } else if (data_type.equals("gene expression")) {
                                data_type = Options.ABBREVIATION_GENE_EXPRESSION;
                            }
                            if (headers[current_bin_index].indexOf(data_type) == -1) {
                                use_scale_info = false;
                            }
                        }
                        if (use_scale_info && (ds = this.gm.get_options().get_data_scales()) != null) {
                            amount_label = amount_label + " (" + Options.DATA_TYPE + " is " + ds.translate_amount(amount) + ")";
                        }
                    }
                    tooltip = "sample " + sample.sample_id + " " + amount_label + " for region " + headers[current_bin_index];
                    if (this.af != null && this.tooltip_field != null) {
                        ArrayList hits = this.af.find_annotations(sample);
                        Hashtable r = null;
                        if (hits != null) {
                            r = (Hashtable)hits.get(0);
                        }
                        if (r == null) {
                            tooltip = tooltip + " (no annotations)";
                        } else {
                            String value = (String)r.get(this.tooltip_field);
                            if (value == null || value.length() == 0) {
                                value = "[not specified]";
                            }
                            tooltip = tooltip + " " + this.tooltip_field + ":" + value;
                        }
                    }
                }
            }
        }
        return tooltip;
    }

    public void center_on_x(int x) {
        super.center_on_x(x);
        this.rbs.set_selection(new Rectangle(x, 0, 1, this.gm.get_row_count()));
    }

    public RubberBandSelection get_selection() {
        return this.rbs;
    }

    public void center_on_region(Rectangle r) {
        super.center_on_region(r);
        this.rbs.set_selection(r);
    }

    public void mousePressed(MouseEvent e) {
        this.last_mouse_press_point = e.getPoint();
        if (e.getClickCount() > 1) {
            Rectangle r = this.gm.generate_selection(this.get_bin_index(this.last_mouse_press_point));
            this.rbs.set_selection(r);
            this.zoom_to_selection();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void set_tooltip_field(String f) {
        this.tooltip_field = f;
    }

    public String get_tooltip_field() {
        return this.tooltip_field;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof AbstractButton) {
            PathwayGenes pwg;
            Pathway p;
            JRadioButtonMenuItem jrb;
            String[] headers;
            String label = ((AbstractButton)src).getText();
            if (label.equals(LABEL_CGWB_LAUNCH)) {
                this.launch_CGWB(false);
            }
            if (label.equals(LABEL_CGWB_LAUNCH_REGION)) {
                this.launch_CGWB(true);
            }
            if (label.equals(LABEL_VIEW_RAW_DATA)) {
                this.view_raw_data();
            }
            if (label.equals(LABEL_ZOOM_TO_SELECTION)) {
                this.zoom_to_selection();
            }
            if (label.equals(LABEL_NEW_WINDOW_FOR_SELECTION)) {
                this.new_window_for_selection();
            }
            if (label.indexOf(LABEL_PATHWAY_PREFIX) == 0) {
                this.launch_pathway();
            }
            if (label.indexOf(LABEL_EG_PREFIX) == 0 && this.popup_bin_index < (headers = this.gm.get_headers()).length) {
                String marker = headers[this.popup_bin_index];
                URLLauncher.launch_url(WebTools.entrez_gene_link(marker), "eg");
            }
            if (src.equals(this.jmi_sort)) {
                this.sort_by_bin(this.popup_bin_index, null);
            }
            if (src instanceof JRadioButtonMenuItem && (jrb = (JRadioButtonMenuItem)src).isSelected()) {
                this.sort_by_bin(this.popup_bin_index, jrb.getText());
            }
            if (this.pathway_mi.contains(src) && (p = (pwg = new PathwayGenes()).get_pathway(label)) != null) {
                this.obs.setChanged();
                this.obs.notifyObservers(p);
            }
        }
    }

    public void sort_by_bin(int bin, String subset) {
        float average = this.gm.sort_by_bin(bin, subset);
        JScrollBar jsb_v = this.get_vertical_scrollbar();
        if (jsb_v != null) {
            jsb_v.setValue(average < 0.0f ? jsb_v.getMinimum() : jsb_v.getMaximum());
        }
    }

    public void launch_pathway() {
        if (this.config.pathway != null) {
            String url = "http://pid.nci.nih.gov/search/pathway_landing.shtml?pathway_id=" + this.config.pathway.pathway_id + ";what=graphic;gif=on";
            System.err.println("url=" + url);
            if (url != null) {
                URLLauncher.launch_url(url, "pathway");
            }
        }
    }

    public void launch_CGWB(boolean force_region) {
        GenomicLocation gl = null;
        String bin_label = null;
        if (this.rbs.has_selection()) {
            int end;
            int start = this.rbs.get_start_x();
            if (start == (end = this.rbs.get_end_x())) {
                BinLabel bl;
                bin_label = this.rbs.get_selected_label();
                System.err.println("BL is:" + bin_label);
                if (bin_label == null && (bl = new BinLabel(bin_label = this.get_bin_label(start))).is_genomic()) {
                    gl = bl.get_genomic_location();
                }
            } else {
                GenomicLocation gl1 = this.find_genomic_location(this.rbs.get_start_x());
                GenomicLocation gl2 = this.find_genomic_location(this.rbs.get_end_x());
                System.err.println("start=" + this.rbs.get_start_x() + " end:" + this.rbs.get_end_x());
                if (gl1.chromosome.equals(gl2.chromosome)) {
                    gl = new GenomicLocation();
                    gl.chromosome = gl1.chromosome;
                    gl.start = gl1.start;
                    gl.end = gl2.end;
                } else {
                    System.err.println("ERROR: selection spans chromosomes!");
                    gl = gl1;
                }
            }
        } else {
            bin_label = this.get_bin_label(this.last_mouse_press_point);
            BinLabel bl = new BinLabel(bin_label);
            if (bl.is_genomic()) {
                gl = bl.get_genomic_location();
            }
        }
        String spec = null;
        if (gl != null) {
            spec = "/cgi-bin/hgTracks?position=" + gl.get_ucsc_location();
        } else {
            String gene;
            if (bin_label.indexOf(",") > 0) {
                Object[] values = bin_label.split(",");
                gene = (String)JOptionPane.showInputDialog(this, "Choose a marker at this location:", "Select marker", 3, null, values, null);
            } else {
                gene = bin_label;
            }
            if (gene != null) {
                spec = "/cgi-bin/fwd?gene=" + gene + "&hint=tcga";
                CommentOptions options = this.gm.get_options();
                String pid = options.get("cgwb_project_id");
                if (pid != null) {
                    spec = spec + "&project_id=" + pid;
                }
                System.err.println("CGWB link: " + spec);
            }
        }
        if (spec != null) {
            URLLauncher.launch_modified_url(spec, "cgwb");
        }
    }

    public void zoom_to_selection() {
        Object gl = null;
        Object bin_label = null;
        if (this.rbs.has_selection()) {
            int needed_buffer;
            int min_size;
            int length;
            int end;
            int start;
            if (this.config.enable_horizontal_zoom.booleanValue()) {
                start = this.rbs.get_start_x();
                end = this.rbs.get_end_x();
                length = end - start + 1;
                min_size = Options.MINIMUM_BINS_TO_DISPLAY_IN_SELECTION_ZOOM;
                needed_buffer = 0;
                if (length < min_size) {
                    needed_buffer = (min_size - length) / 2;
                }
                this.zoom_to_selection(start - needed_buffer, length + needed_buffer * 2);
            }
            if (this.config.enable_vertical_zoom.booleanValue()) {
                start = this.rbs.get_start_y();
                end = this.rbs.get_end_y();
                length = end - start + 1;
                min_size = Options.MINIMUM_BINS_TO_DISPLAY_IN_SELECTION_ZOOM;
                needed_buffer = 0;
                if (length < min_size) {
                    needed_buffer = (min_size - length) / 2;
                }
                this.zoom_to_vertical_selection(start - needed_buffer, length + needed_buffer * 2);
            }
        }
    }

    public void new_window_for_selection() {
        Object gl = null;
        Object bin_label = null;
        if (this.rbs.has_selection()) {
            Rectangle sel = this.rbs.get_selection();
            this.obs.setChanged();
            this.obs.notifyObservers(sel);
        } else {
            JOptionPane.showMessageDialog(this, "First select a region with the left mouse button.");
        }
    }

    private String get_bin_label(Point mp) {
        return this.get_bin_label(this.get_bin_index(mp));
    }

    private String get_bin_label(int index) {
        return this.gm.get_headers()[index];
    }

    private GenomicLocation find_genomic_location(int bin_index) {
        String bin_label = this.get_bin_label(bin_index);
        BinLabel bl = new BinLabel(bin_label);
        System.err.println(bin_label + " genomic:" + bl.is_genomic());
        GenomicLocation result = bl.is_genomic() ? bl.get_genomic_location() : this.gs.get_genomic_location_for_bin(bin_index);
        return result;
    }

    private void view_raw_data() {
        if (this.rbs.has_selection()) {
            Rectangle sel = this.rbs.get_selection();
            System.err.println("hey now:" + sel);
        } else {
            JOptionPane.showMessageDialog(this, "First select a region with the left mouse button.");
        }
    }

    public void set_display_sample_ids(boolean status) {
        this.display_sample_ids = status;
    }

    private double get_zoom_level() {
        double level = this.get_horizontal_scale_level();
        if (level < 1.0) {
            level = -1.0 / level;
        }
        return level;
    }

    private String get_zoom_level_string() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        return nf.format(this.get_zoom_level());
    }

    public void set_show_zoom(boolean show_zoom) {
        this.show_zoom_level = show_zoom;
        this.repaint();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof PopupListener) {
            MouseEvent me = (MouseEvent)arg;
            this.popup_bin_index = this.get_bin_index(me.getPoint());
            String[] headers = this.gm.get_headers();
            if (this.popup_bin_index < headers.length) {
                String marker = headers[this.popup_bin_index];
                if (this.jmi_sort != null) {
                    this.jmi_sort.setText(LABEL_SORT_PREFIX + marker);
                }
                if (this.jm_sort_subset != null) {
                    this.jm_sort_subset.setText(LABEL_SORT_PREFIX + marker + LABEL_SORT_SUFFIX);
                }
                this.pathway_popup_setup(marker);
            } else {
                System.err.println("header index error! " + this.popup_bin_index + " " + headers.length);
            }
        } else if (o instanceof ClusterTool) {
            ClusterTool ct = (ClusterTool)o;
            if (ct.wants_zoom()) {
                Rectangle r = this.gm.generate_selection(ct);
                this.center_on_region(r);
                this.zoom_to_selection();
            }
            this.repaint();
        } else {
            System.err.println("UNHANDLED UPDATE:" + o);
        }
    }

    private void pathway_popup_setup(String marker) {
        this.jm_pathways.setText(LABEL_PATHWAYS_FOR_MARKER_PREFIX + marker);
        this.jmi_eg.setText(LABEL_EG_PREFIX + marker);
        this.pathway_mi.clear();
        this.jm_pathways.removeAll();
        PathwayGenes pwg = new PathwayGenes();
        ArrayList<Pathway> pathways = pwg.find_pathways_for_gene(marker);
        if (pathways == null) {
            this.jm_pathways.add("(none annotated)");
        } else {
            ArrayList<String> pw_names = new ArrayList<String>();
            for (Pathway p : pathways) {
                pw_names.add(p.name);
            }
            Collections.sort(pw_names);
            for (String name : pw_names) {
                JMenuItem jmi = new JMenuItem(name);
                this.jm_pathways.add(jmi);
                jmi.addActionListener(this);
                this.pathway_mi.add(jmi);
            }
        }
    }

    public void addObserver(Observer o) {
        this.obs.addObserver(o);
    }

    private void paint_dividers(Graphics2D g2, DividerSet dividers) {
        if (dividers != null && dividers.size() > 0) {
            int start_x = this.get_unscaled_x_start();
            float y_step = this.get_vertical_scale_level();
            ArrayList<GenomicSample> samples = this.gm.get_visible_rows();
            Dimension d = this.getSize();
            g2.setColor(dividers.color);
            float range = dividers.max_weight - dividers.min_weight;
            float weight = y_step < dividers.full_weight_at_zoom ? dividers.min_weight + range * (y_step / dividers.full_weight_at_zoom) : dividers.max_weight;
            g2.setStroke(new BasicStroke(weight));
            float y = 0.0f;
            int yi = this.get_unscaled_y_start();
            for (y = 0.0f; y < (float)d.height && yi < samples.size(); ++yi, y += y_step) {
                if (!dividers.contains(yi) || (int)y <= 0) continue;
                g2.drawLine(0, (int)y, d.width, (int)y);
            }
        }
    }

    private void y_scale_check() {
        if (this.isVisible() && this.gm.is_loaded()) {
            int available = this.getSize().height;
            int sample_count = this.config.gm.get_row_count();
            float y_scale = (float)available / (float)sample_count;
            if (y_scale < 1.0f) {
                y_scale = 1.0f;
            }
            if (y_scale > Options.MAX_VERTICAL_SCALE_FACTOR) {
                y_scale = Options.MAX_VERTICAL_SCALE_FACTOR;
            }
            if (this.get_vertical_scale_level() != y_scale) {
                System.err.println("reset Y scale to " + y_scale);
                this.set_min_vertical_scale_level(y_scale);
                this.set_vertical_scale_level(y_scale);
                this.repaint();
            }
        }
    }
}

