/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import TCGA.AnnotationFlatfile2;
import TCGA.CheckBoxSet;
import TCGA.ControlFrame;
import TCGA.ControlFrameListener;
import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDisplayControl
extends Observable
implements ControlFrameListener {
    private ControlFrame jf = new ControlFrame(this);
    private CheckBoxSet cbs;

    public AnnotationDisplayControl(ArrayList<String> columns) {
        this.cbs = new CheckBoxSet(columns, true);
        JPanel sub_p = this.get_titled_panel("Choose clinical annotations to display:");
        sub_p.setLayout(new BoxLayout(sub_p, 3));
        for (String col : columns) {
            sub_p.add(this.cbs.get(col));
        }
        this.jf.setTitle("Clinical annotation display");
        this.jf.setLayout(new BorderLayout());
        this.jf.add("Center", new JScrollPane(this.buffer_panel(sub_p)));
        this.jf.add("South", this.jf.generate_panel(1));
        this.jf.pack();
        this.jf.setVisible(true);
    }

    public void setVisible(boolean v) {
        this.jf.setVisible(v);
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        try {
            AnnotationFlatfile2 af = new AnnotationFlatfile2("updated_clinical_data.tab", false);
        }
        catch (Exception e) {
            System.err.println("error:" + e);
        }
    }

    private JPanel get_titled_panel(String title) {
        JPanel jp_titled = new JPanel();
        jp_titled.setBorder(BorderFactory.createTitledBorder(title));
        return jp_titled;
    }

    private JPanel buffer_panel(JPanel jp) {
        JPanel jp_buffer = new JPanel();
        jp_buffer.setLayout(new BorderLayout());
        jp_buffer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jp_buffer.add("Center", jp);
        return jp_buffer;
    }

    @Override
    public void apply_changes() {
        ArrayList<String> selected = this.cbs.get_selected();
        this.setChanged();
        this.notifyObservers(selected);
    }
}

