/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Funk.Str;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCQuery {
    private String DB_SERVER = "my_server";
    private String DB_DATABASE = "my_database";
    private String DB_USER = "my_user";
    private String DB_PASSWORD = "my_password";
    public static String UCSC_DB_SERVER = "genome-mysql.cse.ucsc.edu";
    public static String UCSC_DB_DATABASE = "hg18";
    public static String UCSC_DB_USERNAME = "genome";
    public static String UCSC_DB_PASSWORD = "";
    public static String UCSC_SNP_TABLE = "snp129";
    private ArrayList<HashMap<String, String>> results;
    private Connection connection = null;

    public static JDBCQuery get_ucsc_genome_client() {
        JDBCQuery c = new JDBCQuery();
        c.set_db_server(UCSC_DB_SERVER);
        c.set_db_database(UCSC_DB_DATABASE);
        c.set_db_user(UCSC_DB_USERNAME);
        c.set_db_password(UCSC_DB_PASSWORD);
        return c;
    }

    public static JDBCQuery get_stjude_hg19() {
        JDBCQuery c = new JDBCQuery();
        c.set_db_server("sjmemgb01");
        c.set_db_database("hg19");
        c.set_db_user("pallasro");
        c.set_db_password("pallasR0");
        return c;
    }

    public void set_db_server(String s) {
        this.DB_SERVER = s;
    }

    public void set_db_database(String s) {
        this.DB_DATABASE = s;
    }

    public void set_db_user(String s) {
        this.DB_USER = s;
    }

    public void set_db_password(String s) {
        this.DB_PASSWORD = s;
    }

    private Connection get_connection() throws SQLException {
        if (this.connection == null) {
            String cs = "jdbc:mysql://" + this.DB_SERVER + "/" + this.DB_DATABASE + "?user=" + this.DB_USER;
            if (this.DB_PASSWORD != null && this.DB_PASSWORD.length() > 0) {
                cs = cs.concat("&password=" + this.DB_PASSWORD);
            }
            this.connection = DriverManager.getConnection(cs);
        }
        return this.connection;
    }

    public byte[] string2ba(String ins) {
        char[] input = ins.toCharArray();
        byte[] output = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = (byte)input[i];
        }
        return output;
    }

    public ArrayList<HashMap<String, String>> query_column(String table, String column, Collection<String> values, boolean is_numeric) throws Exception {
        ArrayList<String> mapped = new ArrayList<String>();
        if (is_numeric) {
            for (String v : values) {
                mapped.add(v);
            }
        } else {
            for (String v : values) {
                mapped.add('\"' + v + '\"');
            }
        }
        System.err.println("values size=" + values.size());
        String query = "select * from " + table + " where " + column + " in (" + Str.join(",", mapped) + ")";
        System.err.println("query=" + query);
        return this.query(query, false, 0);
    }

    public HashMap<String, String> query_single_row(String table, String column, String value) throws Exception {
        String query = "select * from " + table + " where " + column + "=\"" + value + "\"";
        return this.query_single_row(query);
    }

    public HashMap<String, String> query_single_row(String query) throws Exception {
        HashMap<String, String> result = null;
        ArrayList<HashMap<String, String>> results = this.query(query, true, 1);
        if (results != null && results.size() > 0) {
            result = results.get(0);
        }
        return result;
    }

    public ArrayList<HashMap<String, String>> query(String query) throws Exception {
        return this.query(query, false, 0);
    }

    public ArrayList<HashMap<String, String>> query(String query, boolean is_limited, int max_rows) throws Exception {
        this.results = new ArrayList();
        ArrayList<String> columns = null;
        Connection c = this.get_connection();
        Statement st = c.createStatement();
        if (st.execute(query)) {
            ResultSet rs = st.getResultSet();
            ResultSetMetaData meta = rs.getMetaData();
            int cc = meta.getColumnCount();
            columns = new ArrayList<String>();
            for (int i = 1; i <= cc; ++i) {
                columns.add(meta.getColumnName(i));
            }
            int row_count = 0;
            while (rs.next()) {
                HashMap row = new HashMap();
                ArrayList<String> raw = new ArrayList<String>();
                for (int i = 1; i <= cc; ++i) {
                    String value = new String(rs.getString(i));
                    raw.add(value);
                    row.put(columns.get(i - 1), value);
                }
                this.results.add(row);
                if (!is_limited || ++row_count < max_rows) continue;
                break;
            }
        } else {
            System.err.println("no results!");
        }
        return this.results;
    }

    public int get_result_count() {
        return this.results.size();
    }

    public ArrayList<HashMap<String, String>> get_results() {
        return this.results;
    }

    public static void main(String[] argv) {
        System.err.println("time: " + System.currentTimeMillis());
        JDBCQuery ucsc = JDBCQuery.get_stjude_hg19();
        System.err.println("time: " + System.currentTimeMillis());
        try {
            ArrayList<HashMap<String, String>> results = ucsc.query("select * from refGene where name2=\"tp53\"");
            System.err.println("time: " + System.currentTimeMillis());
            for (HashMap<String, String> row : results) {
                System.err.println(row.get("name2"));
            }
            System.err.println("count=" + ucsc.get_result_count());
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }
}

