/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.AceViewer;
import Ace2.AceViewerConfig;
import Ace2.ErrorReporter;
import Ace2.JDBCCache;
import Ace2.SAMAssembly;
import Ace2.SAMRegion;
import Ace2.SAMResource;
import Ace2.SAMUtils;
import Funk.Str;
import IsoView.AlphaCompositeFader;
import IsoView.BAMExcerpt;
import IsoView.ButtonLabelCallback;
import IsoView.ClipChecker;
import IsoView.DuplicateFeatureFilter;
import IsoView.ExonMatchType;
import IsoView.GraphicsTracker;
import IsoView.IsoViewConfig;
import IsoView.JComponentGroup;
import IsoView.MouseTooltipHelper;
import IsoView.MouseWheelZoomHelper;
import IsoView.RangeDigest;
import IsoView.SeparatorPainter;
import IsoView.StringBuilderHashMap;
import IsoView.TooltipUpdater;
import IsoView.Transcript;
import IsoView.TranscriptBAMEvidence;
import IsoView.TranscriptCoordinateDigestOptimizedScale;
import IsoView.TranscriptExon;
import IsoView.TranscriptFeature;
import IsoView.TranscriptFeatureType;
import IsoView.TranscriptIntron;
import IsoView.TranscriptLinkOut;
import TCGA.PopupListener;
import TCGA.ScalePanel2;
import TCGA.SimpleHTMLGrid;
import TCGA.URLLauncherDesktop;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import net.sf.samtools.SAMRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsoCanvas
extends ScalePanel2
implements TooltipUpdater,
Observer,
KeyListener {
    private IsoViewConfig config;
    private boolean SCALE_FACTOR_INITIALIZED = false;
    private GraphicsTracker gtrack = null;
    private PopupListener pul = null;
    private JComponentGroup jcg_isoform;
    private JComponentGroup jcg_reference;
    private JMenuItem jmi_popup_view_supporting;
    private JMenuItem jmi_popup_view_supporting_with_mates;
    private JMenuItem jmi_popup_view_refseq;
    private TranscriptFeature last_tf = null;
    private static final String LABEL_VIEW_ENTIRE_TRANSCRIPT = "View BAM data supporting entire transcript (strict)";
    private static final String LABEL_VIEW_ENTIRE_TRANSCRIPT_ANY_OVERLAP = "View raw BAM data for transcript (any overlap)";

    public IsoCanvas(IsoViewConfig config, JScrollBar jsb_x, JScrollBar jsb_y) {
        super(config.get_raw_canvas_size(), jsb_x, jsb_y);
        if (!config.ENABLE_VERTICAL_ZOOM) {
            this.set_min_vertical_scale_level(1.0f);
        }
        this.set_max_vertical_scale_level(1.0f);
        this.config = config;
        new MouseTooltipHelper(this, this);
        MouseWheelZoomHelper mwzh = new MouseWheelZoomHelper(this);
        mwzh.set_zoom_factor(config.ZOOM_FACTOR);
        this.addKeyListener(this);
        JPopupMenu jpm = new JPopupMenu();
        this.pul = new PopupListener(this, jpm);
        this.pul.addObserver(this);
        this.jcg_isoform = new JComponentGroup();
        this.jcg_reference = new JComponentGroup();
        this.jcg_isoform.set_toggle_group(this.jcg_reference);
        this.jcg_reference.set_toggle_group(this.jcg_isoform);
        this.jmi_popup_view_supporting = new JMenuItem("will be replaced by context sensitive text");
        this.jcg_isoform.add(jpm.add(this.jmi_popup_view_supporting));
        this.jmi_popup_view_supporting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IsoCanvas.this.context_action(false);
            }
        });
        this.jmi_popup_view_supporting_with_mates = new JMenuItem("will be replaced by context sensitive text");
        this.jcg_isoform.add(jpm.add(this.jmi_popup_view_supporting_with_mates));
        this.jmi_popup_view_supporting_with_mates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IsoCanvas.this.context_action(true);
            }
        });
        ButtonLabelCallback blc = new ButtonLabelCallback(this);
        JSeparator js = new JSeparator();
        this.jcg_isoform.add(js);
        jpm.add(js);
        this.jcg_isoform.add(blc.add(jpm.add(LABEL_VIEW_ENTIRE_TRANSCRIPT)));
        this.jcg_isoform.add(blc.add(jpm.add(LABEL_VIEW_ENTIRE_TRANSCRIPT_ANY_OVERLAP)));
        this.jmi_popup_view_refseq = new JMenuItem("replaced by context-sensitive");
        this.jcg_reference.add(jpm.add(this.jmi_popup_view_refseq));
        this.jmi_popup_view_refseq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TranscriptLinkOut tlo = new TranscriptLinkOut();
                if (tlo.identify(((IsoCanvas)IsoCanvas.this).last_tf.transcript.transcript_id)) {
                    try {
                        URLLauncherDesktop.launch_url(tlo.get_url());
                    }
                    catch (Exception ex) {
                        System.err.println("ERROR: " + ex);
                    }
                } else {
                    System.err.println("can't ID " + ((IsoCanvas)IsoCanvas.this).last_tf.transcript.transcript_id);
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Font count_font = new Font(this.config.JUNCTION_COUNT_FONT_NAME, 0, this.config.JUNCTION_COUNT_FONT_SIZE);
        FontMetrics fm_count = this.getFontMetrics(count_font);
        Graphics2D g = (Graphics2D)gr;
        if (this.config.ENABLE_ANTIALIASING) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int unscaled_x_start = this.get_unscaled_x_start();
        int unscaled_x_end = this.get_unscaled_x_end();
        int unscaled_y_start = this.get_unscaled_y_start();
        int unscaled_y_end = this.get_unscaled_y_end();
        ClipChecker clip = new ClipChecker(unscaled_x_start, unscaled_x_end);
        Dimension d = this.getSize();
        if (!this.SCALE_FACTOR_INITIALIZED) {
            this.zoom_out_max();
            if (this.config.ENABLE_VERTICAL_ZOOM) {
                this.zoom_out_max_y();
                float scale_out_max = this.get_vertical_scale_level();
                float y_max = this.get_max_vertical_scale_level();
                if (scale_out_max > y_max) {
                    scale_out_max = y_max;
                    this.set_vertical_scale_level(y_max);
                }
                this.set_min_vertical_scale_level(scale_out_max);
            }
            this.SCALE_FACTOR_INITIALIZED = true;
        }
        float x_scale_factor = this.get_horizontal_scale_level();
        float y_scale_factor = this.get_vertical_scale_level();
        DuplicateFeatureFilter dff = this.config.DRAW_FEATURES_UNIQUELY_PER_SAMPLE.booleanValue() ? new DuplicateFeatureFilter() : null;
        this.gtrack = new GraphicsTracker(g);
        this.gtrack.set_buffer_pixels(3);
        g.setColor(this.config.BACKGROUND_COLOR);
        g.fillRect(0, 0, d.width, d.height);
        int exon_ascent = (int)Math.ceil((float)this.config.EXON_ASCENT_SIZE * y_scale_factor);
        int exon_height = exon_ascent * 2 + 1;
        int arrow_ascent = (int)Math.ceil((float)this.config.ARROW_ASCENT_SIZE * y_scale_factor);
        double line_height = (float)this.config.CANVAS_TRANSCRIPT_Y_SIZE * y_scale_factor;
        int start_line_num = unscaled_y_start / this.config.CANVAS_TRANSCRIPT_Y_SIZE;
        double Y = -((double)start_line_num * line_height);
        double start_y = Y += (double)(exon_ascent * 2);
        int working_y = (int)Y;
        int tcount = this.config.working_transcripts.size();
        SeparatorPainter sp = new SeparatorPainter(this.config, g, line_height);
        for (Transcript t : this.config.working_transcripts) {
            int width;
            int x;
            sp.next(working_y, exon_ascent, d);
            if (t.is_reference) {
                g.setColor(this.config.COLOR_BACKGROUND_REFERENCE);
                g.fillRect(0, working_y - exon_ascent, d.width, exon_height);
            }
            boolean is_plus_strand = t.is_plus_strand();
            boolean anything_drawn = false;
            Color intron_color = this.config.INTRON_COLOR;
            AlphaCompositeFader acf = new AlphaCompositeFader(g);
            acf.set_minimum_trigger(0.1f);
            acf.set_maximum_trigger(0.5f);
            acf.set_minimum_value(0.2f);
            acf.set_maximum_value(1.0f);
            acf.set_composite(y_scale_factor);
            for (TranscriptIntron ti : t.introns) {
                if (ti.is_perfect_reference_match && this.config.HIDE_REFERENCE_MATCH_FEATURES.booleanValue() || this.config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY > 0 && ti.junction_coverage != -1 && ti.junction_coverage < this.config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY || dff != null && !t.is_reference && !dff.is_usable(ti)) continue;
                anything_drawn = true;
                g.setColor(this.config.INTRON_COLOR);
                x = (int)((float)(ti.screen_position.x - unscaled_x_start) * x_scale_factor);
                width = (int)((float)ti.screen_position.width * x_scale_factor);
                int x2 = x + width;
                this.gtrack.drawLine(ti, x, working_y, x2, working_y);
                int tx = x + (int)((double)width * (is_plus_strand ? 0.75 : 0.25));
                int[] arrow_x = new int[3];
                int[] arrow_y = new int[3];
                int arrow_width = arrow_ascent * 3;
                if (arrow_width > width) {
                    arrow_width = width;
                }
                if (is_plus_strand) {
                    arrow_x[0] = tx;
                    arrow_y[0] = working_y - arrow_ascent;
                    arrow_x[1] = tx + arrow_width;
                    arrow_y[1] = working_y;
                    arrow_x[2] = tx;
                    arrow_y[2] = working_y + arrow_ascent;
                } else {
                    arrow_x[0] = tx;
                    arrow_y[0] = working_y - arrow_ascent;
                    arrow_x[1] = tx - arrow_width;
                    arrow_y[1] = working_y;
                    arrow_x[2] = tx;
                    arrow_y[2] = working_y + arrow_ascent;
                }
                if (this.config.ENABLE_ANTIALIASING) {
                    arrow_y[2] = arrow_y[2] + 1;
                }
                g.fillPolygon(arrow_x, arrow_y, 3);
                if (!this.config.SHOW_JUNCTION_COUNTS || t.is_reference) continue;
                int center = x + width / 2;
                String label = Integer.toString(ti.junction_coverage);
                int lw = fm_count.stringWidth(label);
                int lx = center - lw / 2;
                int ly = working_y - 1;
                g.setFont(count_font);
                if (this.config.JUNCTION_COUNT_COLOR_KNOWN != null && this.config.JUNCTION_COUNT_COLOR_NOVEL != null) {
                    g.setColor(ti.is_perfect_reference_match ? this.config.JUNCTION_COUNT_COLOR_KNOWN : this.config.JUNCTION_COUNT_COLOR_NOVEL);
                } else {
                    g.setColor(this.config.JUNCTION_COUNT_COLOR);
                }
                g.drawString(label, lx, ly);
            }
            acf.reset();
            int ecount = t.exons.size();
            ArrayList<TranscriptExon> spans = new ArrayList<TranscriptExon>();
            for (int i = 0; i < ecount; ++i) {
                TranscriptExon te = t.exons.get(i);
                if (dff != null && !t.is_reference && !dff.is_usable(te)) continue;
                if (te.is_putative_span) {
                    spans.add(te);
                    continue;
                }
                if (te.is_perfect_reference_match && this.config.HIDE_REFERENCE_MATCH_FEATURES.booleanValue()) continue;
                if (clip.check_length(te.screen_position.x, te.screen_position.width)) {
                    // empty if block
                }
                anything_drawn = true;
                x = (int)((float)(te.screen_position.x - unscaled_x_start) * x_scale_factor);
                width = (int)((float)te.screen_position.width * x_scale_factor);
                if (width < 1) {
                    width = 1;
                }
                if (t.is_reference) {
                    g.setColor(this.config.EXON_COLOR_REFERENCE);
                } else if (te.reference_match_type != null) {
                    if (te.reference_match_type == ExonMatchType.PERFECT) {
                        g.setColor(this.config.EXON_COLOR_REFERENCE_PERFECT_MATCH);
                    } else if (te.reference_match_type == ExonMatchType.SAME_START_OR_END) {
                        g.setColor(this.config.EXON_COLOR_REFERENCE_SAME_START_OR_END);
                    } else if (te.reference_match_type == ExonMatchType.PARTIAL) {
                        g.setColor(this.config.EXON_COLOR_REFERENCE_PARTIAL_MATCH);
                    } else if (te.reference_match_type == ExonMatchType.NO_MATCH) {
                        g.setColor(this.config.EXON_COLOR_REFERENCE_NO_MATCH);
                    } else {
                        System.err.println("ERROR: unhandled match type " + (Object)((Object)te.reference_match_type));
                        g.setColor(this.config.EXON_COLOR);
                    }
                } else {
                    g.setColor(this.config.EXON_COLOR);
                }
                te.drawn_right_y = x + width - 1;
                this.gtrack.fillRect(te, x, working_y - exon_ascent, width, exon_height);
            }
            g.setColor(this.config.EXON_COLOR_MULTI_EXON_SPAN);
            for (TranscriptExon te : spans) {
                int ascent2;
                if (this.config.HIDE_EXON_SPANS.booleanValue()) continue;
                anything_drawn = true;
                x = (int)((float)(te.screen_position.x - unscaled_x_start) * x_scale_factor);
                width = (int)((float)te.screen_position.width * x_scale_factor);
                if (width < 1) {
                    width = 1;
                }
                if ((ascent2 = (int)((double)exon_ascent * 0.66)) == 0) {
                    ascent2 = 1;
                }
                int height2 = ascent2 * 2 + 1;
                this.gtrack.fillRect(te, x, working_y - ascent2, te.putative_span_end.drawn_right_y - x + 1, height2);
            }
            if (!anything_drawn) continue;
            working_y = (int)(Y += line_height);
        }
        if (IsoViewConfig.DEBUG_PRUNE && this.config.scale_digest instanceof TranscriptCoordinateDigestOptimizedScale) {
            TranscriptCoordinateDigestOptimizedScale scale = (TranscriptCoordinateDigestOptimizedScale)this.config.scale_digest;
            g.setColor(Color.blue);
            for (RangeDigest rd : scale.filterable) {
                int min = rd.get_minimum();
                int max = rd.get_maximum();
                g.fillRect((int)((float)min * x_scale_factor), 0, (int)((float)(max - min + 1) * x_scale_factor), d.height);
            }
        }
    }

    private TranscriptFeature find_intersecting_feature(MouseEvent me) {
        TranscriptFeature result = null;
        ArrayList<Object> hits = this.gtrack.find_intersecting_list(me);
        if (hits.size() > 0) {
            TranscriptFeature preferred = null;
            for (Object o : hits) {
                if (!(o instanceof TranscriptExon)) continue;
                preferred = (TranscriptFeature)o;
                break;
            }
            result = preferred != null ? preferred : (TranscriptFeature)hits.get(0);
        }
        return result;
    }

    @Override
    public String get_tooltip_text(MouseEvent me) {
        String result = null;
        TranscriptFeature tf = this.find_intersecting_feature(me);
        if (tf != null) {
            SimpleHTMLGrid shg = new SimpleHTMLGrid();
            shg.set_show_column_labels(false);
            shg.set_row_label_align("right");
            if (!tf.transcript.is_reference) {
                shg.set_cell_value("value", "sample", tf.transcript.sample_name);
            }
            if (tf.gene_name != null && tf.gene_name.length() > 0) {
                shg.set_cell_value("value", "gene", tf.gene_name);
            }
            shg.set_cell_value("value", "transcript", tf.transcript.transcript_id);
            shg.set_cell_value("value", "start", tf.start);
            shg.set_cell_value("value", "end", tf.end);
            String fstring = tf.type.toString().toLowerCase() + " " + tf.feature_number;
            if (!tf.transcript.is_reference) {
                StringBuilderHashMap<String> transcript2desc = new StringBuilderHashMap<String>();
                for (Transcript rt : this.config.reference_transcripts) {
                    ArrayList<TranscriptFeature> search = tf.type.equals((Object)TranscriptFeatureType.EXON) ? new ArrayList<TranscriptExon>(rt.exons) : new ArrayList<TranscriptIntron>(rt.introns);
                    for (TranscriptFeature rtf : search) {
                        String desc = null;
                        if (rtf.start == tf.start && rtf.end == tf.end) {
                            desc = rtf.type.toString().toLowerCase() + " " + rtf.feature_number;
                        } else if (rtf.start == tf.start) {
                            desc = rtf.type.toString().toLowerCase() + " " + rtf.feature_number + " (start)";
                        } else if (rtf.end == tf.end) {
                            desc = rtf.type.toString().toLowerCase() + " " + rtf.feature_number + " (end)";
                        }
                        if (desc == null) continue;
                        if (transcript2desc.containsKey(rt.transcript_id)) {
                            transcript2desc.append(rt.transcript_id, "-");
                        }
                        transcript2desc.append(rt.transcript_id, desc);
                    }
                }
                if (this.config.TOOLTIP_GROUP_REFSEQ_EVENTS_BY_EVENT.booleanValue()) {
                    HashSet<String> all_descs = new HashSet<String>(transcript2desc.values());
                    ArrayList<String> all_list = new ArrayList<String>(all_descs);
                    Collections.sort(all_list);
                    for (String desc : all_list) {
                        ArrayList<String> matches = new ArrayList<String>();
                        for (String tid : transcript2desc.keySet()) {
                            String tdesc = transcript2desc.toString(tid);
                            if (!tdesc.equals(desc)) continue;
                            matches.add(tid);
                        }
                        fstring = fstring.concat("<br>" + desc + ": " + Str.join(",", matches));
                    }
                } else {
                    for (Transcript rt : this.config.reference_transcripts) {
                        String desc = transcript2desc.toString(rt.transcript_id);
                        if (desc == null) continue;
                        fstring = fstring.concat("<br>" + rt.transcript_id + " " + desc);
                    }
                }
            }
            shg.set_cell_value("value", "feature", fstring);
            shg.set_cell_value("value", "length", tf.end - tf.start + 1);
            if (tf instanceof TranscriptIntron) {
                TranscriptIntron ti = (TranscriptIntron)tf;
                if (ti.junction_coverage != -1) {
                    shg.set_cell_value("value", "junction coverage", ti.junction_coverage);
                }
            }
            result = "<html>" + shg.generate_html() + "</html>";
        }
        return result;
    }

    public void reset_zoom() {
        this.SCALE_FACTOR_INITIALIZED = false;
        this.repaint();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof PopupListener) {
            String label;
            TranscriptFeature tf;
            MouseEvent me = (MouseEvent)arg;
            this.last_tf = tf = this.find_intersecting_feature(me);
            String label2 = label = "(mouse isn't pointing at anything)";
            if (tf != null) {
                label = "View reads supporting " + tf.type.toString().toLowerCase() + " " + tf.feature_number + " only";
                label2 = label + " (plus mate reads)";
            }
            if (tf.transcript.is_reference) {
                this.jcg_reference.setVisible(true);
                TranscriptLinkOut tlo = new TranscriptLinkOut();
                String text = "???";
                if (tlo.identify(tf.transcript.transcript_id)) {
                    text = "view " + tf.transcript.transcript_id + " at " + tlo.get_label();
                } else {
                    System.err.println("can't identify " + tf.transcript.transcript_id);
                }
                this.jmi_popup_view_refseq.setText(text);
            } else {
                this.jcg_isoform.setVisible(true);
            }
            this.jmi_popup_view_supporting.setText(label);
            this.jmi_popup_view_supporting_with_mates.setText(label2);
        } else if (o instanceof ButtonLabelCallback) {
            String label = (String)arg;
            if (label.equals(LABEL_VIEW_ENTIRE_TRANSCRIPT) || label.equals(LABEL_VIEW_ENTIRE_TRANSCRIPT_ANY_OVERLAP)) {
                TranscriptFeature tf = this.find_intersecting_feature(this.pul.getMouseEvent());
                if (tf != null) {
                    if (tf.transcript.is_reference) {
                        this.reference_isoform_bam_error(tf.transcript);
                    } else {
                        boolean contained_only = label.equals(LABEL_VIEW_ENTIRE_TRANSCRIPT);
                        this.view_transcript_evidence(tf.transcript, contained_only);
                    }
                }
            } else {
                System.err.println("FIX ME: unhandled label" + label);
            }
        } else {
            System.err.println("what is " + o);
        }
    }

    private void view_results(ArrayList<SAMRecord> results, Transcript t, RangeDigest rd_view) {
        String fn;
        String bam = this.config.get_bam_filename(t.sample_name);
        if (results == null || results.size() == 0) {
            String msg = "<html>Could not find any supporting read data in BAM file.<P>You might want to try unchecking the \"Require read mates to also be mapped within transcript\" checkbox in the View menu.</html>";
            JOptionPane.showMessageDialog(this, msg, "No supporting reads found", 0);
            return;
        }
        if (this.config.EXTRACT_EXCERPT_BAM_MODE.booleanValue() && (fn = JOptionPane.showInputDialog("Enter filename to write .bam data to:", (Object)"")) != null && fn.length() > 0) {
            BAMExcerpt be = new BAMExcerpt(new File(fn), true);
            be.set_source_file(bam);
            for (SAMRecord sr : results) {
                be.add(sr);
            }
            be.close();
            SAMUtils.bam_index(new File(fn));
        }
        System.err.println("got:" + results.size());
        AceViewerConfig avc = new AceViewerConfig();
        avc.COMPRESS_INTRONS = this.config.BAMVIEW_COMPRESS_INTRONS.booleanValue();
        avc.EXIT_ON_CLOSE = false;
        File f = new File(bam);
        if (f.exists()) {
            System.err.println("ok!");
            avc.LOCAL_FILE_MODE = true;
            SAMResource sr = new SAMResource();
            sr.set_load_duplicates(false);
            avc.sams.add(sr);
            avc.region = new SAMRegion();
            avc.region.tname = t.exons.get((int)0).reference;
            int buffer = 100;
            avc.region.range.start = rd_view.get_minimum() - buffer;
            avc.region.range.end = rd_view.get_maximum() + buffer;
            System.err.println("view range=" + avc.region.range);
            JDBCCache.UCSC_DB_SERVER = "sjmemgb01";
            JDBCCache.UCSC_DB_DATABASE = "hg19";
            JDBCCache.UCSC_DB_USERNAME = "pallasro";
            JDBCCache.UCSC_DB_PASSWORD = "pallasR0";
            try {
                avc.reference_sequence = this.config.two_bit;
                if (avc.reference_sequence == null && avc.target_sequence == null) {
                    System.err.println("Note: no reference sequence specified, generating consensus sequence.");
                    avc.GENERATE_CONSENSUS = true;
                }
                SAMUtils.sam_config_setup(avc, avc.region);
                sr.set_sams(results);
                avc.assembly = new SAMAssembly(avc, true);
                new AceViewer(avc);
            }
            catch (Exception e) {
                System.err.println("ERROR launching viewer: " + e);
                new ErrorReporter(e);
            }
        }
    }

    private void view_transcript_evidence(Transcript t, boolean contained_only) {
        TranscriptBAMEvidence tbe = new TranscriptBAMEvidence(this.config);
        String bam = this.config.get_bam_filename(t.sample_name);
        tbe.set_input_bam(bam);
        tbe.set_contained_only(contained_only);
        tbe.import_evidence(t);
        this.view_results(tbe.get_matches(), t, t.get_range_digest());
    }

    public void context_action(boolean include_mate_reads) {
        RangeDigest rd_view;
        MouseEvent me = this.pul.getMouseEvent();
        TranscriptFeature tf = this.find_intersecting_feature(me);
        System.err.println("context: " + tf);
        if (tf.transcript.is_reference) {
            this.reference_isoform_bam_error(tf.transcript);
            return;
        }
        TranscriptBAMEvidence tbe = new TranscriptBAMEvidence(this.config);
        String bam = this.config.get_bam_filename(tf.transcript.sample_name);
        tbe.set_input_bam(bam);
        System.err.println("context action");
        tbe.set_contained_only(this.config.EXON_INTRON_VIEW_REQUIRE_READ_CONTAINMENT.booleanValue());
        tbe.import_evidence(tf.transcript);
        ArrayList<SAMRecord> matches_raw = tbe.get_matches();
        System.err.print("raw result count=" + matches_raw.size() + " ");
        for (SAMRecord sr : matches_raw) {
            System.err.println("raw=" + sr.getReadName());
        }
        ArrayList<SAMRecord> matches_filtered = null;
        if (tf instanceof TranscriptExon) {
            matches_filtered = tbe.postprocess_query_exon(matches_raw, (TranscriptExon)tf, include_mate_reads);
        } else if (tf instanceof TranscriptIntron) {
            matches_filtered = tbe.postprocess_query_intron(matches_raw, (TranscriptIntron)tf, include_mate_reads);
        } else {
            System.err.println("ERROR: unknown feature");
        }
        System.err.println("filtered=" + matches_filtered.size());
        if (include_mate_reads) {
            rd_view = new RangeDigest();
            rd_view.add_start(matches_filtered.get(0).getAlignmentStart());
            rd_view.add_end(matches_filtered.get(matches_filtered.size() - 1).getAlignmentEnd());
        } else {
            rd_view = tf.get_range_digest();
        }
        this.view_results(matches_filtered, tf.transcript, rd_view);
    }

    private void reference_isoform_bam_error(Transcript t) {
        JOptionPane.showMessageDialog(this, "This is a reference isoform (" + t.transcript_id + ") and has no BAM data.", "Reference isoform", 0);
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        char c = ke.getKeyChar();
        if (c == '+') {
            this.zoom_in();
        } else if (c == '-') {
            this.zoom_out();
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }
}

