/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Ace2.Chromosome;
import Funk.DelimitedFile;
import Funk.Str;
import Funk.WarningTracker;
import IsoView.IsoViewConfig;
import IsoView.RegionParser;
import IsoView.Transcript;
import IsoView.TranscriptExon;
import IsoView.TranscriptIntron;
import IsoView.TranscriptLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class FlatfileJunctionTranscriptLoader
extends TranscriptLoader {
    IsoViewConfig config;

    public FlatfileJunctionTranscriptLoader(IsoViewConfig config) {
        this.config = config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String fn) {
        boolean VERBOSE = false;
        try {
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            boolean load_counts = false;
            if (this.config.junction_count_files.size() > 0) {
                for (String jcf : this.config.junction_count_files) {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(jcf)));
                    load_counts = true;
                    while ((line = br.readLine()) != null) {
                        int count;
                        String key;
                        String[] f = line.split("\t");
                        if (f.length == 2) {
                            RegionParser rp = new RegionParser();
                            if (!rp.parse_junction(f[0])) throw new IOException("junction parse fail " + f[0]);
                            key = this.get_count_key(rp);
                            count = Integer.parseInt(f[1]);
                        } else {
                            if (f.length != 4) throw new IOException("line must be either 2 (TCGA) or 4 (Circos) tab-delimited fields");
                            key = this.get_count_key(f[0], Integer.parseInt(f[1]), Integer.parseInt(f[2]));
                            count = Integer.parseInt(f[3]);
                        }
                        counts.put(key, count);
                    }
                }
            }
            HashMap<String, TreeSet<RegionParser>> gene2junction = new HashMap<String, TreeSet<RegionParser>>();
            File f = new File(fn);
            DelimitedFile df = new DelimitedFile();
            df.parse(f);
            Vector rows = df.get_rows();
            Hashtable first = (Hashtable)rows.get(0);
            if (!first.containsKey(this.config.F_GENE)) {
                throw new IOException("can't find gene field " + this.config.F_GENE);
            }
            if (!first.containsKey(this.config.F_JUNCTION)) {
                throw new IOException("can't find junction field " + this.config.F_JUNCTION);
            }
            if (this.config.F_COUNT != null && !first.containsKey(this.config.F_COUNT)) {
                throw new IOException("can't find junction count field " + this.config.F_COUNT);
            }
            if (this.config.F_TYPE != null && !first.containsKey(this.config.F_TYPE)) {
                throw new IOException("can't find junction type field " + this.config.F_TYPE);
            }
            WarningTracker wt = new WarningTracker();
            ArrayList<Transcript> these_transcripts = new ArrayList<Transcript>();
            for (Object r : rows) {
                Hashtable row = (Hashtable)r;
                String junction = Str.unquote((String)row.get(this.config.F_JUNCTION));
                String raw_gene = (String)row.get(this.config.F_GENE);
                if (raw_gene == null || raw_gene.length() == 0) {
                    System.err.println("WTF: null gene for " + junction);
                    continue;
                }
                String[] genes_raw = raw_gene.split(",");
                HashSet<String> all_genes = new HashSet<String>();
                for (int i = 0; i < genes_raw.length; ++i) {
                    all_genes.add(genes_raw[i]);
                }
                RegionParser rp = new RegionParser();
                if (!rp.parse_junction(junction)) throw new IOException("malformed or unsupported junction: " + junction);
                boolean usable = true;
                String jtype = null;
                if (this.config.F_TYPE != null) {
                    jtype = (String)row.get(this.config.F_TYPE);
                    if (!jtype.equals("known") && !jtype.equals("novel")) {
                        throw new IOException("unknown junction type " + jtype);
                    }
                    if (jtype.equals("known")) {
                        rp.known = true;
                    }
                }
                if ((this.config.LOAD_NOVEL_JUNCTIONS_ONLY || this.config.LOAD_KNOWN_REFGENE_ONLY) && jtype == null) {
                    throw new IOException("-f-type required in this mode");
                }
                if (this.config.F_COUNT != null) {
                    load_counts = true;
                    int count = Integer.parseInt((String)row.get(this.config.F_COUNT));
                    if (this.config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY > 0 && count < this.config.MIN_JUNCTION_COVERAGE_FOR_DISPLAY) {
                        usable = false;
                    } else if (this.config.MIN_NOVEL_JUNCTION_COVERAGE_FOR_DISPLAY > 0 && !rp.known && count < this.config.MIN_NOVEL_JUNCTION_COVERAGE_FOR_DISPLAY) {
                        usable = false;
                    } else {
                        counts.put(this.get_count_key(rp), count);
                    }
                }
                if (this.config.LOAD_KNOWN_REFGENE_ONLY && jtype.equals("known")) {
                    if (this.config.F_TRANSCRIPT == null) {
                        throw new IOException("-f-transcript required");
                    }
                    boolean pass = false;
                    String tlist = (String)row.get(this.config.F_TRANSCRIPT);
                    if (tlist != null) {
                        String[] ts = tlist.split(",");
                        for (int i = 0; i < ts.length; ++i) {
                            if (ts[i].indexOf("NM_") != 0 && ts[i].indexOf("NR_") != 0) continue;
                            pass = true;
                        }
                    }
                    if (!pass) {
                        usable = false;
                    }
                }
                if (load_counts) {
                    Integer count = (Integer)counts.get(this.get_count_key(rp));
                    if (this.config.PRUNE_NULL_COUNT_JUNCTIONS && count == null) {
                        usable = false;
                    }
                }
                if (this.config.LOAD_NOVEL_JUNCTIONS_ONLY && jtype.equals("known")) {
                    usable = false;
                }
                if (!usable) continue;
                for (String gene : all_genes) {
                    TreeSet<RegionParser> bucket = (TreeSet<RegionParser>)gene2junction.get(gene);
                    if (bucket == null) {
                        bucket = new TreeSet<RegionParser>();
                        gene2junction.put(gene, bucket);
                    }
                    bucket.add(rp);
                }
            }
            wt.report();
            for (String gene : gene2junction.keySet()) {
                ArrayList<ArrayList> buckets = new ArrayList<ArrayList>();
                HashSet<RegionParser> processed = new HashSet<RegionParser>();
                ArrayList<Boolean> passes = new ArrayList<Boolean>();
                if (this.config.F_TYPE != null) {
                    passes.add(true);
                }
                passes.add(false);
                Iterator i$ = passes.iterator();
                while (i$.hasNext()) {
                    boolean known_only = (Boolean)i$.next();
                    for (RegionParser rp : (TreeSet)gene2junction.get(gene)) {
                        if (known_only && !rp.known || processed.contains(rp)) continue;
                        processed.add(rp);
                        ArrayList bucket_to_use = null;
                        for (ArrayList bucket : buckets) {
                            boolean usable = true;
                            for (RegionParser rpi : bucket) {
                                if (!rpi.overlaps(rp)) continue;
                                if (VERBOSE) {
                                    System.err.println("fail " + rp + " " + rpi);
                                }
                                usable = false;
                                break;
                            }
                            if (!usable) continue;
                            bucket_to_use = bucket;
                            break;
                        }
                        if (bucket_to_use == null) {
                            bucket_to_use = new ArrayList();
                            buckets.add(bucket_to_use);
                        }
                        bucket_to_use.add(rp);
                    }
                }
                if (VERBOSE) {
                    System.err.println("buckets:" + buckets.size());
                    for (ArrayList bucket : buckets) {
                        System.err.println("bucket:");
                        for (RegionParser rp : bucket) {
                            System.err.println("  " + rp);
                        }
                    }
                }
                int transcript_counter = 0;
                for (ArrayList bucket : buckets) {
                    if (VERBOSE) {
                        System.err.println("new bucket");
                    }
                    ArrayList<RegionParser> exon_positions = new ArrayList<RegionParser>();
                    RegionParser rp_exon = null;
                    String reference = null;
                    for (RegionParser rp : bucket) {
                        if (exon_positions.size() == 0) {
                            reference = Chromosome.standardize_name(rp.reference);
                            rp_exon = new RegionParser();
                            rp_exon.reference = reference;
                            rp_exon.start = rp.start - this.config.FLANKING_NT_TO_GENERATE;
                            exon_positions.add(rp_exon);
                        }
                        rp_exon.end = rp.start;
                        rp_exon = new RegionParser();
                        rp_exon.reference = reference;
                        rp_exon.start = rp.end;
                        exon_positions.add(rp_exon);
                    }
                    rp_exon.end = rp_exon.start + this.config.FLANKING_NT_TO_GENERATE;
                    if (VERBOSE) {
                        System.err.println("converted:");
                        for (RegionParser rp : exon_positions) {
                            System.err.println("  " + rp);
                            if (rp.start <= rp.end) continue;
                            System.err.println("WTF, exon start before end!");
                            System.exit(1);
                        }
                    }
                    Transcript t = new Transcript();
                    String tid = gene + "." + ++transcript_counter;
                    t.sample_name = fn;
                    t.transcript_id = new String(tid);
                    if (VERBOSE) {
                        System.err.println("new transcript: " + tid);
                    }
                    t.strand = "+";
                    this.id2transcript.put(tid, t);
                    this.all_transcripts.add(t);
                    these_transcripts.add(t);
                    for (RegionParser rp : exon_positions) {
                        TranscriptExon te = new TranscriptExon();
                        te.transcript = t;
                        te.reference = reference;
                        te.gene_name = gene;
                        te.feature_number = t.get_exon_count() + 1;
                        te.start = rp.start;
                        te.end = rp.end;
                        t.exons.add(te);
                    }
                }
            }
            for (Transcript t : these_transcripts) {
                t.setup();
            }
            if (!load_counts) return;
            for (Transcript t : these_transcripts) {
                for (TranscriptIntron ti : t.introns) {
                    Integer count;
                    if (ti.reference == null || (count = (Integer)counts.get(this.get_count_key(ti.reference, ti.start - 1, ti.end + 1))) == null) continue;
                    ti.junction_coverage = count;
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    private String get_count_key(RegionParser rp) {
        return this.get_count_key(rp.reference, rp.start, rp.end);
    }

    private String get_count_key(String ref, int start, int end) {
        return Chromosome.standardize_name(ref) + "." + start + "." + end;
    }
}

