/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.IndelInfo;
import Ace2.SNPConfig;
import Ace2.SNPTrackInfo;
import Funk.Str;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMTagTracker {
    private SNPConfig config;
    private static int MAX_STRING_LENGTH_TO_TRACK = 3;
    private ArrayList<String> results;

    public SAMTagTracker(ArrayList list) {
        int read_count = 0;
        SAMRecord sr = null;
        HashSet<String> ignore_tags = new HashSet<String>();
        ignore_tags.add("BQ");
        ignore_tags.add("CQ");
        ignore_tags.add("CS");
        ignore_tags.add("E2");
        ignore_tags.add("MD");
        ignore_tags.add("OQ");
        ignore_tags.add("OC");
        ignore_tags.add("PG");
        ignore_tags.add("Q2");
        ignore_tags.add("R2");
        ignore_tags.add("RG");
        ignore_tags.add("U2");
        HashMap track_string = new HashMap();
        HashMap<String, ArrayList<Integer>> track_int = new HashMap<String, ArrayList<Integer>>();
        for (Object o : list) {
            if (o instanceof SNPTrackInfo) {
                sr = ((SNPTrackInfo)o).sr;
            } else if (o instanceof IndelInfo) {
                sr = ((IndelInfo)o).sr;
            } else {
                System.err.println("ERROR: unhandled object " + o);
                System.exit(1);
            }
            ++read_count;
            for (SAMRecord.SAMTagAndValue tav : sr.getAttributes()) {
                if (ignore_tags.contains(tav.tag)) continue;
                if (tav.value instanceof String || tav.value instanceof Character) {
                    String v;
                    String string = v = tav.value instanceof String ? (String)tav.value : ((Character)tav.value).toString();
                    if (v.length() <= MAX_STRING_LENGTH_TO_TRACK) {
                        Integer count;
                        HashMap<String, Integer> count_bucket = (HashMap<String, Integer>)track_string.get(tav.tag);
                        if (count_bucket == null) {
                            count_bucket = new HashMap<String, Integer>();
                            track_string.put(tav.tag, count_bucket);
                        }
                        if ((count = (Integer)count_bucket.get(v)) == null) {
                            count = 0;
                        }
                        count_bucket.put(v, count + 1);
                        continue;
                    }
                    System.err.println("not tracking tag " + tav.tag);
                    continue;
                }
                if (tav.value instanceof Integer) {
                    list = (ArrayList)track_int.get(tav.tag);
                    if (list == null) {
                        list = new ArrayList();
                        track_int.put(tav.tag, list);
                    }
                    list.add((Integer)tav.value);
                    continue;
                }
                System.err.println("tag=" + tav.tag + " value=" + tav.value + " type=" + tav.value.getClass());
                System.err.println("unhandled SAM tag tracking type: " + tav.value.getClass() + " tag=" + tav.tag);
            }
        }
        this.results = new ArrayList();
        for (String tag : track_int.keySet()) {
            boolean first = true;
            ArrayList values = (ArrayList)track_int.get(tag);
            int min = 0;
            int max = 0;
            long total = 0L;
            Collections.sort(values);
            for (Integer value : values) {
                total += (long)value.intValue();
                if (first) {
                    min = max = value.intValue();
                    first = false;
                    continue;
                }
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            int avg = (int)(total / (long)values.size());
            int median = (Integer)values.get((values.size() - 1) / 2);
            String result = tag + ":i:" + min + "," + median + "," + avg + "," + max;
            this.results.add(result);
        }
        for (String tag : track_string.keySet()) {
            HashMap value_counts = (HashMap)track_string.get(tag);
            ArrayList<String> vs = new ArrayList<String>();
            for (String value : value_counts.keySet()) {
                int count = (Integer)value_counts.get(value);
                float freq = (float)count / (float)read_count;
                vs.add(value);
                vs.add(Float.toString(freq));
            }
            String result = tag + ":A:" + Str.join(",", vs);
            this.results.add(result);
        }
    }

    public ArrayList<String> get_results() {
        return this.results;
    }
}

