/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.FASTADirectory;
import Ace2.FASTAIndexedFAI;
import Ace2.ReferenceSequence;
import Ace2.TwoBitFile;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class SAMMismatchFrequency {
    ReferenceSequence reference;
    SamReader reader;
    HashMap<String, Integer> ref_lengths;
    long count_bases_compared;
    long count_bases_mismatch;
    long count_ref_skipped;
    long count_bases_indel;
    long count_bases_with_boundary_issues;
    int MIN_QUALITY = 15;
    int MIN_MAPQ = 1;
    boolean COUNT_INDELS_AS_MISMATCHES = true;

    public void set_reference(ReferenceSequence reference) {
        this.reference = reference;
    }

    private void reset() {
        this.count_bases_compared = 0L;
        this.count_bases_mismatch = 0L;
        this.count_ref_skipped = 0L;
        this.count_bases_indel = 0L;
        this.count_bases_with_boundary_issues = 0L;
    }

    public void set_count_indels_as_mismatches(boolean v) {
        this.COUNT_INDELS_AS_MISMATCHES = v;
    }

    public void set_minimum_quality(int q) {
        this.MIN_QUALITY = q;
    }

    public void set_minimum_mapq(int q) {
        this.MIN_MAPQ = q;
    }

    public void process_bam(File bam) throws IOException {
        System.err.println("minimum mapping quality: " + this.MIN_MAPQ);
        System.err.println("minimum base quality: " + this.MIN_QUALITY);
        System.err.println("count indels as mismatches: " + this.COUNT_INDELS_AS_MISMATCHES);
        this.reset();
        this.reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(bam);
        ArrayList<String> refs_to_process = new ArrayList<String>();
        SAMFileHeader h = this.reader.getFileHeader();
        SAMSequenceDictionary dict = h.getSequenceDictionary();
        this.ref_lengths = new HashMap();
        for (SAMSequenceRecord ssr : dict.getSequences()) {
            String name = ssr.getSequenceName();
            this.ref_lengths.put(name, ssr.getSequenceLength());
            refs_to_process.add(name);
        }
        for (String reference : refs_to_process) {
            this.get_some(reference);
        }
        this.report();
    }

    public void report() {
        System.err.println("bases compared: " + this.count_bases_compared);
        System.err.println("bases mismatch: " + this.count_bases_mismatch);
        System.err.println("bases indel: " + this.count_bases_indel);
        System.err.println("bases mapped outside reference (ignored): " + this.count_bases_with_boundary_issues);
        System.err.println("reference bases skipped: " + this.count_ref_skipped);
        double mismatch_frequency = (double)this.count_bases_mismatch / (double)this.count_bases_compared;
        System.out.println(mismatch_frequency);
    }

    private void get_some(String rname) throws IOException {
        SAMRecordIterator query = this.reader.queryOverlapping(rname, 1, this.ref_lengths.get(rname).intValue());
        byte[] reference_sequence = null;
        boolean qual_mapping_problem = false;
        while (query.hasNext()) {
            SAMRecord sr = (SAMRecord)query.next();
            if (sr.getMappingQuality() < this.MIN_MAPQ) continue;
            if (reference_sequence == null) {
                System.err.print("load reference for " + rname + "...");
                reference_sequence = this.reference.get_all(rname);
                System.err.println("done");
            }
            byte[] quals = sr.getBaseQualities();
            byte[] read = sr.getReadBases();
            for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                int len = ab.getLength();
                int read_i = ab.getReadStart() - 1;
                int ref_i = ab.getReferenceStart() - 1;
                if (read_i < 0) {
                    System.err.println("ERROR: can't include " + sr.getReadName() + ", read_i < 0");
                    continue;
                }
                if (ref_i < 0) {
                    System.err.println("ERROR: can't include " + sr.getReadName() + ", ref_i < 0");
                    continue;
                }
                int end = read_i + len;
                while (read_i < end) {
                    if (ref_i < 0 || ref_i >= reference_sequence.length) {
                        ++this.count_bases_with_boundary_issues;
                    } else if (read_i >= quals.length) {
                        qual_mapping_problem = true;
                    } else if (quals[read_i] >= this.MIN_QUALITY) {
                        char c_read = Character.toUpperCase((char)read[read_i]);
                        char c_ref = Character.toUpperCase((char)reference_sequence[ref_i]);
                        if (c_ref == 'A' || c_ref == 'C' || c_ref == 'G' || c_ref == 'T') {
                            ++this.count_bases_compared;
                            if (c_read != c_ref) {
                                ++this.count_bases_mismatch;
                            }
                        } else {
                            ++this.count_ref_skipped;
                        }
                    }
                    ++read_i;
                    ++ref_i;
                }
            }
            for (CigarElement ce : sr.getCigar().getCigarElements()) {
                CigarOperator co = ce.getOperator();
                if (!co.equals((Object)CigarOperator.INSERTION) && !co.equals((Object)CigarOperator.DELETION)) continue;
                int indel_length = ce.getLength();
                if (!this.COUNT_INDELS_AS_MISMATCHES) continue;
                this.count_bases_mismatch += (long)indel_length;
                this.count_bases_indel += (long)indel_length;
            }
        }
        query.close();
    }

    public static void main(String[] argv) {
        try {
            File bam = null;
            ReferenceSequence refseq = null;
            int min_quality = 15;
            int min_mapq = 1;
            boolean count_indels_as_mismatches = true;
            for (int i = 0; i < argv.length; ++i) {
                String thing;
                File f;
                if (argv[i].equals("-bam")) {
                    bam = new File(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-min-quality")) {
                    min_quality = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-min-mapq")) {
                    min_mapq = Integer.parseInt(argv[++i]);
                    continue;
                }
                if (argv[i].equals("-no-indel-mismatches")) {
                    count_indels_as_mismatches = false;
                    continue;
                }
                if (argv[i].equals("-2bit")) {
                    refseq = new TwoBitFile(argv[++i]);
                    continue;
                }
                if (!argv[i].equals("-fasta")) continue;
                if ((f = new File(thing = argv[++i])).isFile()) {
                    refseq = new FASTAIndexedFAI(thing);
                    continue;
                }
                if (f.isDirectory()) {
                    refseq = new FASTADirectory(thing);
                    continue;
                }
                System.err.println("ERROR: not a file/directory: " + thing);
            }
            if (bam == null || refseq == null) {
                System.err.println("specify -bam [file] and -fasta [file|directory]");
                System.exit(1);
            } else {
                SAMMismatchFrequency mf = new SAMMismatchFrequency();
                mf.set_reference(refseq);
                mf.set_minimum_mapq(min_mapq);
                mf.set_minimum_quality(min_quality);
                mf.set_count_indels_as_mismatches(count_indels_as_mismatches);
                mf.process_bam(bam);
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }
}

