/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Base;
import Ace2.FASTAIndexedFAI;
import Ace2.HashCounter2;
import Ace2.ReferenceSequence;
import Ace2.SAMUtils;
import Funk.Str;
import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;

public class SAMAdapterTrimmer {
    SamReader reader = null;
    ReferenceSequence reference = null;
    String adapter = null;
    String adapter_rc = null;
    File output_file = null;
    int minimum_match_length = 1;
    boolean debug_mode = false;
    private boolean VERBOSE = false;
    private boolean TRIM_FWD = true;
    private boolean TRIM_REV = true;

    public void set_bam(File f) {
        this.reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(f);
        this.output_file = new File(f.getAbsolutePath() + ".adapter_trimmed.fastq");
        System.err.println("output=" + this.output_file);
    }

    public void set_debug_mode(boolean v) {
        this.debug_mode = v;
    }

    public void set_minimum_match_length(int len) {
        this.minimum_match_length = len;
    }

    public void set_refseq(ReferenceSequence reference) {
        this.reference = reference;
    }

    public void set_adapter(String adapter) {
        this.adapter = adapter;
        this.adapter_rc = Str.reverse_complement(adapter);
    }

    public void get_some() throws FileNotFoundException {
        PrintStream ps = this.debug_mode ? null : new PrintStream(new BufferedOutputStream(new FileOutputStream(this.output_file)));
        byte[] ref = null;
        int last_ref_index = -1;
        HashCounter2<Integer> trim_counts = new HashCounter2<Integer>();
        int mapped_count = 0;
        try {
            for (SAMRecord sr : this.reader) {
                int read_i;
                if (sr.getReadUnmappedFlag()) continue;
                ++mapped_count;
                if (sr.getReferenceIndex() != last_ref_index) {
                    String rn = sr.getReferenceName();
                    System.err.println("load new reference: " + rn);
                    ref = this.reference.get_all(rn);
                    last_ref_index = sr.getReferenceIndex();
                }
                byte[] bases = sr.getReadBases();
                byte[] mismatch = new byte[bases.length];
                byte[] aligned = new byte[bases.length];
                Arrays.fill(aligned, (byte)0);
                Arrays.fill(mismatch, (byte)0);
                System.err.println(sr.getReadName() + " at " + sr.getAlignmentStart());
                int mismatches = 0;
                for (AlignmentBlock ab : sr.getAlignmentBlocks()) {
                    int len = ab.getLength();
                    read_i = ab.getReadStart() - 1;
                    int end = read_i + len;
                    for (int ref_i = ab.getReferenceStart() - 1; read_i < end && ref_i < ref.length; ++read_i, ++ref_i) {
                        Base base_ref;
                        aligned[read_i] = 1;
                        Base base_read = Base.valueOf((char)bases[read_i]);
                        if (base_read.equals((Object)(base_ref = Base.valueOf((char)ref[ref_i])))) continue;
                        ++mismatches;
                        mismatch[read_i] = 1;
                    }
                }
                int mismatches_introduced = 0;
                for (read_i = 0; read_i < bases.length; ++read_i) {
                    if (aligned[read_i] != 0) continue;
                    mismatch[read_i] = 1;
                    ++mismatches_introduced;
                    ++mismatches;
                }
                if (mismatches_introduced > 0) {
                    System.err.println("introduced MMs: " + mismatches_introduced + " CIGAR=" + sr.getCigar());
                }
                String info = sr.getReadName();
                if (mismatches > 0) {
                    String ac;
                    String chunk;
                    int ri;
                    String rb = new String(bases).toUpperCase();
                    System.err.println(" read=" + rb + " strand:" + (sr.getReadNegativeStrandFlag() ? "-" : "+"));
                    if (sr.getReadNegativeStrandFlag()) {
                        for (ri = this.adapter.length() - 1; ri >= 0; --ri) {
                            if (mismatch[ri] <= 0) continue;
                            chunk = Str.reverse_complement(rb.substring(0, ri + 1));
                            ac = this.adapter.substring(0, chunk.length());
                            System.err.println("test mm at " + ri + " chunk_rc=" + chunk + " ac=" + ac);
                            if (chunk.length() != ac.length()) {
                                System.err.println("EPIC FAIL: chunk mismatch");
                            }
                            if (!chunk.equals(ac) || chunk.length() < this.minimum_match_length) continue;
                            trim_counts.add(chunk.length());
                            System.err.println("trimming - " + ri + " " + chunk + " " + ac + " total_MM:" + mismatches + " len=" + chunk.length() + " CIGAR=" + sr.getCigar());
                            if (this.TRIM_REV) {
                                info = info.concat(" adapter_trim " + chunk.length() + " -");
                                this.trim_adapter_sequence(sr, ri);
                            } else {
                                System.err.println("DEBUG: - trim DISABLED");
                            }
                            break;
                        }
                    } else {
                        for (ri = bases.length - this.adapter.length(); ri < bases.length; ++ri) {
                            if (mismatch[ri] <= 0) continue;
                            chunk = rb.substring(ri);
                            ac = this.adapter.substring(0, chunk.length());
                            if (chunk.length() != ac.length()) {
                                System.err.println("EPIC FAIL: chunk mismatch");
                            }
                            if (!chunk.equals(ac) || chunk.length() < this.minimum_match_length) continue;
                            trim_counts.add(chunk.length());
                            System.err.println("trimming + " + ri + " " + chunk + " " + ac + " total_MM:" + mismatches + " len=" + chunk.length() + " CIGAR=" + sr.getCigar());
                            if (this.TRIM_FWD) {
                                info = info.concat(" adapter_trim " + chunk.length() + " +");
                                this.trim_adapter_sequence(sr, ri);
                            } else {
                                System.err.println("DEBUG: + trim DISABLED");
                            }
                            break;
                        }
                    }
                }
                if (ps == null) continue;
                SAMUtils.write_fastq(ps, sr, info);
            }
            System.err.println("mapped count: " + mapped_count);
            System.err.println("adapter-trimmed count: " + trim_counts.get_total());
            HashMap counts = trim_counts.get_counts();
            for (Integer length : counts.keySet()) {
                System.err.println("  " + length + ": " + counts.get(length));
            }
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
            e.printStackTrace();
        }
    }

    public static void main(String[] argv) {
        SAMAdapterTrimmer sat = new SAMAdapterTrimmer();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-bam")) {
                sat.set_bam(new File(argv[++i]));
                continue;
            }
            if (argv[i].equals("-adapter")) {
                sat.set_adapter(new String(argv[++i]).toUpperCase());
                continue;
            }
            if (argv[i].equals("-min-match-length")) {
                sat.set_minimum_match_length(Integer.parseInt(argv[++i]));
                continue;
            }
            if (argv[i].equals("-debug")) {
                sat.set_debug_mode(true);
                continue;
            }
            if (argv[i].equals("-fasta")) {
                try {
                    String thing = argv[++i];
                    File f = new File(thing);
                    if (f.isFile()) {
                        sat.set_refseq(new FASTAIndexedFAI(thing));
                        continue;
                    }
                    System.err.println("ERROR: not a file: " + thing);
                }
                catch (Exception ex) {
                    System.err.println("WTF");
                }
                continue;
            }
            System.err.println("ERROR: unknown parameter " + argv[i]);
            System.exit(1);
        }
        try {
            sat.get_some();
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e);
        }
    }

    private void trim_adapter_sequence(SAMRecord sr, int ri) {
        byte[] qual_new;
        byte[] rb_new;
        if (sr.getReadNegativeStrandFlag()) {
            rb_new = this.sub_copy_rev(sr.getReadBases(), ri);
            qual_new = this.sub_copy_rev(sr.getBaseQualities(), ri);
            if (this.VERBOSE) {
                System.err.println("before:" + new String(sr.getReadBases()));
                System.err.println(" after:" + new String(rb_new));
                System.err.println("before:" + new String(sr.getBaseQualities()));
                System.err.println(" after:" + new String(qual_new));
            }
        } else {
            rb_new = this.sub_copy_fwd(sr.getReadBases(), ri);
            qual_new = this.sub_copy_fwd(sr.getBaseQualities(), ri);
            if (this.VERBOSE) {
                System.err.println("before:" + new String(sr.getReadBases()));
                System.err.println(" after:" + new String(rb_new));
                System.err.println("before:" + new String(sr.getBaseQualities()));
                System.err.println(" after:" + new String(qual_new));
            }
        }
        sr.setReadBases(rb_new);
        sr.setBaseQualities(qual_new);
    }

    private byte[] sub_copy_fwd(byte[] orig, int ri) {
        byte[] n = new byte[ri];
        System.arraycopy(orig, 0, n, 0, ri);
        return n;
    }

    private byte[] sub_copy_rev(byte[] orig, int ri) {
        int start = ri + 1;
        int block_len = orig.length - start;
        byte[] n = new byte[block_len];
        if (n.length != block_len) {
            System.err.println("WTF");
        }
        System.arraycopy(orig, start, n, 0, block_len);
        return n;
    }
}

