/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import java.util.Arrays;

public class PadMap {
    private char[] padded;
    private int[] pad2unpad;
    private int[] unpad2pad;
    private int last_upcpos;
    private static final boolean DEBUG = false;
    public static final int UNDEF = -999999;

    public PadMap(String padded) {
        this.padded = padded.toCharArray();
        this.do_map();
    }

    public PadMap(char[] padded) {
        this.padded = padded;
        this.do_map();
    }

    private void do_map() {
        int pi = 0;
        int pcpos = 1;
        int upcpos = 1;
        int len = this.padded.length;
        this.pad2unpad = new int[len + 1];
        this.unpad2pad = new int[len + 1];
        Arrays.fill(this.unpad2pad, -999999);
        pi = 0;
        pcpos = 1;
        upcpos = 0;
        while (pi < len) {
            char c = this.padded[pi];
            if (c == '*' || c != '-') {
                // empty if block
            }
            this.pad2unpad[pcpos] = ++upcpos;
            if (this.unpad2pad[upcpos] == -999999) {
                this.unpad2pad[upcpos] = pcpos;
            }
            ++pi;
            ++pcpos;
        }
        this.last_upcpos = upcpos;
    }

    public char[] get_padded_sequence() {
        return this.padded;
    }

    public int get_padded_to_unpadded(int padded) {
        int result = -1;
        try {
            result = this.pad2unpad[padded];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return result;
    }

    public boolean in_unpadded_range(int unpadded) {
        return unpadded >= 0 && unpadded < this.unpad2pad.length;
    }

    public int get_unpadded_to_padded(int unpadded) {
        if (unpadded >= this.unpad2pad.length) {
            System.err.println("ERROR: get_unpadded_to_padded out of range!!");
            new Exception().printStackTrace();
            return 0;
        }
        return this.unpad2pad[unpadded];
    }

    public int get_max_unpadded() {
        return this.last_upcpos;
    }

    public static void main(String[] argv) {
        String padded = "ac*gG***t";
        System.err.println("sequence: " + padded);
        System.err.println("");
        PadMap pm = new PadMap(padded);
        System.err.println("padded-to-unpadded:");
        System.err.println("  map 5:" + pm.get_padded_to_unpadded(5));
        System.err.println("  map 8:" + pm.get_padded_to_unpadded(8));
        System.err.println("  map 9:" + pm.get_padded_to_unpadded(9));
        System.err.println("");
        System.err.println("unpadded-to-padded:");
        System.err.println("  map 3:" + pm.get_unpadded_to_padded(3));
        System.err.println("  map 4:" + pm.get_unpadded_to_padded(4));
        System.err.println("  map 9:" + pm.get_unpadded_to_padded(9));
    }
}

