/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.SplicedReadInfo;
import IsoView.Transcript;
import IsoView.TranscriptIntron;
import IsoView.UCSCRefGene;
import IsoView.UCSCRefGeneReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntronCache {
    HashMap<String, HashMap<String, HashSet<UCSCRefGene>>> cache;

    public IntronCache(UCSCRefGeneReader r) throws IOException {
        this.setup(r);
    }

    private void setup(UCSCRefGeneReader r) throws IOException {
        this.cache = new HashMap();
        long start = System.currentTimeMillis();
        for (UCSCRefGene rg : r) {
            Transcript t = new Transcript(rg, true);
            for (TranscriptIntron ti : t.introns) {
                String range;
                HashSet<UCSCRefGene> rg_bucket;
                HashMap<String, HashSet<UCSCRefGene>> junction_bucket;
                String ref_name = Chromosome.standardize_name(ti.get_reference());
                if (ref_name.indexOf("chr") != 0) {
                    System.err.println("WARNING: non-chr* reference sequence " + ref_name);
                }
                if ((junction_bucket = this.cache.get(ref_name)) == null) {
                    junction_bucket = new HashMap();
                    this.cache.put(ref_name, junction_bucket);
                }
                if ((rg_bucket = junction_bucket.get(range = ti.get_range_digest().toString())) == null) {
                    rg_bucket = new HashSet();
                    junction_bucket.put(range, rg_bucket);
                }
                rg_bucket.add(rg);
            }
        }
        System.err.println("intron cache:");
        int total = 0;
        for (String key : this.cache.keySet()) {
            int count = this.cache.get(key).size();
            System.err.println("  " + key + ": " + count);
            total += count;
        }
        System.err.println("  total=" + total);
        System.err.println("flatfile db load: " + (System.currentTimeMillis() - start) + " ms");
    }

    public HashSet<UCSCRefGene> find_exon_junction(SplicedReadInfo sri) {
        HashSet<UCSCRefGene> result = null;
        String ref_name = Chromosome.standardize_name(sri.reference_name);
        HashMap<String, HashSet<UCSCRefGene>> junction_bucket = this.cache.get(ref_name);
        if (junction_bucket == null) {
            if (Chromosome.valueOfString(sri.reference_name) != null) {
                System.err.println("WTF: no bucket for " + sri.reference_name);
            }
        } else {
            String key = sri.segment_1_end + 1 + "-" + (sri.segment_2_start - 1);
            result = junction_bucket.get(key);
        }
        return result;
    }
}

