/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;

public class DuplicateMapReport {
    File bam_file;
    HashMap<Integer, HashMap<String, Integer>> sites = new HashMap();
    static int FLUSH_CHECK = 250000;
    static boolean VERBOSE = false;
    int worst_key_count = 0;
    String worst_key = null;

    public DuplicateMapReport(File bam_file) {
        this.bam_file = bam_file;
    }

    private void flush(boolean force, int current_as) {
        HashSet<Integer> delete = new HashSet<Integer>();
        for (Integer site : this.sites.keySet()) {
            if (!force && site >= current_as) continue;
            delete.add(site);
            HashMap<String, Integer> bucket = this.sites.get(site);
            for (String key : bucket.keySet()) {
                int count = bucket.get(key);
                if (VERBOSE) {
                    System.err.println("final " + key + " = " + count);
                }
                if (count <= this.worst_key_count) continue;
                this.worst_key_count = count;
                this.worst_key = key;
            }
        }
        for (Integer site : delete) {
            this.sites.remove(site);
        }
    }

    public void report() {
        SamReader reader = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT).open(this.bam_file);
        int max_nh = 0;
        String max_nh_read = "";
        int last_ri = -1;
        int reads = 0;
        for (SAMRecord sr : reader) {
            if (sr.getReadUnmappedFlag()) continue;
            Cigar c = sr.getCigar();
            boolean has_skip = false;
            for (CigarElement ce : c.getCigarElements()) {
                if (!ce.getOperator().equals((Object)CigarOperator.SKIPPED_REGION)) continue;
                has_skip = true;
                break;
            }
            if (!has_skip) continue;
            String strand = sr.getReadNegativeStrandFlag() ? "-" : "+";
            int as = sr.getAlignmentStart();
            int ri = sr.getReferenceIndex();
            if (ri != last_ri) {
                System.err.println("processing " + sr.getReferenceName() + "...");
                this.flush(true, 0);
                last_ri = ri;
            }
            if (++reads % FLUSH_CHECK == 0) {
                System.err.println(as + ": processed " + reads + " ...");
                this.flush(false, as);
            }
            try {
                int map_count = sr.getIntegerAttribute("NH");
                if (VERBOSE) {
                    System.err.println("read=" + sr.getReadName() + " start=" + as + " strand=" + strand + " nh=" + map_count);
                }
                if (map_count > max_nh) {
                    max_nh = map_count;
                    max_nh_read = sr.getReadName();
                }
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            String key = sr.getReadName() + "_" + sr.getReferenceName() + "_" + as + "_" + strand + "_" + sr.getCigar();
            HashMap<String, Integer> bucket = this.sites.get(as);
            if (bucket == null) {
                bucket = new HashMap();
                this.sites.put(as, bucket);
            }
            int count = bucket.containsKey(key) ? bucket.get(key) : 0;
            bucket.put(key, count + 1);
        }
        this.flush(true, 0);
        System.err.println("max NH:" + max_nh + " read:" + max_nh_read);
        System.err.println("max key:" + this.worst_key_count + " key:" + this.worst_key);
    }

    public static void main(String[] argv) {
        DuplicateMapReport dmr = null;
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-bam")) continue;
            dmr = new DuplicateMapReport(new File(argv[++i]));
        }
        if (dmr != null) {
            dmr.report();
        }
    }
}

