/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AceSequence;
import Ace2.SNP;
import Ace2.SNPList;
import Funk.Str;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Contig {
    AceSequence consensus;
    Hashtable members;
    String name;
    SNPList snps;
    Vector quality;
    private boolean flipped;
    private Hashtable flip_restore = null;
    private int leftmost;
    private int rightmost;
    private static final int POLY_COUNT = 13;
    private static final String REVERSE_POS_SIGNAL = "TTTATT";

    Contig(String name) {
        this.name = name;
        this.consensus = new AceSequence(name);
        this.consensus.is_contig = true;
        this.consensus.asm_start_padded = 1;
        this.members = new Hashtable();
        this.quality = new Vector();
        this.flipped = false;
        this.snps = null;
    }

    AceSequence create_member(String id) {
        AceSequence seq = new AceSequence(id);
        this.members.put(id, seq);
        return seq;
    }

    AceSequence get_member(String id) {
        return (AceSequence)this.members.get(id);
    }

    public int get_size() {
        return this.members.size();
    }

    public void flip() {
        this.flipped = !this.flipped;
        int consensus_end = this.consensus.sequence.length() + 1;
        Enumeration<Object> e = this.members.elements();
        int half = this.quality.size() / 2;
        int end = this.quality.size() - 1;
        for (int i = 0; i < half; ++i) {
            int there = end - i;
            Object temp = this.quality.elementAt(there);
            this.quality.setElementAt(this.quality.elementAt(i), there);
            this.quality.setElementAt(temp, i);
        }
        if (this.flipped) {
            this.flip_restore = new Hashtable();
        }
        while (e.hasMoreElements()) {
            AceSequence backup;
            AceSequence seq = (AceSequence)e.nextElement();
            if (this.flipped) {
                backup = new AceSequence(seq.name);
                int as = backup.asm_start_padded = seq.asm_start_padded;
                int ae = backup.asm_end_padded = seq.asm_end_padded;
                int cs = backup.clip_start_padded = seq.clip_start_padded;
                int ce = backup.clip_end_padded = seq.clip_end_padded;
                this.flip_restore.put(seq.name, backup);
                seq.asm_start_padded = consensus_end - ae;
                seq.asm_end_padded = consensus_end - as;
                int length = seq.sequence.length();
                seq.clip_start_padded = length - ce;
                seq.clip_end_padded = length - cs;
            } else {
                backup = (AceSequence)this.flip_restore.get(seq.name);
                seq.asm_start_padded = backup.asm_start_padded;
                seq.asm_end_padded = backup.asm_end_padded;
                seq.clip_start_padded = backup.clip_start_padded;
                seq.clip_end_padded = backup.clip_end_padded;
            }
            seq.reverse_complement();
        }
        this.consensus.reverse_complement();
        if (this.snps != null) {
            e = this.snps.elements();
            while (e.hasMoreElements()) {
                SNP snp = (SNP)e.nextElement();
                snp.position = consensus_end - snp.position;
            }
        }
    }

    public boolean is_rc() {
        return this.flipped;
    }

    public boolean needs_flip() {
        boolean needs = false;
        Enumeration e = this.members.elements();
        int longest_len = 0;
        AceSequence longest_seq = null;
        while (e.hasMoreElements()) {
            AceSequence seq = (AceSequence)e.nextElement();
            if (!Str.is_genbank_accession(seq.name)) continue;
            int len = seq.unpadded_sequence().length();
            if (longest_seq != null && len <= longest_len) continue;
            longest_len = len;
            longest_seq = seq;
        }
        needs = longest_seq != null && longest_len > 1000 && longest_seq.complemented;
        return needs;
    }

    private boolean flip_check(AceSequence seq) {
        boolean needs = false;
        char[] poly = new char[13];
        String check = seq.unpadded_sequence().toString().toUpperCase();
        int cutoff = check.length() / 4;
        for (int i = 0; i < 3; ++i) {
            block3: {
                int after;
                int positioning;
                int diff;
                int c = i == 0 ? 84 : (i == 1 ? 78 : 88);
                for (int j = 0; j < 13; ++j) {
                    poly[j] = c;
                }
                String pt = new String(poly);
                int index = -1;
                do {
                    ++index;
                    if ((index = check.indexOf(pt, index)) == -1 || index > cutoff) break block3;
                } while ((diff = (positioning = check.indexOf(REVERSE_POS_SIGNAL, after = index + pt.length())) - after) < 9 || diff > 35);
                needs = true;
                System.out.println("found TTTATT after " + pt + " at " + positioning + "; contig likely in 3' to 5' orientation");
            }
            if (needs) break;
        }
        return needs;
    }

    public Enumeration get_members() {
        return this.members.elements();
    }

    public Enumeration get_member_ids() {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.members.elements();
        while (e.hasMoreElements()) {
            AceSequence as = (AceSequence)e.nextElement();
            v.addElement(as.name);
        }
        return v.elements();
    }

    public void find_bounds() {
        Enumeration e = this.members.elements();
        this.rightmost = 1;
        this.leftmost = 1;
        while (e.hasMoreElements()) {
            AceSequence s = (AceSequence)e.nextElement();
            if (s.asm_start_padded < this.leftmost) {
                this.leftmost = s.asm_start_padded;
            }
            if (s.asm_end_padded <= this.rightmost) continue;
            this.rightmost = s.asm_end_padded;
        }
    }

    public int leftmost() {
        return this.leftmost;
    }

    public int rightmost() {
        return this.rightmost;
    }

    public int consensus_length() {
        return this.consensus.sequence.length();
    }
}

