/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AlleleSkewInfo;
import Ace2.Assembly;
import Ace2.AssemblySequence;
import Ace2.Base;
import Ace2.BaseCountInfo;
import Ace2.Sample;
import Ace2.TumorNormal;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlleleSkew {
    private Assembly assembly;
    private EnumMap<TumorNormal, EnumMap<Base, Integer>> counts;
    private TreeSet<Base> saw_bases;
    private HashMap<TumorNormal, AlleleSkewInfo> summaries;
    private static float HOMOZYGOUS_CUTOFF = 0.95f;

    public AlleleSkew(Assembly assembly) {
        this.assembly = assembly;
        this.counts = new EnumMap(TumorNormal.class);
        this.counts.put(TumorNormal.NORMAL, new EnumMap(Base.class));
        this.counts.put(TumorNormal.TUMOR, new EnumMap(Base.class));
        this.saw_bases = new TreeSet();
    }

    public AlleleSkewInfo get_info_for(TumorNormal tn) {
        return this.summaries.get((Object)tn);
    }

    public ArrayList<Base> get_bases() {
        return new ArrayList<Base>(this.saw_bases);
    }

    public void add(BaseCountInfo bi) {
        this.saw_bases.add(bi.base);
        for (Object o : bi.sequences) {
            AssemblySequence as = (AssemblySequence)o;
            Sample s = this.assembly.get_sample_for(as.get_name());
            TumorNormal tn = s.get_tumornormal();
            if (!tn.isValid()) continue;
            EnumMap<Base, Integer> counter = this.counts.get((Object)tn);
            Integer count = counter.get((Object)bi.base);
            if (count == null) {
                count = 0;
            }
            counter.put(bi.base, count + 1);
        }
    }

    public void analyze() {
        this.summaries = new HashMap();
        float inverse_cutoff = 1.0f - HOMOZYGOUS_CUTOFF;
        for (TumorNormal tn : this.counts.keySet()) {
            int total_reads = 0;
            EnumMap<Base, Integer> counter = this.counts.get((Object)tn);
            for (Integer i : counter.values()) {
                total_reads += i.intValue();
            }
            if (total_reads == 0) continue;
            AlleleSkewInfo info = new AlleleSkewInfo(tn);
            this.summaries.put(tn, info);
            for (Base b : this.saw_bases) {
                Integer count = this.counts.get((Object)tn).get((Object)b);
                int c = count == null ? 0 : count;
                float ratio = (float)c / (float)total_reads;
                if (ratio >= HOMOZYGOUS_CUTOFF) {
                    info.add_base(b);
                    continue;
                }
                if (ratio <= inverse_cutoff) continue;
                info.add_base(b);
            }
        }
    }

    public boolean is_somatic_variation() {
        ArrayList<TumorNormal> keys = new ArrayList<TumorNormal>(this.summaries.keySet());
        if (keys.size() > 1) {
            return !this.summaries.get((Object)TumorNormal.TUMOR).equals(this.summaries.get((Object)TumorNormal.NORMAL));
        }
        return false;
    }

    public int get_somatic_variation_int() {
        ArrayList<TumorNormal> keys = new ArrayList<TumorNormal>(this.summaries.keySet());
        if (keys.size() > 1) {
            return this.summaries.get((Object)TumorNormal.TUMOR).equals(this.summaries.get((Object)TumorNormal.NORMAL)) ? 0 : 1;
        }
        return -1;
    }

    public String toString() {
        String label;
        ArrayList<TumorNormal> keys = new ArrayList<TumorNormal>(this.summaries.keySet());
        if (keys.size() > 1) {
            label = this.is_somatic_variation() ? "somatic: " + (Object)((Object)TumorNormal.NORMAL) + " " + this.summaries.get((Object)TumorNormal.NORMAL) + ", " + (Object)((Object)TumorNormal.TUMOR) + " " + this.summaries.get((Object)TumorNormal.TUMOR) : "germline: " + this.summaries.get((Object)keys.get(0));
        } else if (keys.size() == 0) {
            label = "can't compute (no sample tumor/normal info)";
        } else {
            TumorNormal tn = keys.get(0);
            label = "can't compute (need both N and T): " + (Object)((Object)tn) + this.summaries.get((Object)tn);
        }
        return label;
    }
}

