# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetCloudProjectRegionResult',
    'AwaitableGetCloudProjectRegionResult',
    'get_cloud_project_region',
    'get_cloud_project_region_output',
]

@pulumi.output_type
class GetCloudProjectRegionResult:
    """
    A collection of values returned by getCloudProjectRegion.
    """
    def __init__(__self__, continent_code=None, datacenter_location=None, id=None, name=None, service_name=None, services=None):
        if continent_code and not isinstance(continent_code, str):
            raise TypeError("Expected argument 'continent_code' to be a str")
        pulumi.set(__self__, "continent_code", continent_code)
        if datacenter_location and not isinstance(datacenter_location, str):
            raise TypeError("Expected argument 'datacenter_location' to be a str")
        pulumi.set(__self__, "datacenter_location", datacenter_location)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if services and not isinstance(services, list):
            raise TypeError("Expected argument 'services' to be a list")
        pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter(name="continentCode")
    def continent_code(self) -> str:
        """
        the code of the geographic continent the region is running.
        E.g.: EU for Europe, US for America...
        """
        return pulumi.get(self, "continent_code")

    @property
    @pulumi.getter(name="datacenterLocation")
    def datacenter_location(self) -> str:
        """
        The location code of the datacenter.
        E.g.: "GRA", meaning Gravelines, for region "GRA1"
        """
        return pulumi.get(self, "datacenter_location")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        the name of the public cloud service
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def services(self) -> Sequence['outputs.GetCloudProjectRegionServiceResult']:
        """
        The list of public cloud services running within the region
        """
        return pulumi.get(self, "services")


class AwaitableGetCloudProjectRegionResult(GetCloudProjectRegionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudProjectRegionResult(
            continent_code=self.continent_code,
            datacenter_location=self.datacenter_location,
            id=self.id,
            name=self.name,
            service_name=self.service_name,
            services=self.services)


def get_cloud_project_region(name: Optional[str] = None,
                             service_name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudProjectRegionResult:
    """
    Use this data source to retrieve information about a region associated with a public cloud project. The region must be associated with the project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    g_ra1 = ovh.get_cloud_project_region(name="GRA1",
        service_name="XXXXXX")
    ```


    :param str name: The name of the region associated with the public cloud
           project.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getCloudProjectRegion:getCloudProjectRegion', __args__, opts=opts, typ=GetCloudProjectRegionResult).value

    return AwaitableGetCloudProjectRegionResult(
        continent_code=__ret__.continent_code,
        datacenter_location=__ret__.datacenter_location,
        id=__ret__.id,
        name=__ret__.name,
        service_name=__ret__.service_name,
        services=__ret__.services)


@_utilities.lift_output_func(get_cloud_project_region)
def get_cloud_project_region_output(name: Optional[pulumi.Input[str]] = None,
                                    service_name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCloudProjectRegionResult]:
    """
    Use this data source to retrieve information about a region associated with a public cloud project. The region must be associated with the project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    g_ra1 = ovh.get_cloud_project_region(name="GRA1",
        service_name="XXXXXX")
    ```


    :param str name: The name of the region associated with the public cloud
           project.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    ...
