import { Construct } from 'constructs';
import { UserPoolIdentityProviderProps } from './base';
import { UserPoolIdentityProviderBase } from './private/user-pool-idp-base';
/**
 * Properties to initialize UserPoolFacebookIdentityProvider.
 *
 * @stability stable
 */
export interface UserPoolIdentityProviderFacebookProps extends UserPoolIdentityProviderProps {
    /**
     * The client id recognized by Facebook APIs.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * The client secret to be accompanied with clientUd for Facebook to authenticate the client.
     *
     * @see https://developers.facebook.com/docs/facebook-login/security#appsecret
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * The list of facebook permissions to obtain for getting access to the Facebook profile.
     *
     * @default [ public_profile ]
     * @see https://developers.facebook.com/docs/facebook-login/permissions
     * @stability stable
     */
    readonly scopes?: string[];
    /**
     * The Facebook API version to use.
     *
     * @default - to the oldest version supported by Facebook
     * @stability stable
     */
    readonly apiVersion?: string;
}
/**
 * Represents a identity provider that integrates with 'Facebook Login'.
 *
 * @stability stable
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderFacebook extends UserPoolIdentityProviderBase {
    /**
     * The primary identifier of this identity provider.
     *
     * @stability stable
     */
    readonly providerName: string;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderFacebookProps);
}
