"""
Schema for facility units

"""

import enum
from datetime import date

from pydantic import BaseModel


class UnitDispatchType(enum.Enum):
    GENERATOR = "GENERATOR"
    LOAD = "LOAD"
    BIDIRECTIONAL = "BIDIRECTIONAL"


class UnitStatusType(enum.Enum):
    committed = "committed"
    operating = "operating"
    retired = "retired"


class UnitFueltechType(enum.Enum):
    battery = "battery"
    battery_charging = "battery_charging"
    battery_discharging = "battery_discharging"
    bioenergy_biogas = "bioenergy_biogas"
    bioenergy_biomass = "bioenergy_biomass"
    coal_black = "coal_black"
    coal_brown = "coal_brown"
    distillate = "distillate"
    gas_ccgt = "gas_ccgt"
    gas_ocgt = "gas_ocgt"
    gas_recip = "gas_recip"
    gas_steam = "gas_steam"
    gas_wcmg = "gas_wcmg"
    hydro = "hydro"
    pumps = "pumps"
    solar_rooftop = "solar_rooftop"
    solar_thermal = "solar_thermal"
    solar_utility = "solar_utility"
    nuclear = "nuclear"
    other = "other"
    solar = "solar"
    wind = "wind"
    wind_offshore = "wind_offshore"
    imports = "imports"
    exports = "exports"
    interconnector = "interconnector"
    aggregator_vpp = "aggregator_vpp"
    aggregator_dr = "aggregator_dr"


class UnitSchema(BaseModel):
    """Facility output schema"""

    code: str
    dispatch_type: UnitDispatchType
    fueltech_id: UnitFueltechType
    status_id: UnitStatusType
    capacity_registered: float | None = None
    capacity_maximum: float | None = None
    storage_capacity: float | None = None
    emissions_factor_co2: float | None = None
    expected_closure_date: date | None = None
    commencement_date: date | None = None
    closure_date: date | None = None
