"""Constants which are related to Canadian composer Marc Sabat."""

from mutwo.parameters import pitches

TUNEABLE_INTERVAL_TO_DIFFICULTY = {
    pitches.JustIntonationPitch("1/1").exponents: 0,
    pitches.JustIntonationPitch("8/7").exponents: 1,
    pitches.JustIntonationPitch("7/6").exponents: 0,
    pitches.JustIntonationPitch("6/5").exponents: 0,
    pitches.JustIntonationPitch("11/9").exponents: 2,
    pitches.JustIntonationPitch("5/4").exponents: 0,
    pitches.JustIntonationPitch("9/7").exponents: 0,
    pitches.JustIntonationPitch("13/10").exponents: 1,
    pitches.JustIntonationPitch("4/3").exponents: 0,
    pitches.JustIntonationPitch("11/8").exponents: 2,
    pitches.JustIntonationPitch("7/5").exponents: 0,
    pitches.JustIntonationPitch("10/7").exponents: 1,
    pitches.JustIntonationPitch("13/9").exponents: 2,
    pitches.JustIntonationPitch("16/11").exponents: 2,
    pitches.JustIntonationPitch("3/2").exponents: 0,
    pitches.JustIntonationPitch("14/9").exponents: 2,
    pitches.JustIntonationPitch("11/7").exponents: 1,
    pitches.JustIntonationPitch("8/5").exponents: 0,
    pitches.JustIntonationPitch("13/8").exponents: 1,
    pitches.JustIntonationPitch("5/3").exponents: 0,
    pitches.JustIntonationPitch("12/7").exponents: 1,
    pitches.JustIntonationPitch("7/4").exponents: 0,
    pitches.JustIntonationPitch("9/5").exponents: 0,
    pitches.JustIntonationPitch("11/6").exponents: 1,
    pitches.JustIntonationPitch("13/7").exponents: 1,
    pitches.JustIntonationPitch("15/8").exponents: 2,
    pitches.JustIntonationPitch("23/12").exponents: 2,
    pitches.JustIntonationPitch("2/1").exponents: 0,
    pitches.JustIntonationPitch("13/6").exponents: 1,
    pitches.JustIntonationPitch("11/5").exponents: 1,
    pitches.JustIntonationPitch("9/4").exponents: 0,
    pitches.JustIntonationPitch("7/3").exponents: 0,
    pitches.JustIntonationPitch("19/8").exponents: 2,
    pitches.JustIntonationPitch("12/5").exponents: 0,
    pitches.JustIntonationPitch("17/7").exponents: 1,
    pitches.JustIntonationPitch("5/2").exponents: 0,
    pitches.JustIntonationPitch("18/7").exponents: 1,
    pitches.JustIntonationPitch("13/5").exponents: 1,
    pitches.JustIntonationPitch("8/3").exponents: 0,
    pitches.JustIntonationPitch("11/4").exponents: 0,
    pitches.JustIntonationPitch("14/5").exponents: 0,
    pitches.JustIntonationPitch("17/6").exponents: 1,
    pitches.JustIntonationPitch("20/7").exponents: 1,
    pitches.JustIntonationPitch("23/8").exponents: 1,
    pitches.JustIntonationPitch("3/1").exponents: 0,
    pitches.JustIntonationPitch("28/9").exponents: 2,
    pitches.JustIntonationPitch("25/8").exponents: 2,
    pitches.JustIntonationPitch("22/7").exponents: 2,
    pitches.JustIntonationPitch("19/6").exponents: 2,
    pitches.JustIntonationPitch("16/5").exponents: 0,
    pitches.JustIntonationPitch("13/4").exponents: 0,
    pitches.JustIntonationPitch("10/3").exponents: 0,
    pitches.JustIntonationPitch("27/8").exponents: 2,
    pitches.JustIntonationPitch("17/5").exponents: 1,
    pitches.JustIntonationPitch("24/7").exponents: 2,
    pitches.JustIntonationPitch("7/2").exponents: 0,
    pitches.JustIntonationPitch("18/5").exponents: 0,
    pitches.JustIntonationPitch("11/3").exponents: 0,
    pitches.JustIntonationPitch("15/4").exponents: 0,
    pitches.JustIntonationPitch("19/5").exponents: 1,
    pitches.JustIntonationPitch("23/6").exponents: 2,
    pitches.JustIntonationPitch("27/7").exponents: 2,
    pitches.JustIntonationPitch("4/1").exponents: 0,
    pitches.JustIntonationPitch("25/6").exponents: 2,
    pitches.JustIntonationPitch("21/5").exponents: 2,
    pitches.JustIntonationPitch("17/4").exponents: 1,
    pitches.JustIntonationPitch("13/3").exponents: 0,
    pitches.JustIntonationPitch("22/5").exponents: 2,
    pitches.JustIntonationPitch("9/2").exponents: 0,
    pitches.JustIntonationPitch("23/5").exponents: 1,
    pitches.JustIntonationPitch("14/3").exponents: 0,
    pitches.JustIntonationPitch("19/4").exponents: 1,
    pitches.JustIntonationPitch("24/5").exponents: 1,
    pitches.JustIntonationPitch("5/1").exponents: 0,
    pitches.JustIntonationPitch("26/5").exponents: 2,
    pitches.JustIntonationPitch("21/4").exponents: 1,
    pitches.JustIntonationPitch("16/3").exponents: 0,
    pitches.JustIntonationPitch("11/2").exponents: 0,
    pitches.JustIntonationPitch("28/5").exponents: 1,
    pitches.JustIntonationPitch("17/3").exponents: 0,
    pitches.JustIntonationPitch("23/4").exponents: 1,
    pitches.JustIntonationPitch("6/1").exponents: 0,
    pitches.JustIntonationPitch("25/4").exponents: 1,
    pitches.JustIntonationPitch("19/3").exponents: 0,
    pitches.JustIntonationPitch("13/2").exponents: 0,
    pitches.JustIntonationPitch("20/3").exponents: 0,
    pitches.JustIntonationPitch("27/4").exponents: 2,
    pitches.JustIntonationPitch("7/1").exponents: 0,
    pitches.JustIntonationPitch("22/3").exponents: 0,
    pitches.JustIntonationPitch("15/2").exponents: 0,
    pitches.JustIntonationPitch("23/3").exponents: 0,
    pitches.JustIntonationPitch("8/1").exponents: 0,
}
"""Tuneable Just Intonation Intervals sorted by difficulty, according to Marc Sabat."""

TUNEABLE_INTERVALS = tuple(
    pitches.JustIntonationPitch(exponents)
    for exponents in TUNEABLE_INTERVAL_TO_DIFFICULTY.keys()
)
"""Tuneable Just Intonation Intervals according to Marc Sabat."""
