# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExportImportDevice(Model):
    """ExportImportDevice.

    :param id: Device Id is always required
    :type id: str
    :param module_id: ModuleId is applicable to modules only
    :type module_id: str
    :param e_tag: ETag parameter is only used for pre-conditioning the update
     when importMode is updateIfMatchETag
    :type e_tag: str
    :param import_mode: Possible values include: 'create', 'update',
     'updateIfMatchETag', 'delete', 'deleteIfMatchETag', 'updateTwin',
     'updateTwinIfMatchETag'
    :type import_mode: str or ~protocol.models.enum
    :param status: Status is optional and defaults to enabled. Possible values
     include: 'enabled', 'disabled'
    :type status: str or ~protocol.models.enum
    :param status_reason:
    :type status_reason: str
    :param authentication: Authentication parameter is optional and defaults
     to SAS if not provided. In that case, we auto-generate primary/secondary
     access keys
    :type authentication: ~protocol.models.AuthenticationMechanism
    :param twin_etag: twinETag parameter is only used for pre-conditioning the
     update when importMode is updateTwinIfMatchETag
    :type twin_etag: str
    :param tags:
    :type tags: dict[str, object]
    :param properties: Properties are optional and defaults to empty object
    :type properties: ~protocol.models.PropertyContainer
    :param capabilities: Capabilities param is optional and defaults to no
     capability
    :type capabilities: ~protocol.models.DeviceCapabilities
    :param device_scope:
    :type device_scope: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "module_id": {"key": "moduleId", "type": "str"},
        "e_tag": {"key": "eTag", "type": "str"},
        "import_mode": {"key": "importMode", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "status_reason": {"key": "statusReason", "type": "str"},
        "authentication": {"key": "authentication", "type": "AuthenticationMechanism"},
        "twin_etag": {"key": "twinETag", "type": "str"},
        "tags": {"key": "tags", "type": "{object}"},
        "properties": {"key": "properties", "type": "PropertyContainer"},
        "capabilities": {"key": "capabilities", "type": "DeviceCapabilities"},
        "device_scope": {"key": "deviceScope", "type": "str"},
    }

    def __init__(self, **kwargs):
        super(ExportImportDevice, self).__init__(**kwargs)
        self.id = kwargs.get("id", None)
        self.module_id = kwargs.get("module_id", None)
        self.e_tag = kwargs.get("e_tag", None)
        self.import_mode = kwargs.get("import_mode", None)
        self.status = kwargs.get("status", None)
        self.status_reason = kwargs.get("status_reason", None)
        self.authentication = kwargs.get("authentication", None)
        self.twin_etag = kwargs.get("twin_etag", None)
        self.tags = kwargs.get("tags", None)
        self.properties = kwargs.get("properties", None)
        self.capabilities = kwargs.get("capabilities", None)
        self.device_scope = kwargs.get("device_scope", None)
