# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_swagger_tester',
 'django_swagger_tester.case',
 'django_swagger_tester.drf_yasg',
 'django_swagger_tester.input_validation',
 'django_swagger_tester.response_validation',
 'django_swagger_tester.static_schema']

package_data = \
{'': ['*']}

install_requires = \
['django>=2.2,<4.0', 'djangorestframework']

setup_kwargs = {
    'name': 'django-swagger-tester',
    'version': '1.0.0',
    'description': 'Django test utility for validating Swagger documentation',
    'long_description': 'Django Swagger Tester\n=====================\n\n.. role:: python(code)\n   :language: python\n\n.. image:: https://img.shields.io/pypi/v/django-swagger-tester.svg\n    :target: https://pypi.org/project/django-swagger-tester/\n\n.. image:: https://img.shields.io/pypi/pyversions/django-swagger-tester.svg\n    :target: https://pypi.org/project/django-swagger-tester/\n\n.. image:: https://img.shields.io/pypi/djversions/django-swagger-tester.svg\n    :target: https://pypi.python.org/pypi/django-swagger-tester\n\n.. image:: https://readthedocs.org/projects/django-swagger-tester/badge/?version=latest\n    :target: https://django-swagger-tester.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n\n.. image:: https://codecov.io/gh/sondrelg/django-swagger-tester/branch/master/graph/badge.svg\n    :target: https://codecov.io/gh/sondrelg/django-swagger-tester\n\n|\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://pypi.org/project/django-swagger-tester/\n\n.. image:: http://www.mypy-lang.org/static/mypy_badge.svg\n    :target: http://mypy-lang.org/\n    :alt: Checked with mypy\n\n.. image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n    :target: https://github.com/pre-commit/pre-commit\n\n--------------\n\n**Documentation**: `https://django-swagger-tester.readthedocs.io <https://django-swagger-tester.readthedocs.io/en/latest/?badge=latest>`_\n\n**Repository**: `https://github.com/sondrelg/django-swagger-tester <https://github.com/sondrelg/django-swagger-tester>`_\n\n--------------\n\n\n\nThis package is a simple test utility for your Django Swagger documentation.\n\nIts aim is to make it easy for developers to catch and correct documentation errors in their Swagger docs by\ncomparing documented responses to actual API responses, or validating documented request bodies using actual input serializers.\n\nFeatures\n--------\n\nThe package has three main features:\n\n-  `Testing response documentation`_\n\n-  `Testing input documentation`_\n\n-  `Ensuring your docs comply with a single parameter naming standard`_.\n\n   Supported naming standards include ``camelCase``, ``snake_case``,\n   ``kebab-case``, and ``PascalCase``.\n\n\nImplementations\n---------------\n\nWe currently support testing of:\n\n- Dynamically rendered Swagger docs, using `drf_yasg`_\n- All implementations which render Swagger docs from a schema file (yaml or json)\n\nIf you\'re using another method to generate your documentation and would like to use this package, feel free to add an issue, or create a PR. Adding a new implementation is as easy as adding the required logic needed to load the OpenAPI schema.\n\nInstallation\n============\n\nInstall using pip:\n\n.. code:: python\n\n   pip install django-swagger-tester\n\nConfiguration\n=============\n\nSettings\n--------\n\nTo use Django Swagger Settings in your project, your first need to add a ``SWAGGER_TESTER``\nobject to your ``settings.py``:\n\n.. code:: python\n\n   SWAGGER_TESTER = {\n       \'CASE\': \'camel case\',\n       \'PATH\': BASE_DIR + \'/openapi-schema.yml\'  # not required for drf_yasg implementations\n   }\n\nParameters\n----------\n\n*CASE*\n~~~~~~\n\nThe parameter naming standard you wish to enforce for your documentation.\n\nNeeds to be one of the following:\n\n-  ``camel case``\n-  ``snake case``\n-  ``pascal case``\n-  ``kebab case``\n-  ``None``\n\nYour OpenAPI schema will be assessed to make sure all parameter names\nare correctly cased according to this preference. If you do not wish\nto enforce this check, you can specify ``None`` to skip this feature.\n\nExample:\n\n.. code:: python\n\n  SWAGGER_TESTER = {\n      \'CASE\': \'snake case\',\n  }\n\n**Default**: ``camel case``\n\n*PATH*\n~~~~~~\n\nThe path to your OpenAPI specification.\n\nExample:\n\n.. code:: python\n\n  SWAGGER_TESTER = {\n      \'PATH\': BASE_DIR + \'/openapi-schema.yml\',\n  }\n\n*This setting is not required if your swagger docs are generated.*\n\n*CAMEL_CASE_PARSER*\n~~~~~~~~~~~~~~~~~~~\n\nShould be set to ``True`` if you use `djangorestframework-camel-case <https://github.com/vbabiy/djangorestframework-camel-case>`_\'s\n``CamelCaseJSONParser`` or ``CamelCaseJSONRenderer`` for your API views.\n\nBy settings this to True, example values constructed in the ``validate_input`` function will be snake cased before it\'s passed\nto a serializer. See the `function docs <https://django-swagger-tester.readthedocs.io/en/latest/implementation.html#the-validate-input-function>`_ for more info.\n\nExample:\n\n.. code:: python\n\n  SWAGGER_TESTER = {\n      \'CAMEL_CASE_PARSER\': True,\n  }\n\n\nResponse Validation\n===================\n\nTo verify that your API response documentation is correct, we test the\ngenerated documentation against actual API responses.\n\nA pytest implementation might look like this:\n\n.. code:: python\n\n   from django_swagger_tester.drf_yasg import validate_response  # or replace drf_yasg with `static_schema`\n\n\n   def test_response_documentation(client):\n       response = client.get(\'api/v1/test/\')\n\n       assert response.status_code == 200\n       assert response.json() == expected_response\n\n       # Test Swagger documentation\n       validate_response(response=response, method=\'GET\', route=\'api/v1/test/\')\n\nA Django-test implementation might look like this:\n\n.. code:: python\n\n   class MyApiTest(APITestCase):\n\n       def setUp(self) -> None:\n           user, _ = User.objects.update_or_create(username=\'test_user\')\n           self.client.force_authenticate(user=user)\n           self.path = \'/api/v1/test/\'\n\n       def test_get_200(self) -> None:\n           """\n           Verifies that a 200 is returned for a valid GET request to the /test/ endpoint.\n           """\n           response = self.client.get(self.path, headers={\'Content-Type\': \'application/json\'})\n           expected_response = [...]\n\n           self.assertEqual(response.status_code, 200)\n           self.assertEqual(response.json(), expected_response)\n\n           # Test Swagger documentation\n           validate_response(response=response, method=\'GET\', route=self.path)\n\nYou can also test more than a single response at the time:\n\n.. code:: python\n\n    def test_response_documentation(client):\n        # 201 - Resource created\n        response = client.post(\'api/v1/test/\', data=...)\n        validate_response(response=response, method=\'POST\', route=\'api/v1/test/\')\n\n        # 200 - Idempotency --> if an object exists, return it with a 200 without creating a new resource\n        response = client.post(\'api/v1/test/\', data=...)\n        validate_response(response=response, method=\'POST\', route=\'api/v1/test/\')\n\n        # 400 - Bad data\n        response = client.post(\'api/v1/test/\', data=bad_data)\n        validate_response(response=response, method=\'POST\', route=\'api/v1/test/\')\n\nInput Validation\n================\n\nTo make sure your request body documentation is accurate, and will stay accurate, it can be useful to set up tests.\n\nConsidering most APIs will use input serializers for input validation, it seems sensible to just run the\nexample documentation on your serializer.\n\nA pytest implementation of input validation might look like this::\n\n    from myapp.api.serializers import MyAPISerializer  # <-- your custom serializer\n\n\n    def test_request_body_documentation(client):\n        """\n        Verifies that our request body documentation is representative of a valid request body.\n        """\n        from django_swagger_tester.drf_yasg import validate_input  # or replace drf_yasg with `static_schema`\n        validate_input(serializer=MyAPISerializer, method=\'POST\', route=\'api/v1/test/\', camel_case_parser=True)\n\n\nThe ``camel_case_parser`` argument should be set to ``True`` if you are using ``CamelCaseJSONParser`` or ``CamelCaseJSONRenderer``\nfrom the `djangorestframework-camel-case <https://github.com/vbabiy/djangorestframework-camel-case>`_ package.\n\n.. _`https://django-swagger-tester.readthedocs.io/`: https://django-swagger-tester.readthedocs.io/en/latest/?badge=latest\n.. _Testing response documentation: https://django-swagger-tester.readthedocs.io/en/latest/implementation.html#response-validation\n.. _Testing input documentation: https://django-swagger-tester.readthedocs.io/en/latest/implementation.html#input-validation\n.. _Ensuring your docs comply with a single parameter naming standard: https://django-swagger-tester.readthedocs.io/en/latest/implementation.html#case-checking\n.. _drf_yasg: https://github.com/axnsan12/drf-yasg\n.. _documentation: https://django-swagger-tester.readthedocs.io/\n.. _docs: https://django-swagger-tester.readthedocs.io/\n',
    'author': 'Sondre Lillebø Gundersen',
    'author_email': 'sondrelg@live.no',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sondrelg/django-swagger-tester',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
