# -*- coding: utf-8 -*-
#
# These are messages used by the Passcrow server when sending verification
# messages to users. The verification request specifies which language is
# preferred. We fall back to English if a translation is unavailable.
#

VERIFICATION_SUBJECT = {
    'en': "%(description)s Verification Code",
    'is': "%(description)s Staðfestingarkóði",
    }


# FIXME: Is "ignore this message" actually good advice?
# This is used in e-mail: keep line lengths under 72 chars please!
VERIFICATION_BODY_LONG = {
    'en': """\
%(description)s: %(vcode)s is your verification code.

This code expires in %(timeout_minutes)s minutes. Don't share it with
anyone. If you were not expecting this verification code, please
ignore this message.""",
    'is': """\
%(description)s: %(vcode)s er staðfestingarkóðinn þinn.

Kóðinn rennur út eftir %(timeout_minutes)s mínútur. Ekki sýna neinum
þennan kóða. Ef þú áttir ekki von á þessum staðfestingarkóða, skaltu
hunsa þetta bréf."""}


# This is deliberately chosen to be similar to SMS messages sent by
# popular online service providers. We hope users are familiar with
# the phrasing and telco spam filters likey to let them through.
#
# Note: The leading spaces are important!
#
VERIFICATION_BODY_SHORT = {
    'en': """\
 %(description)s: %(vcode)s is your verification code.\
 It expires in %(timeout_minutes)s minutes.\
 Don't share this code with anyone.""",
    'is': """\
 %(description)s: %(vcode)s er staðfestingarkóðinn þinn.\
 Hann rennur út eftir %(timeout_minutes)s mínútur.\
 Ekki sýna neinum þennan kóða.""",
    }


# This is shameless advertising for the project. ;-)
# This is used in e-mail: keep line lengths under 72 chars please!
VERIFICATION_BODY_SIGNATURE = {
    'en': """\
Generated by Passcrow, an open community system for key and password
recovery. Details: %(about_url)s""",
    'en': """\
Sent af Passcrow, opið kerfi til að endurheimta lykla og lykilorð.
Nánari upplýsingar: %(about_url)s""",
    }
