import unittest

from conflowgen.domain_models.distribution_models.truck_arrival_distribution import TruckArrivalDistribution
from conflowgen.domain_models.distribution_repositories.truck_arrival_distribution_repository import \
    TruckArrivalDistributionRepository
from conflowgen.domain_models.distribution_seeders import truck_arrival_distribution_seeder
from conflowgen.tests.substitute_peewee_database import setup_sqlite_in_memory_db


class TestTruckArrivalDistributionRepository(unittest.TestCase):
    default_data = {
        0: 0.006944444444444444,
        1: 0.006944444444444444,
        2: 0.006944444444444444,
        3: 0.006944444444444444,
        4: 0.006944444444444444,
        5: 0.006944444444444444,
        6: 0.006944444444444444,
        7: 0.006944444444444444,
        8: 0.006944444444444444,
        9: 0.006944444444444444,
        10: 0.006944444444444444,
        11: 0.006944444444444444,
        12: 0.006944444444444444,
        13: 0.006944444444444444,
        14: 0.006944444444444444,
        15: 0.006944444444444444,
        16: 0.006944444444444444,
        17: 0.006944444444444444,
        18: 0.006944444444444444,
        19: 0.006944444444444444,
        20: 0.006944444444444444,
        21: 0.006944444444444444,
        22: 0.006944444444444444,
        23: 0.006944444444444444,
        24: 0.006944444444444444,
        25: 0.006944444444444444,
        26: 0.006944444444444444,
        27: 0.006944444444444444,
        28: 0.006944444444444444,
        29: 0.006944444444444444,
        30: 0.006944444444444444,
        31: 0.006944444444444444,
        32: 0.006944444444444444,
        33: 0.006944444444444444,
        34: 0.006944444444444444,
        35: 0.006944444444444444,
        36: 0.006944444444444444,
        37: 0.006944444444444444,
        38: 0.006944444444444444,
        39: 0.006944444444444444,
        40: 0.006944444444444444,
        41: 0.006944444444444444,
        42: 0.006944444444444444,
        43: 0.006944444444444444,
        44: 0.006944444444444444,
        45: 0.006944444444444444,
        46: 0.006944444444444444,
        47: 0.006944444444444444,
        48: 0.006944444444444444,
        49: 0.006944444444444444,
        50: 0.006944444444444444,
        51: 0.006944444444444444,
        52: 0.006944444444444444,
        53: 0.006944444444444444,
        54: 0.006944444444444444,
        55: 0.006944444444444444,
        56: 0.006944444444444444,
        57: 0.006944444444444444,
        58: 0.006944444444444444,
        59: 0.006944444444444444,
        60: 0.006944444444444444,
        61: 0.006944444444444444,
        62: 0.006944444444444444,
        63: 0.006944444444444444,
        64: 0.006944444444444444,
        65: 0.006944444444444444,
        66: 0.006944444444444444,
        67: 0.006944444444444444,
        68: 0.006944444444444444,
        69: 0.006944444444444444,
        70: 0.006944444444444444,
        71: 0.006944444444444444,
        72: 0.006944444444444444,
        73: 0.006944444444444444,
        74: 0.006944444444444444,
        75: 0.006944444444444444,
        76: 0.006944444444444444,
        77: 0.006944444444444444,
        78: 0.006944444444444444,
        79: 0.006944444444444444,
        80: 0.006944444444444444,
        81: 0.006944444444444444,
        82: 0.006944444444444444,
        83: 0.006944444444444444,
        84: 0.006944444444444444,
        85: 0.006944444444444444,
        86: 0.006944444444444444,
        87: 0.006944444444444444,
        88: 0.006944444444444444,
        89: 0.006944444444444444,
        90: 0.006944444444444444,
        91: 0.006944444444444444,
        92: 0.006944444444444444,
        93: 0.006944444444444444,
        94: 0.006944444444444444,
        95: 0.006944444444444444,
        96: 0.006944444444444444,
        97: 0.006944444444444444,
        98: 0.006944444444444444,
        99: 0.006944444444444444,
        100: 0.006944444444444444,
        101: 0.006944444444444444,
        102: 0.006944444444444444,
        103: 0.006944444444444444,
        104: 0.006944444444444444,
        105: 0.006944444444444444,
        106: 0.006944444444444444,
        107: 0.006944444444444444,
        108: 0.006944444444444444,
        109: 0.006944444444444444,
        110: 0.006944444444444444,
        111: 0.006944444444444444,
        112: 0.006944444444444444,
        113: 0.006944444444444444,
        114: 0.006944444444444444,
        115: 0.006944444444444444,
        116: 0.006944444444444444,
        117: 0.006944444444444444,
        118: 0.006944444444444444,
        119: 0.006944444444444444,
        120: 0.006944444444444444,
        121: 0.006944444444444444,
        122: 0.006944444444444444,
        123: 0.006944444444444444,
        124: 0.006944444444444444,
        125: 0.006944444444444444,
        126: 0.006944444444444444,
        127: 0.006944444444444444,
        128: 0.006944444444444444,
        129: 0.006944444444444444,
        130: 0.006944444444444444,
        131: 0.006944444444444444,
        132: 0.006944444444444444,
        133: 0.006944444444444444,
        134: 0.006944444444444444,
        135: 0.006944444444444444,
        136: 0.006944444444444444,
        137: 0.006944444444444444,
        138: 0.006944444444444444,
        139: 0.006944444444444444,
        140: 0.006944444444444444,
        141: 0.006944444444444444,
        142: 0.006944444444444444,
        143: 0.006944444444444444,
        144: 0.0,
        145: 0.0,
        146: 0.0,
        147: 0.0,
        148: 0.0,
        149: 0.0,
        150: 0.0,
        151: 0.0,
        152: 0.0,
        153: 0.0,
        154: 0.0,
        155: 0.0,
        156: 0.0,
        157: 0.0,
        158: 0.0,
        159: 0.0,
        160: 0.0,
        161: 0.0,
        162: 0.0,
        163: 0.0,
        164: 0.0,
        165: 0.0,
        166: 0.0,
        167: 0.0}

    def setUp(self) -> None:
        """Create container database in memory"""
        sqlite_db = setup_sqlite_in_memory_db()
        sqlite_db.create_tables([
            TruckArrivalDistribution
        ])
        truck_arrival_distribution_seeder.seed()
        self.repository = TruckArrivalDistributionRepository()

    def test_get(self):
        distribution = self.repository.get_distribution()
        self.assertTrue(type(distribution), dict)
        hour_in_the_week_values = distribution.keys()
        self.assertGreaterEqual(min(hour_in_the_week_values), 0)
        self.assertLessEqual(max(hour_in_the_week_values), (24 * 7))
        sum_of_all_fractions = sum(distribution.values())
        self.assertAlmostEqual(sum_of_all_fractions, 1)

    def test_happy_path(self):
        self.repository.set_distribution(
            self.default_data
        )
        self.assertDictEqual(
            self.default_data,
            self.repository.get_distribution()
        )

    def test_set_twice(self):
        """e.g., no exception is thrown while refreshing the data in the database.
        """
        self.repository.set_distribution(
            self.default_data
        )
        self.repository.set_distribution(
            self.default_data
        )
        self.assertDictEqual(
            self.default_data,
            self.repository.get_distribution()
        )
