from conflowgen.domain_models.distribution_repositories.truck_arrival_distribution_repository import \
    TruckArrivalDistributionRepository

#: This distribution assigns each hour of the week to the fraction of trucks that arrive during this time window.
#: The distribution is based on real data of a project that took place approximately between 2013 and 2017.
#: To ensure confidentiality, the distribution has been slightly distorted.
DEFAULT_TRUCK_ARRIVAL_DISTRIBUTION_WITH_NO_ARRIVAL_MANAGEMENT = dict(list(enumerate(
    [0.0, 0.0, 0.0, 0.0, 0.0, 0.0039591265543534575, 0.008280755354708402, 0.00787052138708076,
     0.009048448164603814, 0.010653252222483504, 0.012752141622641803, 0.016642037255734387, 0.014028517880762,
     0.014804115031537253, 0.014974413128949352, 0.011139325718994135, 0.013892795598075644,
     0.01082340227148447, 0.008328057746798652, 0.006987426702627708, 0.005148702946956847,
     0.0030022110241690898, 0.0022556664886468924, 0.002490824815783658, 0.001903829363512033,
     0.0021963463393818504, 0.001702371138626582, 0.0021438383478597847, 0.0024202228363111615,
     0.006458109051981418, 0.009296920847765565, 0.008129901930327036, 0.009348584294496615,
     0.011340930095712323, 0.013698448606867216, 0.01296799663104594, 0.015331193639106963,
     0.014188986240397503, 0.014878231656167027, 0.01218616653188358, 0.012107579394020204,
     0.010917000115475164, 0.006806732487834122, 0.005802918750649381, 0.005287802279192979,
     0.0028202830127811215, 0.0019358005313836828, 0.0024196460473237236, 0.0016307576755443523,
     0.0019988666796929904, 0.001446034417884346, 0.0010097489273788896, 0.0022229861377374384,
     0.008228976109664983, 0.00916729394725238, 0.008981193048564363, 0.010437595120044508,
     0.011883447250428468, 0.013126241314098189, 0.0140232137102564, 0.014067510063763042, 0.017925057408950704,
     0.014893617277832918, 0.01301145426124103, 0.012079362990869175, 0.010112961782918234, 0.00893673181616467,
     0.006631710275002562, 0.004326674554006004, 0.004305598082248182, 0.0022903162137174965,
     0.0024661555911701296, 0.0011415664927662006, 0.0012494109397148158, 0.0009989509275061823,
     0.0009419532259761962, 0.002040252335905318, 0.00518431625514197, 0.009913000508486947,
     0.010654141394182583, 0.010344655620812727, 0.012472178423578372, 0.015253769000857457,
     0.015313545656682602, 0.01971921057376204, 0.016488565599922105, 0.016894274684674377,
     0.015499123208186931, 0.01478237177250456, 0.012150479118805851, 0.008135216144988145,
     0.006333340451456769, 0.006095849295750999, 0.004708883365054937, 0.003413326087863949,
     0.0017118289895981984, 0.0026912758548089605, 0.0021584624941145677, 0.0023228922170533146,
     0.001604168692757123, 0.0027305554397402476, 0.0065523938632102915, 0.009520380832912196,
     0.010997001773196237, 0.010602136875550094, 0.015899660970804596, 0.018083220148664984, 0.0163816471763427,
     0.01629007302430533, 0.019168920074881534, 0.01646589595887871, 0.013656904790633789, 0.012617169136636602,
     0.009685606800402495, 0.009069337128450136, 0.004422493262915178, 0.0042658850465993456,
     0.0030436628208826318, 0.0016924428501923685, 0.002152265219068244, 0.0028091995053135693,
     0.0022128380816916287, 0.0020158483718963533, 0.0010395871009478725, 0.0009474696390102265,
     0.0011628071003245448, 0.001418797422137764, 0.0016522620284370162, 0.0015376248047583672,
     0.0014253278743416424, 0.0007202777097896012, 0.0005074102872076632, 0.0004608008040356385, 0.0, 0.0, 0.0,
     0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
    + ([0] * 24)  # Sunday
)))

#: This distribution assigns each hour of the week to the fraction of trucks that arrive during this time window.
#: The distribution is based on an interview with the operational staff of a container terminal.
#: To ensure confidentiality, the distribution has been slightly distorted.
DEFAULT_TRUCK_ARRIVAL_DISTRIBUTION_WITH_SLOT_BOOKING = dict(list(enumerate(
    [0.0, 0.0, 0.0, 0.001568627450980392, 0.001568627450980392, 0.001568627450980392, 0.009411764705882352,
     0.011764705882352941, 0.013333333333333334, 0.01411764705882353, 0.014509803921568627,
     0.014901960784313726, 0.014509803921568627, 0.01411764705882353, 0.014901960784313726, 0.01568627450980392,
     0.01568627450980392, 0.011764705882352941, 0.00784313725490196, 0.005490196078431373, 0.004705882352941176,
     0.002352941176470588, 0.00196078431372549, 0.001568627450980392, 0.001176470588235294,
     0.001176470588235294, 0.001568627450980392, 0.001568627450980392, 0.001568627450980392,
     0.001568627450980392, 0.009411764705882352, 0.011764705882352941, 0.013333333333333334,
     0.01411764705882353, 0.014509803921568627, 0.014901960784313726, 0.014509803921568627, 0.01411764705882353,
     0.014901960784313726, 0.01568627450980392, 0.01568627450980392, 0.011764705882352941, 0.00784313725490196,
     0.005490196078431373, 0.004705882352941176, 0.002352941176470588, 0.00196078431372549,
     0.001568627450980392, 0.001176470588235294, 0.001176470588235294, 0.001568627450980392,
     0.001568627450980392, 0.001568627450980392, 0.001568627450980392, 0.009411764705882352,
     0.011764705882352941, 0.013333333333333334, 0.01411764705882353, 0.014509803921568627,
     0.014901960784313726, 0.014509803921568627, 0.01411764705882353, 0.014901960784313726, 0.01568627450980392,
     0.01568627450980392, 0.011764705882352941, 0.00784313725490196, 0.005490196078431373, 0.004705882352941176,
     0.002352941176470588, 0.00196078431372549, 0.001568627450980392, 0.001176470588235294,
     0.001176470588235294, 0.001568627450980392, 0.001568627450980392, 0.001568627450980392,
     0.001568627450980392, 0.009411764705882352, 0.011764705882352941, 0.013333333333333334,
     0.01411764705882353, 0.014509803921568627, 0.014901960784313726, 0.014509803921568627, 0.01411764705882353,
     0.014901960784313726, 0.01568627450980392, 0.01568627450980392, 0.011764705882352941, 0.00784313725490196,
     0.005490196078431373, 0.004705882352941176, 0.002352941176470588, 0.00196078431372549,
     0.001568627450980392, 0.001176470588235294, 0.001176470588235294, 0.001568627450980392,
     0.001568627450980392, 0.001568627450980392, 0.001568627450980392, 0.009411764705882352,
     0.011764705882352941, 0.013333333333333334, 0.01411764705882353, 0.014509803921568627,
     0.014901960784313726, 0.014509803921568627, 0.01411764705882353, 0.014901960784313726, 0.01568627450980392,
     0.01568627450980392, 0.011764705882352941, 0.00784313725490196, 0.005490196078431373, 0.004705882352941176,
     0.002352941176470588, 0.00196078431372549, 0.001568627450980392, 0.001176470588235294,
     0.001176470588235294, 0.001568627450980392, 0.001568627450980392, 0.001568627450980392,
     0.001568627450980392, 0.001568627450980392, 0.001568627450980392, 0.001568627450980392,
     0.001568627450980392, 0.001568627450980392, 0.001176470588235294, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
     0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
     0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
)))


def seed(assume_tas: bool = False):
    """
    Seeds the database with some initial values for the arrivals. The distributions are inspired by expert interviews.

    Args:
        assume_tas: whether a truck appointment system is assumed. Usually, with such a system the peak around lunchtime
           is flattened and more traffic is shifted to the morning hours.
    """
    if assume_tas:
        distribution = DEFAULT_TRUCK_ARRIVAL_DISTRIBUTION_WITH_SLOT_BOOKING
    else:
        distribution = DEFAULT_TRUCK_ARRIVAL_DISTRIBUTION_WITH_NO_ARRIVAL_MANAGEMENT
    repository = TruckArrivalDistributionRepository()
    repository.set_distribution(distribution)
