# -*- coding: utf-8 -*-
"""empty message

Revision ID: roc_guest_0001_initial
Revises: poppy_pop_0001_initial
Create Date: 2020-11-20 16:24:09.119637

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_guest_0001_initial'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():

    create_schema('gse')  # added by hand

    ## delete the types if they exist
    execute('DROP TYPE IF EXISTS gse.test_state_type')
    execute('DROP TYPE IF EXISTS gse.test_status_type')

    # ### commands auto generated by Alembic - please adjust! ###
    create_table('invalid_packet_log',
    sa.Column('id_invalid_packet_log', sa.BIGINT(), nullable=False),
    sa.Column('idb_version', sa.String(length=128), nullable=True),
    sa.Column('idb_source', sa.String(length=128), nullable=True),
    sa.Column('apid', sa.INTEGER(), nullable=True),
    sa.Column('binary', sa.String(), nullable=False),
    sa.Column('comment', sa.String(), nullable=True),
    sa.Column('insertion_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=True),
    sa.Column('srdb_id', sa.String(length=16), nullable=True),
    sa.Column('sha', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id_invalid_packet_log'),
    sa.UniqueConstraint('binary'),
    schema='gse'
    )
    create_table('packet_log',
    sa.Column('id_packet_log', sa.BIGINT(), nullable=False),
    sa.Column('length', sa.INTEGER(), nullable=False),
    sa.Column('type', sa.String(length=8), nullable=False),
    sa.Column('category', sa.String(length=512), nullable=False),
    sa.Column('apid', sa.INTEGER(), nullable=True),
    sa.Column('sync_flag', sa.BOOLEAN(), nullable=True),
    sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('srdb_id', sa.String(length=16), nullable=False),
    sa.Column('palisade_id', sa.String(length=256), nullable=False),
    sa.Column('binary', sa.String(), nullable=False),
    sa.Column('sha', sa.String(), nullable=True),
    sa.Column('idb_version', sa.String(length=128), nullable=True),
    sa.Column('idb_source', sa.String(length=128), nullable=True),
    sa.Column('creation_time', sa.String(length=1024), nullable=True),
    sa.Column('ack_exe_state', sa.String(length=16), nullable=True),
    sa.Column('ack_acc_state', sa.String(length=16), nullable=True),
    sa.Column('sequence_name', sa.String(length=16), nullable=True),
    sa.Column('unique_id', sa.String(length=256), nullable=True),
    sa.Column('insertion_time', postgresql.TIMESTAMP(), nullable=False),
    sa.PrimaryKeyConstraint('id_packet_log'),
    sa.UniqueConstraint('utc_time', 'srdb_id'),
    schema='gse'
    )
    create_table('test_log',
    sa.Column('id_test_log', sa.BIGINT(), nullable=False),
    sa.Column('test_id', sa.String(length=48), nullable=False),
    sa.Column('test_name', sa.String(length=512), nullable=False),
    sa.Column('test_sha', sa.String(length=512), nullable=True),
    sa.Column('test_version', sa.String(length=16), nullable=True),
    sa.Column('test_state', postgresql.ENUM('OK', 'WARNING', 'ERROR', name='test_state_type', schema='gse'), nullable=True),
    sa.Column('test_status', postgresql.ENUM('Running', 'Pending', 'Terminated', name='test_status_type', schema='gse'), nullable=False),
    sa.Column('test_creation_date', postgresql.TIMESTAMP(), nullable=True),
    sa.Column('test_insert_date', postgresql.TIMESTAMP(), nullable=True),
    sa.Column('test_descr', sa.String(length=512), nullable=True),
    sa.Column('test_author', sa.String(length=512), nullable=True),
    sa.Column('test_launched', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('test_terminated', postgresql.TIMESTAMP(), nullable=False),
    sa.Column('file_parent', sa.String(length=512), nullable=True),
    sa.PrimaryKeyConstraint('id_test_log'),
    sa.UniqueConstraint('test_id'),
    schema='gse'
    )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        'GRANT USAGE, SELECT ON ALL SEQUENCES IN ' 'SCHEMA gse TO {0}'.format(user)
    )
    execute(grant_user_seq)

def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('test_log', schema='gse')
    drop_table('packet_log', schema='gse')
    drop_table('invalid_packet_log', schema='gse')
    # ### end Alembic commands ###

    ## delete the types if they exist
    execute('DROP TYPE IF EXISTS gse.test_state_type')
    execute('DROP TYPE IF EXISTS gse.test_status_type')
