# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-02-24 13:49
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


from cmsplugin_blocks.choices_helpers import (
    get_album_default_template,
    get_album_template_choices,
    get_card_default_template,
    get_card_template_choices,
    get_hero_default_template,
    get_hero_template_choices,
    get_slider_default_template,
    get_slider_template_choices
)


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0016_auto_20160608_1535'),
    ]

    operations = [
        migrations.CreateModel(
            name='Album',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cmsplugin_blocks_album', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(default='', max_length=150, verbose_name='Title')),
                ('template', models.CharField(choices=get_album_template_choices(), default=get_album_default_template(), help_text='Used template for content formatting.', max_length=150, verbose_name='Template')),
            ],
            options={
                'verbose_name_plural': 'Albums',
                'verbose_name': 'Album',
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='AlbumItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, default='', max_length=150, verbose_name='Title')),
                ('order', models.IntegerField(default=0, verbose_name='Order')),
                ('image', models.ImageField(default=None, max_length=255, null=True, upload_to='blocks/album/%y/%m', verbose_name='Image')),
                ('album', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='album_item', to='cmsplugin_blocks.Album')),
            ],
            options={
                'verbose_name_plural': 'Album items',
                'verbose_name': 'Album item',
            },
        ),
        migrations.CreateModel(
            name='Card',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cmsplugin_blocks_card', serialize=False, to='cms.CMSPlugin')),
                ('alignment', models.CharField(choices=[('left', 'Content to the left, image to the right'), ('right', 'Image to the left, content to the reft')], default='left', max_length=15, verbose_name='Alignment')),
                ('template', models.CharField(choices=get_card_template_choices(), default=get_card_default_template(), help_text='Used template for content look.', max_length=150, verbose_name='Template')),
                ('image', models.ImageField(blank=True, default=None, max_length=255, null=True, upload_to='blocks/card/%y/%m', verbose_name='Image')),
                ('content', models.TextField(default='', verbose_name='Content')),
            ],
            options={
                'verbose_name_plural': 'Cards',
                'verbose_name': 'Card',
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='Hero',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cmsplugin_blocks_hero', serialize=False, to='cms.CMSPlugin')),
                ('template', models.CharField(choices=get_hero_template_choices(), default=get_hero_default_template(), help_text='Used template for content look.', max_length=150, verbose_name='Template')),
                ('image', models.ImageField(blank=True, default=None, max_length=255, null=True, upload_to='blocks/hero/%y/%m', verbose_name='Image')),
                ('content', models.TextField(default='', verbose_name='Content')),
            ],
            options={
                'verbose_name_plural': 'Heros',
                'verbose_name': 'Hero',
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='SlideItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(default=None, max_length=255, null=True, upload_to='blocks/slider/%y/%m', verbose_name='Image')),
                ('content', models.TextField(blank=True, default='', verbose_name='Content')),
                ('link_name', models.CharField(blank=True, max_length=45, verbose_name='link name')),
                ('link_url', models.CharField(blank=True, max_length=255, verbose_name='link url')),
                ('link_open_blank', models.BooleanField(default=False, help_text='If checked the link will be open in a new window', verbose_name='open new window')),
            ],
            options={
                'verbose_name_plural': 'Slide items',
                'verbose_name': 'Slide item',
            },
        ),
        migrations.CreateModel(
            name='Slider',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='cmsplugin_blocks_slider', serialize=False, to='cms.CMSPlugin')),
                ('title', models.CharField(default='', max_length=150, verbose_name='Title')),
                ('template', models.CharField(choices=get_slider_template_choices(), default=get_slider_default_template(), help_text='Used template for content look.', max_length=150, verbose_name='Template')),
            ],
            options={
                'verbose_name_plural': 'Sliders',
                'verbose_name': 'Slider',
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.AddField(
            model_name='slideitem',
            name='slider',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='slide_item', to='cmsplugin_blocks.Slider'),
        ),
    ]
